#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10246);
 script_cve_id("CAN-2000-0213");
 
 name["english"] = "Sambar Web Server CGI scripts";
 name["francais"] = "Scripts CGI du serveur web Sambar";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
At least one of these CGI is installed :

	hello.bat
	echo.bat
	
They allow any attacker to execute commands
with the privileges of this web server.	

Solution : Delete all the *.bat files from your cgi-bin/ 
           directory
Risk factor : High";


 desc["francais"] = "
Au moins un de ces CGI est install :

	hello.bat
	echo.bat
	
Ils permettent  n'importe quel pirate d'executer
des commandes arbitraires sur ce systme, avec
les privilges du serveur web.

Solution : effacez tous les fichiers .bat du
           rprtoire cgi-bin/        
Facteur de risque : Elev";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/{hello,echo}.bat";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/{hello,echo}.bat";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

hello = is_cgi_installed("hello.bat");
echo = is_cgi_installed("echo.bat");
sum = hello+echo;
if(sum)
{
 port = get_kb_item("Services/www");
 if(!port)port = 80;
 security_hole(port);
}
