#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10201);
 name["english"] = "Relative IP Identification number change";
 script_name(english:name["english"]);
 
 desc["english"] = "Take a look at the relative change of the IP identification, retrieved from
the IP stack. If the change isn't sufficiently randomized, a remote attacker
can know the amount of packets the remote computer is currently receiving.
This can help a remote attacker create successful attacks, such as Session
Hijacking and Session Spoofing. The nature of these attacks require an
attacker to predict certain changes in the TCP/IP stack, which can be done
with the help of knowing the amount of traffic the remote computer is
receiving.

More Information:
http://www.securiteam.com/unixfocus/Linux_vulnerable_to_Blind_TCP_Spoofing.html

Risk factor : Depends on the outcome.";

 script_description(english:desc["english"]);
 
 summary["english"] = "Relative IP Identification number change";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 1999 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);

 
 exit(0);
}

#
# The script code starts here
#

# localhost results are bogus
if(islocalhost())exit(0);

srcaddr = this_host();
dstaddr = get_host_ip();

IPH = 20;
IP_LEN = IPH; 

ip = forge_ip_packet(   ip_v : 4,
			ip_hl : 5,
			ip_tos : 0,
			ip_len : IP_LEN, 
		        ip_id : 0xABA,
			ip_p : IPPROTO_TCP,
			ip_ttl : 255,
		        ip_off : 0,
			ip_src : srcaddr,
			ip_dst : dstaddr);

port = get_host_open_port();
if(!port)port = 137;
 
tcpip = forge_tcp_packet(    ip       : ip,
                             th_sport : port,
                             th_dport : port,
                             th_flags : 0,
                             th_seq   : 0xF1C,
                             th_ack   : 0,
                             th_x2    : 0,
                             th_off   : 5,
                             th_win   : 512,
                             th_urp   : 0);

filter = string("tcp and (src addr ", dstaddr, " and dst addr ", srcaddr, " dst port ", port, ")"); 

data_warning = "
If numbers are close together, or rise by the same number all the time,
it means that the amount of traffic can be predicted by monitoring
changes in the idetification numbers (since these aren't randomized
enough).

This may help attackers with several other attacks, such as Session
Hijacking or with Session Spoofing, where in those cases the attacker
needs to predict certain charactistics of the attacked computer (such
as traffic size).

The IP Identification numbers retrieved and their relative size were: 
";

relative = -1;  
answer_count = 0;
for (packet_count = 0; packet_count < 10; packet_count = packet_count + 1)  
{
 result = send_packet(tcpip, pcap_active:TRUE, filter:filter);
 if ((packet_count > 5) && (answer_count == 0))
 {
  exit(0);
 }

 if (result)
 {
  answer_count = answer_count + 1;
  ip_id = get_ip_element(ip:result, element:"ip_id");
  if (relative == -1)
  {
   relative = ip_id;
   data_warning = data_warning + string("ID: ", ip_id, "\n");
  }
  else
  {
   if(ip_id > relative){
   	max = ip_id;
	min = relative;
	}
   else {
   	max = relative;
	min = ip_id;
	}
   relative = max - min;
   data_warning = data_warning + string("ID: ", ip_id, " relative size: ", relative, "\n");
   relative = ip_id;
  }
 }
}

if (answer_count) security_warning(port:0, data:data_warning);

