#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10187);

 name["english"] = "Cognos Powerplay WE Vulnerability";
 name["francais"] = "Cognos Powerplay WE Vulnerability";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
 The CGI ppdscgi.exe, part of the PowerPlay 
Web Edition package, is installed.

Due to design problems as well as some 
potential web server misconfiguration 
PowerPlay Web Edition may serve up data 
cubes in a non-secure manner. Execution 
of the PowerPlay CGI pulls cube data into 
files in an unprotected temporary directory. 
Those files are then fed back to frames in 
the browser. In some cases it is trivial for an
unauthenticated user to tap into those data 
files before they are purged.

Solution : Cognos doesn't consider this
problem as being an issue, so they
did not provide any solution.

Risk factor : Medium";

 
 desc["francais"] = "
Le cgi ppdscgi.exe, appartenant au
package PowerPlay Web Edition, est
install.

A cause de certains problmes de 
conception ainsi que d'une eventuelle
mauvaise configuration du serveur
web, PowerPlay Web Edition peut
servir des 'data cubes' de 
maniere non scurise.

L'execution du CGI PowerPlay met
les CGIs dans un dossier temporaire
non protg. Ces fichiers sont 
ensuite renvoys dans les frames du
browser. Dans certains cas, il
peut tre trivial pour un utilisateur
non authentifi de lire ces fichiers
avant qu'ils ne soient effacs.

Solution : Cognos ne considere pas ceci
comme tant un problme et n'offre pas
de solution. 

Facteur de risque : Moyen";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the ppdscgi.exe CGI";
 summary["francais"] = "Vrifie la prsence de ppdscgi.exe";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;
if(is_cgi_installed("ppdscgi.exe"))security_warning(port);
