#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10386);

 name["english"] = "No 404 check";
 name["francais"] = "No 404 check";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
Some web servers do not display 404 error codes
when they are requested invalid pages.

This script will retrieve the default page which
is issued when an invalid file is requested, and
will attempt to minimize the risks of false positives
for the other tests";


 desc["francais"] = "
Certains serveurs web n'affichent pas d'erreur 404
lorsqu'un client leur demande une page qui n'existe
pas.

Ce script rcupre donc la page d'erreur qui est
affiche et la garde en mmoire afin de pouvoir
minimiser par la suite les risques d'erreur
dus a ce comportement";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks if the remote webserver issues 404 errors";
 summary["francais"] = "Vrifie que le serveur web distant sort des erreurs 404");
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

if(is_cgi_installed("nessus_is_probing_this_host"))
{
 port = get_kb_item("Services/www");
 if(!port)port = 80;
 soc = open_sock_tcp(port);
 if(soc)
 {
  req = string("GET /nessus_is_probing_you_",rand()," HTTP/1.0\r\n\r\n");
  send(socket:soc, data:req);
  r = recv_line(socket:soc, length:1024);
  
  #
  # skip the header
  #
  while(strlen(r) > 2)
  {
   r = recv_line(socket:soc, length:1024);
  }
  
  r = recv(socket:soc, length:4096);
  set_kb_item(name:"www/no404", value:r); 
  close(soc);
 }
}
