#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10360);
 script_cve_id("CVE-1999-0191");

 name["english"] = "newdsn.exe check";
 name["francais"] = "verification de newdsn.exe";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The CGI /scripts/tools/newdsn.exe is present.

This CGI allows any cracker to create files
anywhere on your system if your NTFS permissions
are not tight enough, and can be used to overwrite
DSNs on existing dabases.

Solution : remove it
Risk factor : High";


 desc["francais"] = "
Le CGI /scripts/tools/newdsn.exe est prsent.

Ce CGI permet  n'importe qui de crer des fichiers
a des endroits arbitraires sur votre systme
(pourvu que vos permissions NTFS soient laxistes)
ainsi que d'craser des DSNs sur des bases qui
existent.

Solution : retirez-le
Facteur de risque : Elev";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /scripts/tools/newdsn.exe";
 summary["francais"] = "Vrifie la prsence de /scripts/tools/newdsn.exe";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

cgi = "/scripts/tools/newdsn.exe";
if(is_cgi_installed(cgi))
{
 port = get_kb_item("Services/www");
 if(!port)port = 80;
 security_hole(port);
}
