#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10029);
 script_cve_id("CVE-1999-0833");
 
 name["english"] = "BIND vulnerable";
 name["francais"] = "BIND vulnerable";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The remote BIND server, according to its
version number, is vulnerable to several
attacks that can allow an attacker to gain
root on this system.

Solution : upgrade to bind 8.2.2-P3
Risk factor : High";


 desc["francais"] = "
D'aprs son numro de verson, le serveur BIND distant
est vulnrable  plusieurs attaques permettant 
un pirate de passer root aisment sur le serveur.

Solution : mettez  jour BIND en 8.2.2-P3
Facteur de risque : Elev";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks the remote BIND version";
 summary["francais"] = "Vrifie le numro de version du BIND distant";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencie("bind_version.nasl");
 script_require_keys("bind/version");
 exit(0);
}

vers = get_kb_item("bind/version");
if(!vers)exit(0);
if(vers < "8.2.2-P3")security_hole(53);
