#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10028);
 name["english"] = "Determine which version of BIND name daemon is running";
 script_name(english:name["english"]);
 
 desc["english"] = "It is possible to determine the version and type of a name daemon by querying a special 'Question Name', on BIND based named (unless configured to act otherwise), the server will respond with the BIND version.

Risk: Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determine which version of BIND name daemon is running";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 1999 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);

 exit(0);
}

#
# The script code starts here
#

 socudp53 = open_sock_udp(53);

 if (socudp53)
 {
  raw_data = raw_string(
			0x00, 0x0A, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x07);
  raw_data = raw_data + "VERSION";
  raw_data = raw_data + raw_string( 0x04 );
  raw_data = raw_data + "BIND";
  raw_data = raw_data + raw_string(
				   0x00, 0x00, 0x10, 0x00, 0x03);

  send(socket:socudp53, data:raw_data);
  result = recv(socket:socudp53, length:1000);
  if (result)
  {
    if ((result[0] == raw_string(0x00)) && (result[1] == raw_string(0x0A)))
    {
     if ((result[2] == raw_string(0x85)) && (result[3] == raw_string(0x80)))
     {
      if ((result[4] == raw_string(0x00)) && (result[5] == raw_string(0x01)))
	  {
       if ((result[6] == raw_string(0x00)) && (result[7] == raw_string(0x01)))
	   {
		size = rawtostr(result[53]);
		if (size > 0)
		{
		 hole_data = "";
		 for (i = 0; i < size - 1; i = i + 1)
		 {
		  hole_data = hole_data + result[55+i];
		 }
		 data = string("The remote bind version is : ", hole_data);
		 security_warning(port:53, data:data);
		 set_kb_item(name:"bind/version",value:hole_data); 
		}
	   }
	  }
     }
    }
  }
 close(socudp53);
 }

