/*
 * 
 * nfs_world_export
 *
 * This plugin was written by Renaud Deraison and is released
 * under the GPL
 *
 */
#include <includes.h>

#define EN_NAME "NFS world export"
#define FR_NAME "Rpertoire NFS export  tout le monde"

#define DESC "\
This plugin determines whether the remote NFS server\n\
is exporting files to the world, which is usually a bad\n\
idea.\n\
This plugin also checks whether the remote NFS server\n\
is superfluous or not\n\
Risk factor : High"

#define FR_DESC "\
Ce plug-in dtermines si le serveur NFS distant\n\
exporte des donnes au monde entier, ce qui est\n\
gnrallement une mauvaise ide.\n\
Il vrifie aussi si le serveur NFS distant est\n\
superflu ou non.\n\
Facteur de risque : Elev"


#define COPYRIGHT "Distributed under the GPL"
#define SUMM "check if a host exports a filesystem to anyone"


extern int showmount(char *hostname, char **result);


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_id(desc, 10334);
        plug_set_cve_id(desc, "CAN-1999-0554");
  
	plug_set_name(desc, FR_NAME, "francais");
	plug_set_name(desc, EN_NAME, NULL);
	
	plug_set_description(desc, FR_DESC, "francais");
	plug_set_description(desc, DESC, NULL);
	
	plug_set_summary(desc, SUMM,NULL);
	plug_set_copyright(desc, COPYRIGHT,NULL);
	
	plug_set_category(desc, ACT_ATTACK);
	plug_set_family(desc, "Accs aux fichiers distants", "francais");
	plug_set_family(desc, "Remote file access", NULL);
	
	plug_set_dep(desc, "rpc_portmap.nasl");
        plug_set_timeout(desc, 20);
	return(0);
}
	

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
  int res;
  char * data;
  
 if(!plug_get_key(args, "rpc/portmap"))return(0);
  res = !(showmount((char *)plug_get_hostname(args), &data));
  if (res)
  {
   if (strstr(data, "(everyone)"))
   	{
   	char * report = emalloc(strlen(data)+50);
   	sprintf(report, "Some filesystems are exported to __everyone__\n%s\n", data);
   	post_hole(args, 2049,report);
   	efree(&report);
   	efree(&data);
  }
 else {
 	if(!strlen(data))
 	{
         post_info(args, 2049, "The remote NFS server is superfluous : \n\
no filesystem are exported on the remote host\n\
Solution : disable it");
        }
	else {
		char * report = emalloc(strlen(data)+255);
		sprintf(report, "Here is the list of the exported filesystems :\n%s\n", data);
		post_info(args, 2049, report);
		efree(&report);
		efree(&data);
	     }
    }
  }
  return(0);
}
