#!/bin/bash

name="nessus-plugins"
checkfor="nessus.tmpl.in"

if test ! -f $checkfor; then
  echo "You need to run me from the $name root dir"
  exit 1
fi

case "`rpm --version`" in
  RPM\ version\ 2*)
    rpmdir="`rpm --showrc | grep ^rpmdir | awk '{ print $3}'`"
    sourcedir="`rpm --showrc | grep ^sourcedir | awk '{ print $3}'`"
    specdir="`rpm --showrc | grep ^specdir | awk '{ print $3}'`"
    srcrpmdir="`rpm --showrc | grep ^srcrpmdir | awk '{ print $3}'`"
    arch="`rpm --showrc | grep '^build arch' | awk '{ print $4}'`"
    ;;
  RPM\ version\ 3*)
    function ShowRc () {
	rpm --showrc | grep "^-[[:digit:]]\+:[[:space:]]\+$1[[:space:]]" \
	| sed "s/^-[[:digit:]]\+:[[:space:]]\+$1[[:space:]]\+//"
    }
    function GrepVar () {
        echo $1 | grep "%{.*}" | sed "s/.*%{\(.*\)}.*/\1/"
    }
    function ShowRcRec () {
      result="`ShowRc $1`"
      var="`GrepVar $result`"
      while test "x$var" != "x"; do
        rep="`ShowRc $var`"
	result="`echo $result | sed s,%{$var},$rep,g`"
        var="`GrepVar $result`"
      done
      echo $result
    }
    rpmdir="`ShowRcRec _rpmdir`"
    sourcedir="`ShowRcRec _sourcedir`"
    specdir="`ShowRcRec _specdir`"
    srcrpmdir="`ShowRcRec _srcrpmdir`"
    arch="`ShowRcRec _arch`"
    ;;
  *)
    echo "Don't know how to handle your RPM version: `rpm --version`"
    exit 1
    ;;
esac

#echo "rpmdir = $rpmdir"
#echo "sourcedir = $sourcedir"
#echo "specdir = $specdir"
#echo "srcrpmdir = $srcrpmdir"

version=`cat VERSION`
i=0
release=""
while test -z "$release"; do
  i=$[$i+1]
  srcrpmfile="$srcrpmdir/$name-$version-$i.src.rpm"
  if test ! -f $srcrpmfile; then
    release=$i
  fi
done
rm -rf $name-$version $sourcedir/$name-$version.tar \
    $sourcedir/$name-$version.tar.gz
mkdir $name-$version
tar cf - `cat MANIFEST` | (cd $name-$version; tar xf -)
tar cf $sourcedir/$name-$version.tar $name-$version
gzip --best $sourcedir/$name-$version.tar
rm -rf $name-$version
cat packaging/$name.spec \
  | sed -e "s/%define np_version .*/%define np_version $version/" \
        -e "s/%define np_release .*/%define np_release $release/" \
        >"$specdir/$name-$version-$release.specs"
rpm -ba --rmsource --clean "$specdir/$name-$version-$release.specs"
