/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*****************************************************************************\
*                                                                             *
* 				  KLPROFILER                                  *
* 				 DEFINITIONS                                  *
*                                                                             *
\*****************************************************************************/

#ifndef INCLUDE_KLPROFILER
#define INCLUDE_KLPROFILER

/* data structures used by the profiler */

typedef struct _KlProfilingTableEntry {
    KlMethod function;
    KlExpr expr;
} *KlProfilingTableEntry;

typedef struct _KlProfilingTableFree {
    KlMethod function;
    Int next;
} *KlProfilingTableFree;

typedef union _KlProfilingTableCell {
    struct _KlProfilingTableEntry used;
    struct _KlProfilingTableFree free;
} *KlProfilingTableCell;

extern KlO Kl__ELC();

/* the main cache table of all dummy tracing functions */
#ifndef INIT
extern KlProfilingTableCell *Kl__Funcs;
#endif
EXT Int Kl__FuncsFree INIT(0);		/* index of first free slot, -1 full */

#endif /* INCLUDE_KLPROFILER */
