/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*******************************\
* 			        *
*  Machine - dependent patches  *
* 			        *
\*******************************/

#if defined(__NUTC__)
#include <stdio.h>
#endif

#include "klmachine.h"

#ifdef SVR4
#include <sys/time.h>
#include <sys/resource.h>
#endif /* SVR4 */
#ifdef SYSV
#include <unistd.h>
#endif

/******* getpagesize just returns "pagesize" which is 8192 on most machines? */

#ifdef NO_GETPAGESIZE

int
getpagesize()
{
#ifdef PAGE_SIZE
    return PAGE_SIZE;
#else					/* PAGE_SIZE */
    return 8192;
#endif					/* PAGE_SIZE */
}

#endif					/* NO_GETPAGESIZE */

/*************************************************** getdtablesize emulation */

#ifdef NO_GETDTABLESIZE
#include <sys/resource.h>

int
getdtablesize()
{
# ifdef hpux
    return(sysconf(_SC_OPEN_MAX));	/* special version for HPUX 
					   (maybe all SYSVR4 in fact?) */
# else /* !hpux */
#  ifndef NO_RLIMIT
   struct rlimit limit;
   if (getrlimit(RLIMIT_NOFILE, &limit) < 0) { /* for SYSVR4 */
      perror("getdtablesize");
      exit(-1);
   }
   return limit.rlim_cur;
#  else /* NO_RLIMIT */
#   ifdef _NFILE
    return _NFILE;			/* just in case. but never encountered */
#   else /* ! _NFILE */
#    ifdef KLDTABLESIZE
    return KLDTABLESIZE;		/* all fails, lets fix it by hand... */
#    else /* !KLDTABLESIZE */
					/* ok, trap config error properly */
error="PLEASE, define KLDTABLESIZE to the number of available file descriptors"
#    endif /* !KLDTABLESIZE */
#   endif /* ! _NFILE */
#  endif /* NO_RLIMIT */
# endif /* !hpux */
}

#endif					/* NO_GETDTABLESIZE */
