/***************************************************************************
                          kmessedwords.cpp  -  description
                             -------------------
    begin                : Thu Jul 19 00:06:05 CEST 2001
    copyright            : (C) 2001 by Primoz Anzur (zer0Kode)
    email                : zerokode@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kmessedwords.moc"
#include "kmessedwords.h"

#include <kdebug.h>
#include <kglobal.h>
#include <qfile.h>

KMessedWords::KMessedWords(QWidget *parent, const char *name) : FrontEnd(parent, name)
{
setIcon(QPixmap(locate("icon","locolor/16x16/apps/kmessedwords.png")));
kMessedDataDir=locate("data","kmessedwords/");

setLocalDictionary=locateLocal("data","kmesswords/");
QFile f(setLocalDictionary+"easy.txt");
if (! f.exists())
{
	setLocalDictionary=locate("data","kmessedwords/");
}

setCaption(i18n ("KMessedWords %1").arg(LOCAL_VERSION));
guesses = 0;
setBackgroundPixmap(QPixmap(locate("data","kmessedwords/kmessedbg.png")));
showLoginScreen.show();
config = kapp->config();
shareLoginName=showLoginScreen.shareLoginName;
first_run(); //makes the config file and all...
check_update();
}

KMessedWords::~KMessedWords()
{
}

void KMessedWords::slot_close()
{
  close();
}

void KMessedWords::randomizer(int level)
{
reloadStructure();
if(level==0)
{
  lines=configInputData.easyDict->numLines();
  cleanWord=configInputData.easyDict->textLine(random.getLong(lines));
}
if(level==1)
{
  lines=configInputData.mediumDict->numLines();
  cleanWord=configInputData.mediumDict->textLine(random.getLong(lines));
}
if(level==2)
{
  lines=configInputData.hardDict->numLines();
  cleanWord=configInputData.hardDict->textLine(random.getLong(lines));
}

}

void KMessedWords::confuse_words()
{
  QList <QChar> messList;
  messList.setAutoDelete(true);

  // Put all letters of the word in the list
  for(unsigned int i = 0; i < cleanWord.length(); i++) { messList.append(new QChar(cleanWord[i])); }
  
  // Shuffle the list
  random.randomize(&messList);

  // Give the messed up string the right length.
  messedWord.fill(' ', cleanWord.length());

  // Copy all letters to the messed up string.
  for(unsigned int i = 0; i < cleanWord.length(); i++){ messedWord[i] = *(messList.at(i)); }
}


void KMessedWords::slot_messup()
{
  // enable Buttons on first button click
if (!guessedText->isEnabled())
{
	guessedText->setEnabled(true);
	txtGuess->setEnabled(true);
	btnTry->setEnabled(true);
	btnMess->setDefault(false);
}
randomizer(leveler->currentItem());
confuse_words();

//prevents clean words to be displayed...
if (cleanWord==messedWord)
{
	slot_messup();
//messups ++;  //this is for nothing more than monitoring the completenumbers of messed and clean words...
}
else
{
	messups++;
	mainScreen->setText(messedWord);
	guessedText->setFocus();
}

}

void KMessedWords::slot_try()
{
if(guessedText->text() != "")
{
guesses++;
tGuesses++;	
	if(guessedText->text()==cleanWord)
	{
		if (KMessageBox::questionYesNo(this,i18n("Congratulations! You guessed it in ") + guessedString.sprintf("%i", guesses) + i18n(" guess!!! \nWant to play anther game?"), "KMessedWords") ==4) //this kills theapp, if you don't wanna play anymore...
		{
			//scoring final calc thingy goes here :)
			solvedWords++;
			write_scores();
			justtext=i18n("Name: ") +  shareLoginName + "\n"+ i18n("Solved:") + justtext.sprintf("%i\n",  solvedWords)+ i18n ("Rounds:") + justtext.sprintf("%i\n" , messups);
			KMessageBox::information(this,justtext);
			close();
		}
		else
		{
			//scoring calc thingy goes here :)
			solvedWords++;
			guesses=0;
			guessedText->setText("");
			slot_messup();
		}
	}
	else
	{
		KMessageBox::information(this,i18n("You missed! Try again :o)"), "KMessedWords"); //this should be replaced by a graphical box [?]
		guessedText->setText("");
	}
}

}

void KMessedWords::slot_helpme()
{
kapp->invokeHelp("",""); //working on this one....
}

void KMessedWords::slot_textAccel()
{
if(guessedText->text() != "")
{
	slot_try();
}

}

void KMessedWords::slot_openBook()
{
showConfig.show();
}

void KMessedWords::reloadStructure()
{
//this too is a-must-have for the paths and fie checkings and stuff...
setLocalDictionary=locateLocal("data","kmesswords/");
QFile f(setLocalDictionary+"easy.txt");
if (! f.exists())
{
	setLocalDictionary=locate("data","kmessedwords/");
}

//this is just a patch.. It reloads the files into the dictionary buffer...
QFile openEasyFile(setLocalDictionary+"easy.txt");
openEasyFile.open(IO_ReadOnly);
QTextStream readEasyStr(&openEasyFile);
configInputData.easyDict->setText(readEasyStr.read());
openEasyFile.close();

QFile openMediumFile(setLocalDictionary+"medium.txt");
openMediumFile.open(IO_ReadOnly);
QTextStream readMediumStr(&openMediumFile);
configInputData.mediumDict->setText(readMediumStr.read());
openMediumFile.close();

QFile openHardFile(setLocalDictionary+"hard.txt");
openHardFile.open(IO_ReadOnly);
QTextStream readHardStr(&openHardFile);
configInputData.hardDict->setText(readHardStr.read());
openHardFile.close();
}

void KMessedWords::slot_scores()
{
showScores.show(); //much better solution... It shows only one instance of the window...
}

void KMessedWords::read_scores()
{
for (int i=0; i<=9; i++)
{
	config->setGroup("Easy_scores");
	readName[i]=config->readEntry(varnames.sprintf("name%i",i),0);
	readSolved[i]=config->readNumEntry(varsolved.sprintf("solved%i",i),0);
	readRounds[i]=config->readNumEntry(varrounds.sprintf("rounds%i",i),0);
	config->sync();
}

}

void KMessedWords::write_scores()
{
//this is for the levels...
if (leveler->currentItem()==0)
{
	for (int i=0; i<=9; i++) //we load everything in cache
	{
		config->setGroup("Easy_scores");
		readName[i]=config->readEntry(varnames.sprintf("name%i",i),"");
		readSolved[i]=config->readNumEntry(varsolved.sprintf("solved%i",i),0);
		readRounds[i]=config->readNumEntry(varrounds.sprintf("rounds%i",i),0);
		readGuesses[i]=config->readNumEntry(varguesses.sprintf("guesses%i",i),0);
		config->sync();
	}

	int a;	
	for (int i=9; i>=0; i--) //...and now we check each score from lowest to highest
	{
		if ((readSolved[i]<=solvedWords) && (readSolved[i-1]>solvedWords))
		{
			config->writeEntry(varnames.sprintf("name%i",i), shareLoginName);
			config->writeEntry(varsolved.sprintf("solved%i",i),solvedWords);
			config->writeEntry(varrounds.sprintf("rounds%i",i),messups);
			config->writeEntry(varguesses.sprintf("guesses%i",i),tGuesses);
			a=i;
		}

	}

	for (int x=a;  x<=9; x++) //this will write the scores for a level lower...
	{
		config->writeEntry(varnames.sprintf("name%i",x+1), readName[x]);
		config->writeEntry(varsolved.sprintf("solved%i",x+1),readSolved[x]);
		config->writeEntry(varrounds.sprintf("rounds%i",x+1),readRounds[x]);
		config->writeEntry(varguesses.sprintf("guesses%i",x+1),readGuesses[x]);
	}
}
else if (leveler->currentItem()==1)
{
	for (int i=0; i<=9; i++) //we load everything in cache
	{
		config->setGroup("Medium_scores");
		readName[i]=config->readEntry(varnames.sprintf("name%i",i),"");
		readSolved[i]=config->readNumEntry(varsolved.sprintf("solved%i",i),0);
		readRounds[i]=config->readNumEntry(varrounds.sprintf("rounds%i",i),0);
		readGuesses[i]=config->readNumEntry(varguesses.sprintf("guesses%i",i),0);
		config->sync();
	}

	int a;	
	for (int i=9; i>=0; i--) //...and now we check each score from lowest to highest
	{
		if ((readSolved[i]<=solvedWords) && (readSolved[i-1]>solvedWords))
		{
			config->writeEntry(varnames.sprintf("name%i",i), shareLoginName);
			config->writeEntry(varsolved.sprintf("solved%i",i),solvedWords);
			config->writeEntry(varrounds.sprintf("rounds%i",i),messups);
			config->writeEntry(varguesses.sprintf("guesses%i",i),tGuesses);
			a=i;
		}

	}

	for (int x=a;  x<=9; x++) //this will write the scores for a level lower...
	{
		config->writeEntry(varnames.sprintf("name%i",x+1), readName[x]);
		config->writeEntry(varsolved.sprintf("solved%i",x+1),readSolved[x]);
		config->writeEntry(varrounds.sprintf("rounds%i",x+1),readRounds[x]);
		config->writeEntry(varguesses.sprintf("guesses%i",x+1),readGuesses[x]);
	}
}
else if (leveler->currentItem()==2)
{
	for (int i=0; i<=9; i++) //we load everything in cache
	{
		config->setGroup("Hard_scores");
		readName[i]=config->readEntry(varnames.sprintf("name%i",i),"");
		readSolved[i]=config->readNumEntry(varsolved.sprintf("solved%i",i),0);
		readRounds[i]=config->readNumEntry(varrounds.sprintf("rounds%i",i),0);
		readGuesses[i]=config->readNumEntry(varguesses.sprintf("guesses%i",i),0);
		config->sync();
	}

	int a;	
	for (int i=9; i>=0; i--) //...and now we check each score from lowest to highest
	{
		if ((readSolved[i]<=solvedWords) && (readSolved[i-1]>solvedWords))
		{
			config->writeEntry(varnames.sprintf("name%i",i), shareLoginName);
			config->writeEntry(varsolved.sprintf("solved%i",i),solvedWords);
			config->writeEntry(varrounds.sprintf("rounds%i",i),messups);
			config->writeEntry(varguesses.sprintf("guesses%i",i),tGuesses);
			a=i;
		}

	}

	for (int x=a;  x<=9; x++) //this will write the scores for a level lower...
	{
		config->writeEntry(varnames.sprintf("name%i",x+1), readName[x]);
		config->writeEntry(varsolved.sprintf("solved%i",x+1),readSolved[x]);
		config->writeEntry(varrounds.sprintf("rounds%i",x+1),readRounds[x]);
		config->writeEntry(varguesses.sprintf("guesses%i",x+1),readGuesses[x]);
	}
}

}

void KMessedWords::first_run()
{
config->setGroup("First_run");
if (config->readBoolEntry("Run",true)==true)
{
	config->sync();
	for (int i=0; i<=9; i++)
	{
		config->setGroup("Easy_scores");
		config->writeEntry(varnames.sprintf("name%i",i),"Anonymus");
		config->writeEntry(varsolved.sprintf("solved%i",i),"0");
		config->writeEntry(varrounds.sprintf("rounds%i",i),"0");
		config->writeEntry(varguesses.sprintf("guesses%i",i),"0");
		config->sync();
	
		config->setGroup("Medium_scores");
		config->writeEntry(varnames.sprintf("name%i",i),"Anonymus");
		config->writeEntry(varsolved.sprintf("solved%i",i),"0");
		config->writeEntry(varrounds.sprintf("rounds%i",i),"0");
		config->writeEntry(varguesses.sprintf("guesses%i",i),"0");
		config->sync();

		config->setGroup("Hard_scores");
		config->writeEntry(varnames.sprintf("name%i",i),"Anonymus");
		config->writeEntry(varsolved.sprintf("solved%i",i),"0");
		config->writeEntry(varrounds.sprintf("rounds%i",i),"0");
		config->writeEntry(varguesses.sprintf("guesses%i",i),"0");
		config->sync();
	}
	config->setGroup("First_run");
	config->writeEntry("Run","false");
	config->sync();
}

}

void KMessedWords::slot_changeLevel()
{
//a complete reset for other levels... [docs?]
KMessageBox::information(this,i18n("Now playing another level"));
messups=0;
solvedWords=0;
guesses=0;
tGuesses=0;
guessedText->setText("");
//we have to lock it up for the other level...
guessedText->setEnabled(false);
txtGuess->setEnabled(false);
btnTry->setEnabled(false);
btnMess->setDefault(true);
}

void KMessedWords::check_update()
{
config->setGroup("Version");
if (config->readEntry("version","") !="1.0.0")
{
	config->sync();
	for (int i=0; i<=9; i++)
	{
		config->setGroup("Easy_scores");
		config->writeEntry(varnames.sprintf("guesses%i",i),"0");
		config->sync();
	
		config->setGroup("Medium_scores");
		config->writeEntry(varnames.sprintf("guesses%i",i),"0");
		config->sync();

		config->setGroup("Hard_scores");
		config->writeEntry(varnames.sprintf("guesses%i",i),"0");
		config->sync();
	}
	config->setGroup("Version");
	config->writeEntry("version","1.0.0");
	config->sync();
}

}
