--TEST--
[Bug #5476] Possibly invalid VBook search criteria
--FILE--
<?php
// Pretend that we are turba
class Registry {
    function getApp()
    {
        return 'turba';
    }
    function get()
    {
        return 'turba';
    }
}
$registry = new Registry;


// Set a dummy server name
$_SERVER['SERVER_NAME'] = 'localhost';

// Indicate that we want the dummy IMAP driver
$GLOBALS['KOLAB_TESTING'] = array(
    "INBOX/Contacts" => array(
        "status" => array(
            "uidvalidity" => 1205144313,
            "uidnext" => 1
        ),
        "mails" => array(),
        "permissions" => array(
            "wrobel@dev.pardus.de" => "alriswcd"
        ),
        "annotations" => array(
            "/vendor/kolab/folder-type" => array(
                "value.shared" => "contact.default"
            ),
        ),
    ),
    "INBOX/test2" => array(
        "status" => array(
            "uidvalidity" => 1205144313,
            "uidnext" => 1
        ),
        "mails" => array(),
        "permissions" => array(
            "wrobel@dev.pardus.de" => "alriswcd"
        ),
        "annotations" => array(
            "/vendor/kolab/folder-type" => array(
                "value.shared" => "contact"
            ),
            "/vendor/horde/share-params" => array(
                "value.shared" => "YTozOntzOjQ6InR5cGUiO3M6NToidmJvb2siO3M6Njoic291cmNlIjtzOjIwOiJ3cm9iZWxAZGV2LnBhcmR1cy5kZSI7czo4OiJjcml0ZXJpYSI7YToxOntzOjk6ImZpcnN0bmFtZSI7czo1OiJ0ZXN0MiI7fX0="
            ),
        ),
    ),
);

// We need the basic PEAR library
require_once 'PEAR.php';
require_once 'Horde/Auth.php';
require_once 'Horde/Perms.php';
require_once 'Horde/Share.php';
require_once 'Horde/Kolab.php';
require_once 'Horde/Prefs.php';

$GLOBALS['prefs'] = &Prefs::factory('session', 'turba', '', '', null, false);

session_start();
$_SESSION['__auth']['userId'] = 'wrobel@dev.pardus.de';
$_SESSION['__auth']['authenticated'] = true;

// Find the base file path of Turba.
if (!defined('TURBA_BASE')) {
    define('TURBA_BASE', dirname(__FILE__) . '/../..');
}

// Turba base libraries.
require_once TURBA_BASE . '/lib/Turba.php';
require_once TURBA_BASE . '/lib/Driver.php';
require_once TURBA_BASE . '/lib/Object.php';

$cfgSources = array();

    $cfgSources['kolab'] = array(
        'title' => _("Contacts"),
        'type' => 'kolab',
        'params' => array(
            'charset' => 'utf-8',
        ),
        'map' => array(
            '__key' => 'uid',
            '__uid' => 'uid',
            /* Personal */
            'name' => array('fields' => array('firstname', 'middlenames', 'lastname'),
                            'format' => '%s %s %s',
                            'attribute' => 'full-name'),
            'firstname'         => 'given-name',
            'lastname'          => 'last-name',
            'middlenames'       => 'middle-names',
            'namePrefix'        => 'prefix',
            'nameSuffix'        => 'suffix',
            'initials'          => 'initials',
            'nickname'          => 'nick-name',
            'gender'            => 'gender',
            'birthday'          => 'birthday',
            'spouse'            => 'spouse-name',
            'anniversary'       => 'anniversary',
            'children'          => 'children',
            /* Location */
            'workStreet'        => 'addr-business-street',
            'workCity'          => 'addr-business-locality',
            'workProvince'      => 'addr-business-region',
            'workPostalCode'    => 'addr-business-postal-code',
            'workCountry'       => 'addr-business-country',
            'homeStreet'        => 'addr-home-street',
            'homeCity'          => 'addr-home-locality',
            'homeProvince'      => 'addr-home-region',
            'homePostalCode'    => 'addr-home-postal-code',
            'homeCountry'       => 'addr-home-country',
            /* Communications */
            'emails'            => 'emails',
            'homePhone'         => 'phone-home1',
            'workPhone'         => 'phone-business1',
            'cellPhone'         => 'phone-mobile',
            'fax'               => 'phone-businessfax',
            'instantMessenger'  => 'im-address',
            /* Organization */
            'title'             => 'job-title',
            'role'              => 'profession',
            'company'           => 'organization',
            'department'        => 'department',
            'office'            => 'office-location',
            'manager'           => 'manager-name',
            'assistant'         => 'assistant',
            /* Other */
            'category'          => 'categories',
            'notes'             => 'body',
            'website'           => 'web-page',
            'freebusyUrl'       => 'free-busy-url',
            'language'          => 'language',
            'latitude'          => 'latitude',
            'longitude'         => 'longitude',
        ),
        'tabs' => array(
            _("Personal") => array('name', 'firstname', 'lastname', 'middlenames',
                                   'namePrefix', 'nameSuffix', 'initials', 'nickname',
                                   'gender', 'birthday', 'spouse', 'anniversary',
                                   'children'),
            _("Location") => array('homeStreet', 'homeCity', 'homeProvince',
                                   'homePostalCode', 'homeCountry', 'workStreet',
                                   'workCity', 'workProvince', 'workPostalCode',
                                   'workCountry'),
            _("Communications") => array('emails', 'homePhone', 'workPhone',
                                         'cellPhone', 'fax', 'instantMessenger'),
            _("Organization") => array('title', 'role', 'company', 'department',
                                       'office', 'manager', 'assistant'),
            _("Other") => array('category', 'notes', 'website', 'freebusyUrl',
                                'language', 'latitude', 'longitude'),
        ),
        'search' => array(
            /* Personal */
            'firstname',
            'lastname',
            'middlenames',
            'namePrefix',
            'nameSuffix',
            'initials',
            'nickname',
            'gender',
            'birthday',
            'spouse',
            'anniversary',
            'children',
            /* Location */
            'workStreet',
            'workCity',
            'workProvince',
            'workPostalCode',
            'workCountry',
            'homeStreet',
            'homeCity',
            'homeProvince',
            'homePostalCode',
            'homeCountry',
            /* Communications */
            'emails',
            'homePhone',
            'workPhone',
            'cellPhone',
            'fax',
            'instantMessenger',
            /* Organization */
            'title',
            'role',
            'company',
            'department',
            'office',
            'manager',
            'assistant',
            /* Other */
            'category',
            'notes',
            'website',
            'language',
        ),
        'strict' => array(
            'uid',
        ),
        'export' => true,
        'browse' => true,
        'use_shares' => true,
        'shares_only' => true,
    );


$GLOBALS['conf']['kolab']['imap']['server'] = 'localhost';
$GLOBALS['conf']['kolab']['imap']['port'] = 0;

/* Pretend that we are kronolith */
$kolab = &new Kolab('turba');

/* Open our calendar */
$kolab->open('INBOX/Contacts', 1);

$object = array(
    'uid' => 1,
    'given-name' => 'test',
    'last-name' => 'test',
    'full-name' => 'test  test',
);

// Save the contact
$kolab->_storage->save($object);

$object = array(
    'uid' => 2,
    'given-name' => 'test2',
    'last-name' => 'test2',
    'full-name' => 'test2  test2',
);

// Save the contact
$kolab->_storage->save($object);

$GLOBALS['conf']['log']['enabled'] = false;
$GLOBALS['conf']['prefs']['driver'] = 'session';
$GLOBALS['conf']['share']['driver'] = 'kolab';
$GLOBALS['conf']['kolab']['enabled'] = true;
$GLOBALS['perms'] = &Perms::singleton();
$_SESSION['turba']['has_share'] =  true;
$GLOBALS['turba_shares'] = &Horde_Share::singleton($registry->getApp());

$GLOBALS['cfgSources'] = Turba::getConfigFromShares($cfgSources);

// Check that the driver can be created
$turba = Turba_Driver::singleton('wrobel@dev.pardus.de');

$result = $turba->search(array(), array('last-name'));

var_dump($result->count());

$turba = Turba_Driver::singleton('INBOX%2Ftest2');
$result = $turba->search(array(), array('last-name'));

var_dump($result->count());

--EXPECT--
int(2)
int(0)
