/*
 * sisctrl - SiS Display Control Panel
 * for the SiS XFree86/X.org driver
 *
 * Public interface routines for SISCTRL extension
 *
 * (C) 2003-2005 Thomas Winischhofer <thomas@winischhofer.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#define NEED_EVENTS
#define NEED_REPLIES
#include <X11/Xlibint.h>
#define SISCTRL_PRIVATE
#include "sisctrlstr.h"
#include <X11/extensions/Xext.h>
#include <X11/extensions/extutil.h>

/******************************
 *      The private stuff     *
 ******************************/

static XExtensionInfo _sisctrl_info_data;
static XExtensionInfo *sisctrl_info = &_sisctrl_info_data;
static char *sisctrl_extension_name = SISCTRL_PROTOCOL_NAME;

#define SiSCtrlCheckExtension(dpy, i, val) \
  XextCheckExtension(dpy, i, sisctrl_extension_name, val)

static int close_display(Display *dpy, XExtCodes *codes);

static /* const */ XExtensionHooks sisctrl_extension_hooks = {
    NULL,				/* create_gc */
    NULL,				/* copy_gc */
    NULL,				/* flush_gc */
    NULL,				/* free_gc */
    NULL,				/* create_font */
    NULL,				/* free_font */
    close_display,			/* close_display */
    NULL,				/* wire_to_event */
    NULL,				/* event_to_wire */
    NULL,				/* error */
    NULL,				/* error_string */
};

static XEXT_GENERATE_FIND_DISPLAY (find_display, sisctrl_info,
				   sisctrl_extension_name,
				   &sisctrl_extension_hooks,
				   0, NULL)

static XEXT_GENERATE_CLOSE_DISPLAY (close_display, sisctrl_info)


/******************************
 *     The public routines    *
 ******************************/

Bool
SiSCtrlQueryExtension(Display *dpy, int *event_basep, int *error_basep)
{
    XExtDisplayInfo *info = find_display(dpy);

    if(XextHasExtension(info)) {
	*event_basep = info->codes->first_event;
	*error_basep = info->codes->first_error;
	return True;
    } else {
	return False;
    }
}

Bool
SiSCtrlQueryVersion(Display *dpy, int *majorVersion, int *minorVersion)
{
    XExtDisplayInfo *info = find_display(dpy);
    xSiSCtrlQueryVersionReply rep;
    xSiSCtrlQueryVersionReq *req;

    SiSCtrlCheckExtension(dpy, info, False);
    LockDisplay(dpy);
    GetReq(SiSCtrlQueryVersion, req);
    req->reqType = info->codes->major_opcode;
    req->SiSCtrlReqType = X_SiSCtrlQueryVersion;
    if (!_XReply(dpy, (xReply *)&rep, 0, xFalse)) {
	UnlockDisplay(dpy);
	SyncHandle();
	return False;
    }
    *majorVersion = rep.majorVersion;
    *minorVersion = rep.minorVersion;
    UnlockDisplay(dpy);
    SyncHandle();

    return True;
}

int
SiSCtrlGetMaxScreens(void)
{
    return SISCTRL_MAX_SCREENS;
}

Bool
SiSCtrlCommand(Display *dpy, int screen, sisctrlcommand *siscmd)
{
    XExtDisplayInfo *info = find_display (dpy);
    xSiSCtrlCommandReply rep;
    xSiSCtrlCommandReq *req;
    int i;

    siscmd->sdc_result_header = SDC_RESULT_NOEXTENSION;
    SiSCtrlCheckExtension(dpy, info, False);

    LockDisplay(dpy);

    GetReq(SiSCtrlCommand, req);

    req->reqType = info->codes->major_opcode;
    req->SiSCtrlReqType = X_SiSCtrlCommand;
    req->screen = screen;
    req->sdc_id = siscmd->sdc_id;
    req->sdc_chksum = siscmd->sdc_chksum;
    req->sdc_command = siscmd->sdc_command;
    req->sdc_result_header = siscmd->sdc_result_header;
    for(i = 0; i < SDC_NUM_PARM_RESULT; i++) {
       req->sdc_parm[i] = siscmd->sdc_parm[i];
       req->sdc_result[i] = siscmd->sdc_result[i];
    }
    memcpy(&req->sdc_buffer[0], &siscmd->sdc_buffer[0], 32);

    if(!_XReply(dpy,
		(xReply *)&rep,
		(SIZEOF(xSiSCtrlCommandReply) - SIZEOF(xReply)) >> 2,
		xFalse)) {
	UnlockDisplay(dpy);
	SyncHandle();
	siscmd->sdc_result_header = SDC_RESULT_MESSAGEERROR;
	return False;
    }

    siscmd->sdc_id = rep.sdc_id;
    siscmd->sdc_chksum = rep.sdc_chksum;
    siscmd->sdc_command = rep.sdc_command;
    siscmd->sdc_result_header = rep.sdc_result_header;
    for(i = 0; i < SDC_NUM_PARM_RESULT; i++) {
       siscmd->sdc_parm[i] = rep.sdc_parm[i];
       siscmd->sdc_result[i] = rep.sdc_result[i];
    }
    memcpy(&siscmd->sdc_buffer[0], &rep.sdc_buffer[0], 32);

    UnlockDisplay(dpy);
    SyncHandle();

    /* Don't forget to flush! */

    return True;
}


