/*
 * SiSCtrl - SiS Display Control Panel
 * for the SiS X.org/XFree86 driver
 *
 * Private definitions for MAIN part
 *
 * (C) 2003-2005 Thomas Winischhofer <thomas@winischhofer.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _SISCTRL_DEF_H_
#define _SISCTRL_DEF_H_

#include "sisc.h"

#ifndef TRUE
#define TRUE 	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

/* Minimum vidmodextension version required */
#define VMMINMAJOR 2
#define VMMINMINOR 0

/* Minimum randr extension version required */
#define RRMINMAJOR 1
#define RRMINMINOR 1

/* Why aren't these defined in xf86vmode*.h ? */
#define V_INTERLACE     0x010
#define V_DBLSCAN       0x020

/* Lock file name */
#define LOCKFILENAME "/tmp/sisCtrl.lock"

/* VBFlags
 * This is taken from the current X driver and needs to be updated
 * if these defs change
 */
#define CRT2_DEFAULT            0x00000001
#define CRT2_LCD                0x00000002
#define CRT2_TV                 0x00000004
#define CRT2_VGA                0x00000008
#define TV_NTSC                 0x00000010
#define TV_PAL                  0x00000020
#define TV_HIVISION             0x00000040
#define TV_YPBPR                0x00000080
#define TV_AVIDEO               0x00000100
#define TV_SVIDEO               0x00000200
#define TV_SCART                0x00000400
#define VB_CONEXANT		0x00000800
#define TV_PALM                 0x00001000
#define TV_PALN                 0x00002000
#define TV_NTSCJ		0x00001000
#define VB_302ELV		0x00004000
#define TV_CHSCART              0x00008000
#define TV_CHYPBPR525I          0x00010000
#define CRT1_VGA		0x00000000
#define CRT1_LCDA		0x00020000
#define VGA2_CONNECTED          0x00040000
#define DISPTYPE_CRT1		0x00080000  	/* CRT1 connected and used */
#define VB_301                  0x00100000	/* Video bridge type (deprecated, now in vbflags2) */
#define VB_301B                 0x00200000
#define TV_YPBPR625I		0x00100000	/* !!! only if sd2flags & SiS_SD2_VBINVB2ONLY */
#define TV_YPBPR625P		0x00200000	/* !!! only if sd2flags & SiS_SD2_VBINVB2ONLY */
#define VB_302B                 0x00400000
#define VB_30xBDH		0x00800000      /* 30xB DH version (w/o LCD support) */
#define VB_LVDS                 0x01000000
#define VB_CHRONTEL             0x02000000
#define VB_301LV                0x04000000
#define VB_302LV                0x08000000
#define VB_301C			0x10000000
#define SINGLE_MODE             0x20000000   	/* CRT1 or CRT2; determined by DISPTYPE_CRTx */
#define MIRROR_MODE		0x40000000   	/* CRT1 + CRT2 identical (mirror mode) */
#define DUALVIEW_MODE		0x80000000   	/* CRT1 + CRT2 independent (dual head mode) */

/* Aliases: */
#define CRT2_ENABLE		(CRT2_LCD | CRT2_TV | CRT2_VGA)
#define TV_STANDARD             (TV_NTSC | TV_PAL | TV_PALM | TV_PALN | TV_NTSCJ)
#define TV_INTERFACE            (TV_AVIDEO|TV_SVIDEO|TV_SCART|TV_HIVISION|TV_YPBPR|TV_CHSCART|TV_CHYPBPR525I)

/* Only if TV_YPBPR is set: */
#define TV_YPBPR525I		TV_NTSC
#define TV_YPBPR525P		TV_PAL
#define TV_YPBPR750P		TV_PALM
#define TV_YPBPR1080I		TV_PALN
#define TV_YPBPRALL 		(TV_YPBPR525I | TV_YPBPR525P | TV_YPBPR750P | TV_YPBPR1080I)
/* Watch out: depending on sd2flags & SUPPORT625x, also TV_YPBPR625I | TV_YPBPR625P */

#define TV_YPBPR43LB		TV_CHSCART
#define TV_YPBPR43		TV_CHYPBPR525I
#define TV_YPBPR169 		(TV_CHSCART | TV_CHYPBPR525I)
#define TV_YPBPRAR              (TV_CHSCART | TV_CHYPBPR525I)

#define VB_SISBRIDGE            (VB_301|VB_301B|VB_301C|VB_302B|VB_301LV|VB_302LV|VB_302ELV)
#define VB_SISTVBRIDGE          (VB_301|VB_301B|VB_301C|VB_302B|VB_301LV|VB_302LV)
#define VB_VIDEOBRIDGE		(VB_SISBRIDGE | VB_LVDS | VB_CHRONTEL | VB_CONEXANT)

#define DISPTYPE_DISP2		CRT2_ENABLE
#define DISPTYPE_DISP1		DISPTYPE_CRT1
#define VB_DISPMODE_SINGLE	SINGLE_MODE  	/* alias */
#define VB_DISPMODE_MIRROR	MIRROR_MODE  	/* alias */
#define VB_DISPMODE_DUAL	DUALVIEW_MODE 	/* alias */
#define DISPLAY_MODE            (SINGLE_MODE | MIRROR_MODE | DUALVIEW_MODE)

#define BMASK (CRT2_ENABLE | TV_STANDARD | TV_INTERFACE | CRT1_LCDA)

/* VBFlags2 (static stuff only!) */
#define VB2_SISUMC		0x00000001
#define VB2_301			0x00000002	/* Video bridge type */
#define VB2_301B		0x00000004
#define VB2_301C		0x00000008
#define VB2_307T		0x00000010
#define VB2_302B		0x00000800
#define VB2_301LV		0x00001000
#define VB2_302LV		0x00002000
#define VB2_302ELV		0x00004000
#define VB2_307LV		0x00008000
#define VB2_30xBDH		0x08000000      /* 30xB DH version (w/o LCD support) */
#define VB2_CONEXANT		0x10000000
#define VB2_TRUMPION		0x20000000
#define VB2_LVDS		0x40000000
#define VB2_CHRONTEL		0x80000000
#define VB2_UNUSED		0x07ff07e0	/* This version of SiSCtrl doesn't know these */

#define VB2_SISBRIDGE		(VB2_301|VB2_301B|VB2_301C|VB2_307T|VB2_302B|VB2_301LV|VB2_302LV|VB2_302ELV|VB2_307LV)
#define VB2_VIDEOBRIDGE		(VB2_SISBRIDGE | VB2_LVDS | VB2_CHRONTEL | VB2_CONEXANT)

/* SiS Direct Flags */
#define SiS_SD_IS300SERIES  	0x00000001
#define SiS_SD_IS315SERIES  	0x00000002
#define SiS_SD_IS330SERIES  	0x00000004
#define SiS_SD_SUPPORTPALMN 	0x00000008   /* tv chip supports pal-m, pal-n */
#define SiS_SD_SUPPORT2OVL  	0x00000010   /* set = 2 overlays, 1 = support SWITCHCRT xv prop */
#define SiS_SD_SUPPORTTVPOS 	0x00000020   /* supports changing tv position */
#define SiS_SD_ISDUALHEAD   	0x00000040   /* Driver is in dual head mode */
#define SiS_SD_ISMERGEDFB   	0x00000080   /* Driver is in merged fb mode */
#define SiS_SD_ISDHSECONDHEAD   0x00000100   /* Dual head: This is CRT1 (=second head) */
#define SiS_SD_ISDHXINERAMA   	0x00000200   /* Dual head: We are running Xinerama */
#define SiS_SD_VBHASSCART     	0x00000400   /* videobridge has SCART instead of VGA2 */
#define SiS_SD_ISDEPTH8       	0x00000800   /* Depth is 8, no independent gamma correction */
#define SiS_SD_SUPPORTSOVER     0x00001000   /* Support for Chrontel Super Overscan */
#define SiS_SD_ENABLED        	0x00002000   /* sisctrl is enabled (by option) */
#define SiS_SD_PSEUDOXINERAMA 	0x00004000   /* pseudo xinerama is active */
#define SiS_SD_SUPPORTLCDA    	0x00008000   /* Support LCD Channel A ("LCD via CRT1") */
#define SiS_SD_SUPPORTNTSCJ     0x00010000   /* tv chip supports ntsc-j */
#define SiS_SD_ADDLSUPFLAG      0x00020000   /* 1 = the following flags are valid: */
#define SiS_SD_SUPPORTVGA2	0x00040000   /* CRT2=VGA supported */
#define SiS_SD_SUPPORTSCART     0x00080000   /* CRT2=SCART supported */
#define SiS_SD_SUPPORTOVERSCAN  0x00100000   /* Overscan flag supported */
#define SiS_SD_SUPPORTXVGAMMA1  0x00200000   /* Supports Gamma correction for Xv on CRT1 */
#define SiS_SD_SUPPORTTV  	0x00400000   /* CRT2=TV supported */
#define SiS_SD_SUPPORTYPBPR     0x00800000   /* CRT2=YPbPr (525i, 525p, 750p) is supported */
#define SiS_SD_SUPPORTHIVISION  0x01000000   /* HiVision (1080i) is supported */
#define SiS_SD_SUPPORTYPBPRAR   0x02000000   /* YPbPr aspect ratio is supported */
#define SiS_SD_SUPPORTSCALE     0x04000000   /* Scaling of LCD panel supported */
#define SiS_SD_SUPPORTCENTER    0x08000000   /* If scaling supported: Centering of screen supported (TMDS only) */
#define SiS_SD_SUPPORTREDETECT  0x10000000   /* Support re-detection of CRT2 devices */
#define SiS_SD_IS340SERIES      0x20000000
#define SiS_SD_SUPPORTSGRCRT2   0x40000000   /* Separate CRT2 gamma correction supported */
#define SiS_SD_CANSETGAMMA      0x80000000   /* Driver can set gamma ramp; otherwise: App needs to reset palette */
					     /* after disabling sep CRT2 gamma corr */

#define SiS_SD2_LCDTMDS	        0x00000001   /* Bridge supports TMDS (DVI-D) */
#define SiS_SD2_LCDLVDS	        0x00000002   /* Bridge supports LVDS */
#define SiS_SD2_SUPPORTLCD      0x00000004   /* Bridge supports LCD (LVDS or TMDS) */
#define SiS_SD2_SUPPORTTVSIZE   0x00000008   /* TV resizing supported (SiS bridges) */
#define SiS_SD2_SUPPORTTVTYPE   0x00000010   /* TV type selection supported (SiS bridges) */
#define SiS_SD2_SUPPORTGAMMA2   0x00000020   /* Gamma corr for CRT2 supported (SiS bridges) */
#define SiS_SD2_SISBRIDGE       0x00000040   /* SiS bridge */
#define SiS_SD2_SUPPTVSAT       0x00000080   /* TV saturation supported */
#define SiS_SD2_SUPPTVEDGE      0x00000100   /* TV edge enhancement supported */
#define SiS_SD2_CHRONTEL        0x00000200   /* Chrontel TV encoder present */
#define SiS_SD2_VIDEOBRIDGE     0x00000400   /* Any type of video bridge present */
#define SiS_SD2_THIRDPARTYLVDS  0x00000800   /* Third party LVDS (non-SiS) */
#define SiS_SD2_ADDLFLAGS       0x00001000   /* Following flags valid */
#define SiS_SD2_SUPPORT760OO    0x00002000   /* Support dynamic one/two overlay configuration changes         */
				 	     /*    (If set, we must re-read SD2 flags after mode change) */
#define SiS_SD2_SIS760ONEOVL    0x00004000   /* (760:) Only one overlay currently */
#define SiS_SD2_MERGEDUCLOCK    0x00008000   /* Provide VRefresh in mode->Clock field in MergedFB mode */
#define SiS_SD2_SUPPORTXVHUESAT 0x00010000   /* Xv: Support hue & saturation */
#define SiS_SD2_NEEDUSESSE	0x00020000   /* Need "UseSSE" option to use SSE (otherwise auto, X.org 6.9+) */
#define SiS_SD2_NODDCSUPPORT    0x00040000   /* No hardware DDC support (USB) */
#define SiS_SD2_SUPPORTXVDEINT  0x00080000   /* Xv deinterlacing supported (n/a, for future use) */
#define SiS_SD2_ISXGI	        0x00100000   /* Is XGI chip */
#define SiS_SD2_USEVBFLAGS2     0x00200000   /* Use VBFlags2 for bridge ID */
#define SiS_SD2_SUPPLTFLAG	0x00400000   /* Driver supports the following 3 flags */
#define SiS_SD2_ISLAPTOP	0x00800000   /* This machine is (very probably) a laptop */
#define SiS_SD2_MACHINETYPE2	0x01000000   /* Machine type 2 (for future use) */
#define SiS_SD2_MACHINETYPE3	0x02000000   /* Machine type 3 (for future use) */
#define SiS_SD2_SUPPORT625I     0x04000000   /* Support YPbPr 625i */
#define SiS_SD2_SUPPORT625P     0x08000000   /* Support YPbPr 625p */
#define SiS_SD2_VBINVB2ONLY     0x10000000   /* VB_* bits in vbflags no longer used for vbtype */
#define SiS_SD2_NEWGAMMABRICON  0x20000000   /* Support new gamma brightness/contrast */
#define SiS_SD2_HAVESD34	0x40000000   /* Support SD3 and SD4 flags */
#define SiS_SD2_NOOVERLAY       0x80000000   /* No video overlay */

#define SiS_SD3_OLDGAMMAINUSE   0x00000001   /* Old gamma brightness is currently in use */
#define SiS_SD3_MFBALLOWOFFCL   0x00000002   /* Supports off'ing CRTx in MFB if a clone mode is active */
#define SiS_SD3_SUPPORTVBF34    0x00000004   /* Supports VBFlags3 and VBFlags4 */
#define SiS_SD3_SUPPORTDUALDVI  0x00000008   /* Supports dual dvi-d (for future use) */
#define SiS_SD3_SUPPORTDUALTV   0x00000010   /* Supports dual tv (for future use) */
#define SiS_SD3_NEWOUTPUTSW     0x00000020   /* Supports NEWSETVBFLAGS (for future use) */
#define SiS_SD3_CRT1SATGAIN     0x00000040   /* Supports CRT1 saturation gain */
#define SiS_SD3_CRT2SATGAIN     0x00000080   /* Supports CRT2 saturation gain (apart from TV, see SiS_SD2_SUPPTVSAT) */
#define SiS_SD3_DYNMODELISTS    0x00000100   /* Driver handles modelists dynamically; re-read after output dev change */
#define SiS_SD3_IS350SERIES     0x00000200   /* 350 core (670, 770) */
#define SiS_SD3_REDETECTCRT1    0x00000400   /* Support redetection of CRT1 */
#define SiS_SD3_MFBDYNPOS       0x00000800   /* Support MergedFB dynamic mode-wise placements */
#define SiS_SD3_UNUSED		0xfffff000   /* This version of SiSCtrl doesn't understand these */

#define SiS_SD4_UNUSED		0xffffffff   /* This version of SiSCtrl doesn't understand these */

#define SIS_DIRECTKEY       	0x3145792

/* ChipFlags */
/* Use only lower 16 bit for chip id! */
#define SiSCF_Is651        0x0002
#define SiSCF_IsM650       0x0004
#define SiSCF_IsM652       0x0008
#define SiSCF_IsM653       0x0010
#define SiSCF_Is652        0x0020
#define SiSCF_IsM661       0x0100 /* M661FX */
#define SiSCF_IsM741       0x0200
#define SiSCF_IsM760       0x0400
#define SiSCF_IsM661M      0x0800 /* M661MX */
#define SiSCF_Is315USB     0x1000 /* USB2VGA dongle (SiS315PRO) */
#define SiSCF_Is315E       0x2000 /* 315E */
#define SiSCF_IsXGIV3	   SiSCF_Is651  /* Volari V3(XT)  (If neither XGI... set, is V8) */
#define SiSCF_IsXGIV5	   SiSCF_IsM650 /* Volari V5 */
#define SiSCF_IsXGIDUO	   SiSCF_IsM652 /* Volari Duo */

/* Check mode for CRT2 */
#define SiS_CF2_LCD          0x01
#define SiS_CF2_TV           0x02
#define SiS_CF2_VGA2         0x04
#define SiS_CF2_TVPAL        0x08
#define SiS_CF2_TVNTSC       0x10  /* + NTSC-J */
#define SiS_CF2_TVPALM       0x20
#define SiS_CF2_TVPALN       0x40
#define SiS_CF2_CRT1LCDA     0x80
#define SiS_CF2_TYPEMASK     (SiS_CF2_LCD | SiS_CF2_TV | SiS_CF2_VGA2 | SiS_CF2_CRT1LCDA)
#define SiS_CF2_TVSPECIAL    (SiS_CF2_LCD | SiS_CF2_TV)
#define SiS_CF2_TVSPECMASK   (SiS_CF2_TVPAL | SiS_CF2_TVNTSC | SiS_CF2_TVPALM | SiS_CF2_TVPALN)
#define SiS_CF2_TVHIVISION   SiS_CF2_TVPAL
#define SiS_CF2_TVYPBPR525I  SiS_CF2_TVNTSC
#define SiS_CF2_TVYPBPR525P  (SiS_CF2_TVPAL | SiS_CF2_TVNTSC)
#define SiS_CF2_TVYPBPR625I  SiS_CF2_TVPALN
#define SiS_CF2_TVYPBPR625P  (SiS_CF2_TVPALN | SiS_CF2_TVPAL)
#define SiS_CF2_TVYPBPR750P  SiS_CF2_TVPALM
#define SiS_CF2_TVYPBPR1080I (SiS_CF2_TVPALM | SiS_CF2_TVPAL)

typedef enum _SIS_CHIP_TYPE {
    SIS_VGALegacy = 0,
    SIS_530,
    SIS_OLD,
    SIS_300,
    SIS_630,
    SIS_730,
    SIS_540,
    SIS_315H,   /* SiS 310 */
    SIS_315,
    SIS_315PRO, /* SiS 325 */
    SIS_550,
    SIS_650,
    SIS_740,
    SIS_330,
    SIS_661,
    SIS_741,
    SIS_660 = 35,
    SIS_760,
    SIS_340 = 55,
    SIS_341,
    SIS_342,
    SIS_761,
    SIS_762,
    SIS_670 = 62,
    SIS_770,
    XGI_20  = 75,
    XGI_40,
    MAX_SIS_CHIP
} SIS_CHIP_TYPE;

/* Our global data */

typedef struct  {

	Display *dpy;
	int myscreen;

	int lockfile;
	char filenamebuffer[64];

	/* SISCTRL extension */
	Bool sdinterface;
	sisctrlcommand sdstruct;
	int sdmaxscreens, sdmaxcommand, sdversion, sderror;
	int scextversion_major, scextversion_minor;
	unsigned int cmd_get_br, cmd_set_br, cmd_get_newbr, cmd_set_newbr;
	Bool xlogquiet;

	/* VIDMODE extension */
	XF86VidModeModeInfo **vmmodelines;
	int vmmodecount;
	XF86VidModeGamma currentgamma, newgamma;

	/* Xv extension */
	unsigned int xv_req_base, xv_event_base, xv_error_base;

	unsigned short modecheckfield[SISCTRL_MAXMODES];
	int moderate[SISCTRL_MAXMODES];

	/* RANDR extension */
	Bool haverandr;
	Bool dorandr;
#ifdef HAVE_RANDR
	Window	root;
	XRRScreenSize *rrsizes;
	XRRScreenConfiguration *sconf;
	int	rrnsize, rrsize, rrrate, rrnrate, rrrot;
	short	*rrrates;
	SizeID	rrcurrent_size, rrsize_backup, rrsize_backup2, rrsize_backup3;
	short   rrcurrent_rate, rrrate_backup, rrrate_backup2, rrrate_backup3;
	Rotation rrcurrent_rotation, rrrotation_backup, rrrotation_backup2, rrrotation_backup3;
	Rotation supprotations;
	Bool    rrcheck_backup, xerror;
	char    leaveunchangedtext[128];
	char    currentrottext[32];
#endif

	/* XINERAMA extension */
	Bool	xinerama;
	int	xinescrcnt, xi_event_base;
	Bool	havexineramaevent;
#ifdef HAVE_XINERAMA
	XineramaScreenInfo *xineinfo;
#endif

	/* XV extension */
	Bool	havexv;
	char *attr_name;
	int xv_port_nr;
	Atom atom_bri, atom_hue, atom_sat, atom_con;
	Atom atom_qvf, atom_usd, atom_qvv, atom_qdd, atom_tvx, atom_tvy, atom_svf;
	Atom atom_taf, atom_tsa, atom_tee, atom_tco, atom_tte, atom_ccc, atom_gsf;
	Atom atom_tcf, atom_tlf, atom_cmd, atom_cmdr,atom_ct1, atom_ghi;
	Atom atom_swc, atom_sga, atom_gdv, atom_ovr;
	Atom atom_gbi, atom_txs, atom_tys, atom_coc, atom_cof, atom_cfi, atom_yfi;
	Atom atom_gss, atom_brr, atom_brg, atom_brb;
	Atom atom_vgr, atom_vgg, atom_vgb, atom_col, atom_pmd, atom_rdt;
	Atom atom_g2r, atom_g2g, atom_g2b, atom_b2r, atom_b2g, atom_b2b;
	Atom atom_gsf2,atom_dgl, atom_gfx;
#ifdef USEXV
	Bool noxvdemo;
#endif
	Bool noxvglobal;  /* Have attrs for "Xinerama global" con,bri,hue,sat Xv adjustments */
	Bool xvisglobal;  /* Adjust globally if TRUE, otherwise this HEAD only */

	Bool havenewhwinfo;
	unsigned long busType, pciBus, pciDev, pciFunc, NewROM, chipFlags, chipType, chipRev;
	unsigned long driverYear, driverMonth, driverDay, driverRev, videoRam, UMAsize, LFBsize;
	char biosversion[32];

	Bool busisusb;

	unsigned long currentvbflags, detecteddevices, newvbflags, backupvbflags, busid;
	unsigned long sdflags, sd2flags, vbflags2, gammaflags, backupgammaflags, hwinfo, driverversion;
	unsigned long backupvbflags2, backupvbflags3, sd3flags, sd4flags;
	int CRT1isoff, CRT1isoffbackup, CRT1isoffbackup2, currentmodeindex, backupmodeindex;
	Bool didcrt1redetection;
	int choverscanstatus, backupoverscan, backupoverscan2, lcdscaler, backuplcdscaler;
	int backuplcdscaler2, backuplcdscaler3, backupoverscan3, CRT1isoffbackup3;
	int backupmodeindex2, backupmodeindex3;
	double backup_gred, backup_ggreen, backup_gblue;
	double gamma_max[3], gamma_max_b[3];
	double backup_g2r, backup_g2g, backup_g2b;
	double gamma2r, gamma2g, gamma2b, newgamma2r, newgamma2g, newgamma2b;
	double gamma_bri2[3], gamma_bri2_b[3];
	double newgamma_bri[3], newgamma_bri2[3], newgamma_con[3], newgamma_con2[3];
	double newgamma_bri_b[3], newgamma_bri2_b[3], newgamma_con_b[3], newgamma_con2_b[3];
	float framp;
	float xvgammared, xvgammagreen, xvgammablue;
	unsigned long colorkey;
	int backup_dgl, backup_gfx;
	Bool havedglgfx;
	Bool usenewgamma;
	Bool sepgammahidden;

	Bool havesdflags2;
	Bool HaveGss;
	Bool HaveBri;
	Bool HaveRedetect;
	Bool HaveSepGC2, GammaFor2;

	int vbflagsvers;

	Bool guimode;
	int givencrt2index, giventvstdindex, giventvosindex, giventvstindex, giventvasindex;
	int givenlcdscale;

	Bool havemonname1, havemonname2, havedevname1, havedevname2;
	char monname1[32], monname2[32], devname1[32], devname2[32];

	int iconify, doconfirm;
#ifdef USE_STRAY
	int dontusesystemtray;
#endif

} sc_globals;

#endif

