.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.ta .3i .6i .9i 1.2i 1.5i 1.8i
.TH PIEWM 1 "Release 5" "X Version 11"
.SH NAME
piewm - Tom's Virtual Tab Window Manager with Pie Menus
.SH SYNTAX
.PP
\fBpiewm \fP[-display \fIdpy\fP] [-s] [-k] [-f \fIinitfile\fP] [-v]
.PP
.SH DESCRIPTION
.PP
\fIPiewm\fP is a window manager for the X Window System based
\fItvtwm\fP, which is based on the X11R4 version of \fItwm\fP, 
with code segments from the X11R5 \fItwm\fP as well.  
It includes pie menus, and a ``Virtual Desktop''
feature that effectively makes the root window of the screen 
larger than the physical limits of the display.  To change 
as little as possible in this manual, from here on the window
manager is referred to as \fItwm\fP.
.PP
\fITwm\fP is a window manager for the X Window System.  It provides 
titlebars, shaped windows, pie and linear menus, 
several forms of icon management, user-defined macro functions, 
click-to-type and pointer-driven keyboard focus, and user-specified 
key and pointer button bindings.
.PP
This program is usually started by the user's session manager or
startup script.  When used from \fIxdm(1)\fP or \fIxinit(1)\fP without
a session manager, \fItwm\fP is frequently executed in the foreground
as the last client.  When run this way, exiting \fItwm\fP causes the 
session to be terminated (i.e. logged out).
.PP
By default, application windows are surrounded by a ``frame'' with a 
titlebar at the top and a special border around the window.  The titlebar 
contains the window's name, a rectangle that is lit when the window is
receiving keyboard input, and function boxes known as ``titlebuttons'' at
the left and right edges of the titlebar.
.PP
Pressing pointer Button1 (usually the left-most
button unless it has been changed with \fIxmodmap\fP) on a 
titlebutton will invoke the function associated with the button.
In the default interface, windows are iconified by clicking (pressing
and then immediately releasing) the left titlebutton (which looks
like a small dot).  Conversely, windows are deiconified by clicking in the
associated icon or entry in the icon manager
(see description of the variable
\fBShowIconManager\fP and of the function \fBf.showiconmgr\fP).
.PP
Windows are resized by pressing the right titlebutton (which resembles
group of nested squares), dragging the pointer over edge that is to be
moved, and releasing the pointer when the outline of the window is the desired
size.  Similarly, windows are moved by pressing in the title or highlight
region, dragging a window outline to the new location, and then releasing
when the outline is in the desired position.  Just
clicking in the title or highlight region raises the window without moving it.
.PP
When new windows are created, \fItwm\fP will honor any size and location
information requested by the user (usually through \fI-geometry\fP
command line argument or resources for the individual applications).  
Otherwise, an outline of the window's default size, its titlebar, and lines 
dividing the 
window into a 3x3 grid that track the pointer are displayed.
Clicking pointer Button1
will position the window at the current position and give it the default
size.  Pressing pointer Button2 (usually the middle pointer button) 
and dragging the outline
will give the window its current position but allow the sides to be resized as
described above.  Clicking pointer Button3 (usually the right pointer button)
will give the window its current position but attempt to make it long enough
to touch the bottom the screen.
.SH OPTIONS
\fITwm\fP accepts the following command line options:
.PP
.TP 8
.B \-display \fIdpy\fP
This option specifies the X server to use.
.TP 8
.B \-s
This option indicates that only the default screen (as specified by 
\fB\-display\fP or by the \fBDISPLAY\fP environment variable) should be
managed.  By default, \fItwm\fP will attempt to manage
all screens on the display.
.TP 8
.B \-k
This option makes \fItwm\fP leave a file in /tmp containing the
predefines that are generated and fed to m4 before your \fI.twmrc\fP file.
\fITwm\fP passes this file, followed immediately by your \fI.twmrc\fP
file (which may not be called \fI.twmrc\fP.  See \fB-f\fP option.), to
\fIm4(1)\fP for preprocessing.  If you give \fItwm\fP the \fB-k\fP option,
it will leave a copy of the temporary file as \fI/tmp/twmrc$$\fP (where
\fI$$\fP is variable).  This is often useful for knowing what you can
use when adding \fIm4\fP commands and conditions to your \fI.twmrc\fP
file.
.TP 8
.B \-f \fIfilename\fP
This option specifies the name of the startup file to use.  By default,
\fItwm\fP will look in the user's home directory for files 
named \fI.twmrc.num\fP (where \fInum\fP is a screen number) or \fI.twmrc\fP.
.TP 8
.B \-v
This option indicates that \fItwm\fP should print error messages whenever
an unexpected X Error event is received.  This can be useful when debugging
applications but can be distracting in regular use.
.SH CUSTOMIZATION
.PP
Much of \fItwm\fP's appearance and behavior can be controlled by providing
a startup file in one of the following locations (searched in order for
each screen being managed when \fItwm\fP begins):
.TP 8
.B "$HOME/.piewmrc.\fIscreennumber\fP"
The \fIscreennumber\fP is a small positive number (e.g. 0, 1, etc.)
representing the screen number (e.g. the last number in the DISPLAY environment
variable \fIhost:displaynum.screennum\fP) that would be used to contact that 
screen of the display.  This is intended for displays with multiple screens of 
differing visual types.
.TP 8
.B "$HOME/.piewmrc"
This is the usual name for an individual user's startup file.
.TP 8
.B "$HOME/.tvtwmrc.\fIscreennumber\fP"
Same as \fB.piewmrc.\fIscreennumber\fR.
.TP 8
.B "$HOME/.tvtwmrc"
Same as \fB.piewmrc\fP.
.TP 8
.B "$HOME/.twmrc.\fIscreennumber\fP"
Same as \fB.piewmrc.\fIscreennumber\fR.
.TP 8
.B "$HOME/.twmrc"
Same as \fB.piewmrc\fP.
.TP 8
.B "/usr/lib/X11/twm/system.twmrc"
If neither of the preceding files are found, \fItwm\fP will look in this
file for a 
default configuration.  This is often tailored by the site administrator to
provide convenient menus or familiar bindings for novice users.
.PP
If no startup files are found, \fItwm\fP will use the built-in defaults
described above.  The only resource used by \fItwm\fP is 
\fIbitmapFilePath\fP for a colon-separated list of directories to search
when looking for bitmap files (for more information, see the \fIAthena
Widgets\fP manual and \fIxrdb(1)\fP).
.PP
\fITwm\fP startup files are logically broken up into three types of 
specifications:  \fIVariables\fP, \fIBindings\fP, \fIMenus\fP.  The 
\fIVariables\fP section must come first and is used to describe the
fonts, colors, cursors, border widths, icon and window placement, highlighting,
autoraising, layout of titles, warping, use of the icon manager.
The \fIBindings\fP section usually comes second and is used to specify
the functions that should be
to be invoked when keyboard and pointer buttons are pressed in
windows, icons, titles, and frames.  The \fIMenus\fP section gives any 
user-defined menus (containing functions to be invoked or
commands to be executed).
.PP
Variable names and keywords are case-insensitive.  Strings must be surrounded
by double quote characters (e.g. "blue") and are case-sensitive.
A pound sign (#) outside
of a string causes the remainder of the line in which the character appears to
be treated as a comment.
.SH M4 PREPROCESSING
.PP
A new feature in this release of \fIpiewm\fP is that it will use \fIm4(1)\fP
to pre-process it's setup files.  When \fItwm\fP starts up, it will open
a file for input as described above.  But, it will process that file through
\fIm4\fP before parsing it.  So, you can use \fIm4\fP macro's to perform
operations at runtime.  This makes it very easy to work when you use
many different display's, with different characteristics.  For example,
If you want to set the lower right section of the screen to be your
\fBIconRegion\fP, (see below for details on the \fBIconRegion\fP variable)
you can use m4 directives and pre-defined symbols to calculate the region
you want.  For example:
.EX 0
define(IRegion, translit(eval(WIDTH/3)*eval(HEIGHT/2)+eval(WIDTH-WIDTH/3)-0, *, x))
IconRegion  "IRegion" SOUTH EAST 75 25
.EE
will define the lower half, and right-hand third of the screen.  The above
makes use of symbols that are predefined in m4 by \fItwm\fP.  The symbols
WIDTH and HEIGHT are calculated by \fItwm\fP and written into a temporary
file for \fIm4\fP to use.  The following symbols are predefined by
\fIpiewm\fP:
.TP 24
.B "SERVERHOST"
This variable is set to the name of the machine that is running the X
server.
.TP 24
.B "CLIENTHOST"
The machine that is running the clients.  (ie, \fItwm\fP)
.TP 24
.B "HOSTNAME"
The canonical hostname running the clients.  (ie. a fully-qualified
version of \fBCLIENTHOST\fP)
.TP 24
.B "USER"
The name of the user running the program.  Gotten from the environment.
.TP 24
.B "HOME"
The user's home directory.  Gotten from the environment.
.TP 24
.B "VERSION"
The X major protocol version.  As seen by ProtocolVersion(3).
.TP 24
.B "REVISION"
The X minor protocol revision.  As seen by ProtocolRevision(3).
.TP 24
.B "VENDOR"
The vendor of your X server.  For example: \fBMIT X Consortium\fP.
.TP 24
.B "RELEASE"
The release number of your X server.  For MIT X11R5, this is \fB5\fP.
.TP 24
.B "WIDTH"
The width of your display in pixels.
.TP 24
.B "HEIGHT"
The height of your display in pixels.
.TP 24
.B "X_RESOLUTION"
The X resolution of your display in pixels per meter.
.TP 24
.B "Y_RESOLUTION"
The Y resolution of your display in pixels per meter.
.TP 24
.B "PLANES"
The number of bit planes your display supports in the default root window.
.TP 24
.B "BITS_PER_RGB"
The number of significant bits in an RGB color.  (log base 2 of the number
of distinct colors that can be created.  This is often different from the
number of colors that can be displayed at once.)
.TP 24
.B "TWM_TYPE"
Tells which \fItwm\fP offshoot is running.  It will always be set to
the string "piewm" in this program.  This is useful for protecting
parts of your \fI.twmrc\fP file that \fItwm\fP proper won't understand
(like \fBVirtualDesktop\fP) so that it is still usable with other
\fItwm\fP programs.
.TP 24
.B "CLASS"
Your visual class.  Will return one of \fBStaticGray\fP, \fBGrayScale\fP,
\fBStaticColor\fP, \fBPseudoColor\fP, \fBTrueColor\fP, \fBDirectColor\fP,
or, if it cannot determine what you have, \fBNonStandard\fP.
.TP 24
.B "COLOR"
This will be either 'Yes' or 'No'.  This is just a wrapper around the above
definition.  Returns 'Yes' on \fB*Color\fP, and 'No' on \fBStaticGray\fP
and \fBGrayScale\fP.
.TP 24
.B "NG_*"
There will be a large (about 16) number of predefines that look like
\fBNG_EE\fP or \fBNG_AE\fP.  These are for access control.  When they
are set to something intelligent, you can protect certain machines or
groups of machines in login menus by which group of people should be
able to access them.  If you place an ifelse(NG_STAFF, yes, `') in your
\fI.twmrc\fP file, and place the login menu, or the like, in between the
quotes, then it will only be seen by members of the staff.  This is useful
when you have a whole system that \fBinclude()\fPs a system-wide login
file.  This makes it easy to centrally administer things such as login
menus, and have all users notice changes without having to make them
individually.  At the moment, there is little or no
functionality in these.  If you are a member of the group "staff", you have
them all set to 'Yes', else, you have only \fBNG_STD\fP defined to 'Yes'.
I plan to make these symbols meaningful in the near future.
.PP
You may well find that if you research the \fIm4(1)\fP manual well,
and understand the power of \fIm4\fP, this will be a \fBvery\fP
useful and powerful tool.
.SH VIRTUAL DESKTOP
The Virtual Desktop feature of \fItvtwm\fP was modeled after the same feature
in swm (Solbourne Window Manager).  The Virtual Desktop effectively
makes the ``root'' window of the display larger than the physical 
screen size.  The Virtual Desktop is panned in one of two ways, either
by executing one of the \fBf.scroll\fP commands or by using the panner.
.PP
The panner is a special window that shows a miniature view of windows
on the desktop.  The small windows in the panner will have the same
colors as the titlebars and icons of their associated client windows.
The panner is very simply to operate.  Mouse button one pressed inside
the panner moves the view on the desktop to an integral number of
desktops from the top-left.  Mouse button three pressed inside the
panner allows you to move the outline indicating your current view on
the desktop.  Releasing the button will reposition the desktop to the
point at which the outline is displayed.  Mouse button two pressed in
one of the small ``virtual'' windows allows you to move the small
window to another portion of the desktop.  If during the move
operation, you would like to place the window in your current view of
the desktop, simply moving the pointer out of the panner will result
in the window outline changing from the small outline to a large
outline showing the dimensions of the client window.  The converse is
true of any move operation started outside of the panner: if the
pointer is moved into the panner window, the outline will change to a
small outline allowing you to place the window anywhere on the
desktop.  Another feature of the panner is that if you resize it, the
Virtual Desktop will resize a corresponding amount.  During the
resize, the dimensions shown reflect the Virtual Desktop size.
.PP
There are two hints that client windows may use when asking the
window manager to position top level windows:  User Specified
Position (USPosition) and Program Specified Position (PPosition).
\fItvtwm\fP handles each of these two hints in a different manner.
If USPosition hints are set, the window will be placed at the
pixel location requested.  If PPosition hints are set, the window
will be placed at the requested location plus the offsets 
of the current Virtual Desktop position.  For example, if the
desktop is positioned at +100+300 and a window is mapped at
+100+100 with PPosition hints set, the window would be placed
at +200+400 on the Virtual Desktop.
.PP
Along with the Virtual Desktop comes a concept called ``sticky''
windows.  Sticky windows can be thought of as stuck to the glass
of the display.  Sticky windows do not scroll out of view when the desktop
is scrolled.
.SH PIE MENUS
This version of \fItwm\fP supports pie menus.  
The labels of a pie menu are arranged in a circle around the cursor, 
and the menu selection is based on the direction you move between 
clicking the button.  
Pie menus are fast and easy to use because each of the items 
corresponds to a large wedge shaped area adjacent to the cursor.  
.PP
You define pie menus the same way as regular linear menus,
using the word \fBpiemenu\fP instead of \fBmenu\fP.  
They have an extra optional argument: an ``@'' sign 
followed by a number, specifying the direction of the first menu item, 
defaulting to 0 (to the right, increasing counter-clockwise).  
You can make pie menus with graphical labels, by specifying a label
beginning with an underscore followed by a bitmap or pixmap file name.
.PP
To pop up a pie menu (in a binding or as a submenu), use the \fBf.piemenu\fP 
function instead of the \fBf.menu\fP function.  
Pie menus can be submenus of linear menus, and linear menus can be submenus
of pie menus, too.  
.PP
Pie menus are usually drawn in a rectangular window.  To have them
drawn "in midair" using shapes, specify the "\fBNoMenuShadows\fP"
keyword in your .piewmrc.
.SH VARIABLES
.PP
Many of the aspects of \fItwm\fP's user interface are controlled by variables
that may be set in the user's startup file.  Some of the options are
enabled or disabled simply by the presence of a particular keyword.  Other
options require keywords, numbers, strings, or lists of all of these.
.PP
Lists are surrounded by braces and are usually separated by
whitespace or a newline.  For example:
.EX 0
\fBAutoRaise\fP { "emacs" "XTerm" "Xmh" }
.EE
or
.EX 0
\fBAutoRaise\fP
{
	"emacs"
	"XTerm"
	"Xmh"
}
.EE
When a variable containing a list of strings representing windows is searched 
(e.g. to determine whether or not to enable autoraise as shown above), a string
is considered to match a window if it is a case-sensitive prefix for
the window's name name (given by the WM_NAME window property), resource name 
or class name (both given by the WM_CLASS window property).  The preceding
example would enable autoraise on windows named ``emacs'' as well as any
\fIxterm\fP (since they are of class ``XTerm'') or xmh windows 
(which are of class ``Xmh'').
.PP
String arguments that are interpreted as filenames (see the \fBPixmaps\fP,
\fBCursors\fP, and \fBIconDirectory\fP below) will 
prepend the user's directory
(specified by the \fBHOME\fP environment variable) if the first character is a
tilde (~).  If, instead, the first character is a colon (:), the name is
assumed to refer to one of the internal bitmaps that are used to
create the default titlebars symbols:  \fB:xlogo\fP 
or \fB:iconify\fP (both refer to the
X used for the iconify button), \fB:resize\fP (the nested squares used by the
resize button), and \fB:question\fP (the question mark used for non-existent
bitmap files).
.PP
The following variables may be specified at the top of a \fItwm\fP startup
file.  Lists of Window name prefix strings are indicated by \fIwin-list\fP.
Optional arguments are shown in square brackets:
.IP "\fBAutoRaise\fP { \fIwin-list\fP }" 8
This variable specifies a list of windows that should automatically be
raised whenever the pointer enters the window.  This action can be
interactively
enabled or disabled on individual windows using the function \fBf.autoraise\fP.
.IP "\fBAutoRelativeResize\fP" 8
This variable indicates that dragging out a window size (either when
initially sizing the window with pointer Button2 or when resizing it) 
should not wait until the pointer has crossed the window edges.
Instead, moving
the pointer automatically causes the nearest edge or edges to move by the
same amount.  This allows allows the resizing windows that extend off 
the edge of the screen.
If the pointer is
in the center of the window, or if the resize is begun by pressing a 
titlebutton, \fItwm\fP will still wait for the pointer to cross a window
edge (to prevent accidents).  This option is
particularly useful for people who like the press-drag-release method of
sweeping out window sizes.
.IP "\fBBorderColor\fP \fIstring\fP [{ \fIwincolorlist\fP }]" 8
This variable specifies the default color of the border to be placed around 
all 
non-iconified windows, and may only be given within a \fBColor\fP or 
\fBMonochrome\fP list.  The optional \fIwincolorlist\fP specifies a list
of window and color name pairs for specifying particular border colors for
different types of windows.  For example:
.EX 0
\fBBorderColor\fP "gray50"
{
	"XTerm"	"red"
	"xmh"	"green"
}
.EE
The default is "black".
.IP "\fBBorderTileBackground\fP \fIstring\fP [{ \fIwincolorlist\fP }]" 8
This variable specifies the default background color in the gray pattern 
used in unhighlighted borders (only if \fBNoHighlight\fP hasn't been set),
and may only be given within a \fBColor\fP or \fBMonochrome\fP list.  The
optional \fIwincolorlist\fP allows per-window colors to be specified.
The default  is "black".
.IP "\fBBorderTileForeground\fP \fIstring\fP [{ \fIwincolorlist\fP }]" 8
This variable specifies the default foreground color in the gray pattern
used in unhighlighted borders (only
if \fBNoHighlight\fP hasn't been set), and may only be given within a 
\fBColor\fP or \fBMonochrome\fP list.  The optional \fIwincolorlist\fP allows
per-window colors to be specified.  The default is "white".
.IP "\fBBorderWidth\fP \fIpixels\fP" 8
This variable specifies the width in pixels of the border surrounding
all client window frames if \fBClientBorderWidth\fP has not been specified.
This value is also used to set the border size of windows created by \fItwm\fP
(such as the icon manager).  The default is 2.
.IP "\fBButtonIndent\fP \fIpixels\fP" 8
This variable specifies the amount by which titlebuttons should be 
indented on all sides.  Positive values cause the buttons to be smaller than
the window text and highlight area so that they stand out.  Setting this
and the \fBTitleButtonBorderWidth\fP variables to 0 makes titlebuttons be as
tall and wide as possible.  The default is 1.
.IP "\fBClientBorderWidth\fP" 8
This variable indicates that border width of a window's frame should be set to
the initial border width of the window, rather than to the value of
\fBBorderWidth\fP.
.IP "\fBColor\fP { \fIcolors-list\fP }" 8
This variable specifies a list of color assignments to be made if the default
display is capable of displaying more than simple black and white.  The
\fIcolors-list\fP is made up of the following color variables and their values:
\fBDefaultBackground\fP,
\fBDefaultForeground\fP,
\fBMenuBackground\fP,
\fBMenuForeground\fP,
\fBMenuTitleBackground\fP,
\fBMenuTitleForeground\fP, and
\fBMenuShadowColor\fP.
\fBVirtualDesktopBackground\fP.
\fBVirtualDesktopForeground\fP.
\fBPannerBackground\fP.
\fBPannerForeground\fP.
The following
color variables may also be given a list of window and color name pairs to
allow per-window colors to be specified (see \fBBorderColor\fP for details):
\fBBorderColor\fP,
\fBIconManagerHighlight\fP,
\fBBorderTitleBackground\fP,
\fBBorderTitleForeground\fP,
\fBTitleBackground\fP,
\fBTitleForeground\fP,
\fBIconBackground\fP,
\fBIconForeground\fP,
\fBIconBorderColor\fP,
\fBIconManagerBackground\fP, and
\fBIconManagerForeground\fP.
\fBVirtualBackground\fP, and
\fBVirtualForeground\fP.
For example:
.EX 0
\fBColor\fP
{
	MenuBackground		"gray50"
	MenuForeground		"blue"
	BorderColor			"red" { "XTerm" "yellow" }
	TitleForeground		"yellow"
	TitleBackground		"blue"
}
.EE
All of these color variables may also be specified for the \fBMonochrome\fP 
variable, allowing the same initialization file to be used on both color and
monochrome displays.
.IP "\fBConstrainedMoveTime\fP \fImilliseconds\fP" 8
This variable specifies the length of time between button clicks needed to
begin
a constrained move operation.  Double clicking within this amount
of time when invoking \fBf.move\fP will cause the window only be moved 
in a horizontal or vertical direction.  Setting this value to 0 will disable
constrained moves.  The default is 400 milliseconds.
.IP "\fBCursors\fP { \fIcursor-list\fP }" 8
This variable specifies the glyphs that \fItwm\fP should use for various
pointer cursors.  Each cursor
may be defined either from the \fBcursor\fP font or from two bitmap files.
Shapes from the \fBcursor\fP font may be specified directly as:
.EX 0
	\fIcursorname\fP	"\fIstring\fP"
.EE
where \fIcursorname\fP is one of the cursor names listed below, and
\fIstring\fP is the name of a glyph as found in the file
/usr/include/X11/cursorfont.h (without the ``XC_'' prefix).
If the cursor is to be defined
from bitmap files, the following syntax is used instead:
.EX 0
	\fIcursorname\fP	"\fIimage\fP"	"\fImask\fP"
.EE
The \fIimage\fP and \fImask\fP strings specify the names of files containing
the glyph image and mask in \fIbitmap(1)\fP form.
The bitmap files are located in the same manner as icon bitmap files.
The following example shows the default cursor definitions:
.EX 0
\fBCursors\fP
{
	Frame		"top_left_arrow"
	Title		"top_left_arrow"
	Icon		"top_left_arrow"
	IconMgr	"top_left_arrow"
	Move		"fleur"
	Resize		"fleur"
	Menu		"sb_left_arrow"
	Button		"hand2"
	Wait		"watch"
	Select		"dot"
	Destroy	"pirate"
}
.EE
.IP "\fBDecorateTransients\fP" 8
This variable indicates that transient windows (those containing a 
WM_TRANSIENT_FOR property) should have titlebars.  By default, transients 
are not reparented.
.IP "\fBDefaultBackground\fP \fIstring\fP" 8
This variable specifies the background color to be used for sizing and
information windows.  The default is "white".
.IP "\fBDefaultForeground\fP \fIstring\fP" 8
This variable specifies the foreground color to be used for sizing and
information windows.  The default is "black".
.IP "\fBDontIconifyByUnmapping\fP { \fIwin-list\fP }" 8
This variable specifies a list of windows that should not be iconified by
simply unmapping the window (as would be the case if \fBIconifyByUnmapping\fP
had been set).  This is frequently used to force some windows to be treated
as icons while other windows are handled by the icon manager.
.IP "\fBDontMoveOff\fP" 8
This variable indicates that windows should not be allowed to be moved off the
screen.  It can be overridden by the \fBf.forcemove\fP function.
.IP "\fBDontSqueezeTitle\fP [{ \fIwin-list\fP }] " 8
This variable indicates that titlebars should not be squeezed to their 
minimum size as described under \fBSqueezeTitle\fP below.
If the optional window list is supplied, only those windows will be
prevented from being squeezed.
.IP "\fBForceIcons\fP" 8
This variable indicates that icon pixmaps specified in the \fBIcons\fP
variable should override any client-supplied pixmaps.
.IP "\fBFramePadding\fP \fIpixels\fP" 8
This variable specifies the distance between the titlebar decorations (the
button and text) and the window frame.  The default is 2 pixels.
.IP "\fBIconBackground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the background color of bitmap icons, and may
only be specified inside of a \fBColor\fP or \fBMonochrome\fP list.
This value is ignored when the icon is an \fIXpm\fP format pixmap, as they
have their own colors.  The optional \fIwin-list\fP is a list of window
names and colors so that per-window colors may be specified.  See the
\fBBorderColor\fP variable for a complete description of the
\fIwin-list\fP.  The default is "white".
.IP "\fBIconBorderColor\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the color of the border used for icon windows, and
may only be specified inside of a \fBColor\fP or \fBMonochrome\fP list.
This option only has an effect on icon windows that don't have their
own shape mask (ie, only on rectangular icons).
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.  See the \fBBorderColor\fP
variable for a complete description of the \fIwin-list\fP. 
The default is "black".
.IP "\fBIconBorderWidth\fP \fIpixels\fP" 8
This variable specifies the width in pixels of the border surrounding
icon windows.  The default is 2.
.IP "\fBIconDirectory\fP \fIstring\fP" 8
This variable specifies the directory that should be searched if 
if a bitmap file cannot be found in any of the directories
in the \fBbitmapFilePath\fP resource.  This is generally a poor way to
do things.  It is much better to set your \fBbitmapFilePath\fP resource
to what you want it to be in your resources file.
.IP "\fBIconFont\fP \fIstring\fP" 8
This variable specifies the font to be used to display icon names within
icons.  The default is "8x13".
.IP "\fBIconForeground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the foreground color to be used when displaying
bitmap icons, and may only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  This value is ignored when the
icon is an \fIXpm\fP format pixmap, as they have their own colors.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.  See the \fBBorderColor\fP
variable for a complete description of the \fIwin-list\fP.
The default is "black".
.IP "\fBIconifyByUnmapping [{ \fIwin-list\fP }]\fP" 8
This variable indicates that windows should be iconified by being unmapped
without trying to map any icons.  This assumes that the user is will 
remap the window through the icon manager, the \fBf.warpto\fP function, or
the \fITwmWindows\fP menu.
If the optional \fIwin-list\fP is provided, only those windows will be
iconified by simply unmapping.  Windows that have both this and the
\fBIconManagerDontShow\fP options set may not be accessible if no binding
to the \fITwmWindows\fP menu is set in the user's startup file.
.IP "\fBIconManagerBackground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the background color to use for icon manager entries,
and may only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.  See the \fBBorderColor\fP
variable for a complete description of the \fIwin-list\fP.
The default is "white".
.IP "\fBIconManagerDontShow\fP [{ \fIwin-list\fP }]" 8
This variable indicates that the icon manager should not display any
windows.  If the optional \fIwin-list\fP is given, only those windows will
not be displayed.  This variable is used to prevent windows that are rarely
iconified (such as \fIxclock\fP or \fIxload\fP) from taking up space in
the icon manager.
.IP "\fBIconManagerFont\fP \fIstring\fP" 8
This variable specifies the font to be used when displaying icon manager
entries.  The default is "8x13".
.IP "\fBIconManagerForeground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the foreground color to be used when displaying
icon manager entries, and may only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.  See the \fBBorderColor\fP
variable for a complete description of the \fIwin-list\fP.
The default is "black".
.IP "\fBIconManagerGeometry\fP \fIstring\fP [ \fIcolumns\fP ]" 8
This variable specifies the geometry of the icon manager window.  The 
\fIstring\fP argument is standard geometry specification that indicates 
the initial full size of the icon manager.  The icon manager window is
then broken into \fIcolumns\fP pieces and scaled according to the number
of entries in the icon manager.  Extra entries are wrapped to form
additional rows.  The default number of columns is 1.
.IP "\fBIconManagerHighlight\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the border color to be used when highlighting
the icon manager entry that currently has the focus,
and can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.  See the \fBBorderColor\fP
variable for a complete description of the \fIwin-list\fP.
The default is "black".
.IP "\fBIconManagers\fP { \fIiconmgr-list\fP }" 8
This variable specifies a list of icon managers to create.  Each item in the
\fIiconmgr-list\fP has the following format:
.EX 0
	"\fIwinname\fP" ["\fIiconname\fP"]	"\fIgeometry\fP" \fIcolumns\fP
.EE
where \fIwinname\fP is the name of the windows that should be put into this
icon manager, \fIiconname\fP is the name of that icon manager window's icon, 
\fIgeometry\fP is a standard geometry specification, and \fIcolumns\fP is
the number of columns in this icon manager as described in
\fBIconManagerGeometry\fP.  For example:
.EX 0
\fBIconManagers\fP
{
	"XTerm"	"=300x5+800+5"	5
	"myhost"	"=400x5+100+5"	2
}
.EE
Clients whose name or class is ``XTerm'' will have an entry created
in the ``XTerm'' icon manager.  Clients whose name was ``myhost'' would
be put into the ``myhost'' icon manager.
.IP "\fBIconManagerShow\fP { \fIwin-list\fP }" 8
This variable specifies a list of windows that should appear in the icon
manager.  When used in conjunction with the \fBIconManagerDontShow\fP
variable, only the windows in this list will be shown in the icon manager.
.IP "\fBIconRegion\fP \fIgeomstring\fP \fIvgrav hgrav gridwidth gridheight\fP"
This variable specifies an area on the root window in which icons are placed
if no specific icon location is provided by the client.  The \fIgeomstring\fP
is a quoted string containing a standard geometry specification.
If more than one
\fBIconRegion\fP lines are given,
icons will be put into the succeeding icon regions when the first is full.
The \fIvgrav\fP argument should be either \fBNorth\fP or \fBSouth\fP and
control and is used to control whether icons are first filled in from the
top or bottom of the icon region.  Similarly, the \fIhgrav\fP argument should
be either \fBEast\fP or \fBWest\fP and is used to control whether icons should
be filled in from left from the right.  Icons are laid out within the region
in a grid with cells \fIgridwidth\fP pixels wide and \fIgridheight\fP pixels 
high.
.IP "\fBIcons\fP { \fIwin-list\fP }" 8
This variable specifies a list of window names and the pixmap/bitmap filenames
that should be used as their icons.  For example:
.EX 0
\fBIcons\fP
{
	"XTerm"		"xterm.icon"
	"xfd"		"xfd_icon"
	"xeyes"		"xeyes.xpm"
}
.EE
Windows that match ``XTerm'' and would not be iconified by unmapping, and 
would try to use 
the icon pixmap/bitmap in the file ``xterm.icon''.  If \fBForceIcons\fP is
specified, this bitmap will be used even if the client has requested its
own icon pixmap.
.IP "\fBIconTitle\fP { \fIwin-list\fP }" 8
This variable specifies a list of clients that will have the icon
name displayed below the icon
and is used to request icon titles on specific windows when
\fBNoIconTitle\fP has been
set.
.IP "\fBInterpolateMenuColors\fP" 8
This variable indicates that menu entry colors should be interpolated between
entry specified colors.  In the example below:
.EX 0
\fBMenu\fP "mymenu"
{
	"Title"		("black":"red")		f.title
	"entry1"				f.nop
	"entry2"				f.nop
	"entry3"	("white":"green")	f.nop
	"entry4"				f.nop
	"entry5"	("red":"white")		f.nop
}
.EE
the foreground colors for ``entry1'' and ``entry2'' will be interpolated
between black and white, and the background colors between red and green.
Similarly, the foreground for ``entry4'' will be half-way between white and
red, and the background will be half-way between green and white.
.IP "\fBMakeTitle\fP { \fIwin-list\fP }" 8
This variable specifies a list of windows on which a titlebar should be placed
and is used to request titles on specific windows when \fBNoTitle\fP has been
set.
.IP "\fBMaxWindowSize\fP \fIstring\fP" 8
This variable specifies a geometry in which the width and height
give the maximum size for a given window.  This is typically used to 
restrict windows to the size of the screen.  The default is "30000x30000".
.IP "\fBMenuBackground\fP \fIstring\fP" 8
This variable specifies the background color used for menus,
and can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "white".
.IP "\fBMenuFont\fP \fIstring\fP" 8
This variable specifies the font to use when displaying menus.  The default
is "8x13".
.IP "\fBMenuForeground\fP \fIstring\fP" 8
This variable specifies the foreground color used for menus,
and can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "black".
.IP "\fBMenuShadowColor\fP \fIstring\fP" 8
This variable specifies the color of the shadow behind pull-down menus
and can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "black".
.IP "\fBMenuTitleBackground\fP \fIstring\fP" 8
This variable specifies the background color for \fBf.title\fP entries in
menus, and
can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "white".
.IP "\fBMenuTitleFont\fP \fIstring\fP" 8
This variable specifies the font to be used in menu titles.
.IP "\fBMenuTitleForeground\fP \fIstring\fP" 8
This variable specifies the foreground color for \fBf.title\fP entries in
menus and
can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "black".
.IP "\fBMonochrome\fP { \fIcolors\fP }" 8
This variable specifies a list of color assignments that should be made if
the screen has a depth of 1.  See the description of \fBColors\fP.
.IP "\fBMoveDelta\fP \fIpixels\fP" 8
This variable specifies the number of pixels the pointer
must move before the \fBf.move\fP function starts working.  Also
see the \fBf.deltastop\fP function.  The default is zero pixels.
.IP "\fBNoBackingStore\fP" 8
This variable indicates that \fItwm\fP's menus should not request backing
store to minimize repainting of menus.  This is typically
used with servers that can repaint faster than they can handle backing store.
.IP "\fBNoCaseSensitive\fP" 8
This variable indicates that case should be ignored when sorting icon names
in an icon manager.  This option is typically used with applications that 
capitalize the first letter of their icon name.
.IP "\fBNoDefaults\fP" 8
This variable indicates that \fItwm\fP should not supply the default 
titlebuttons and bindings.  This option should only be used if the startup
file contains a completely new set of bindings and definitions.
.IP "\fBNoGrabServer\fP" 8
This variable indicates that \fItwm\fP should not grab the server
when popping up menus and moving opaque windows.
.IP "\fBNoHighlight\fP [{ \fIwin-list\fP }]" 8
This variable indicates that borders should not be highlighted to track the
location of the pointer.  If the optional \fIwin-list\fP is given, highlighting
will only be disabled for those windows.
When the border is highlighted, it will
be drawn in the current \fBBorderColor\fP.  When the border is not
highlighted, it will be stippled with an gray pattern using the
current \fBBorderTileForeground\fP and \fBBorderTileBackground\fP colors.
.IP "\fBNoIconManagers\fP" 8
This variable indicates that no icon manager should be created.
.IP "\fBNoIconTitle\fP [{ \fIwin-list\fP }] " 8
This variable indicates that icons should not display the icon name
of the client.  If the
optional \fIwin-list\fP is given, only those clients will not have
icon titles.
\fBIconTitle\fP may be used with this option to force icon titles to
be put on
on specific clients
.IP "\fBNoMenuShadows\fP" 8
This variable indicates that linear menus should not have drop shadows
drawn behind them.  For pie menus, it means that pie menus should be
shaped, not drawn on a background.
.IP "\fBNoRaiseOnDeiconify\fP" 8
This variable indicates that windows that are deiconified should not be 
raised.
.IP "\fBNoRaiseOnMove\fP" 8
This variable indicates that windows should not be raised when moved.  This
is typically used to allow windows to slide underneath each other.
.IP "\fBNoRaiseOnResize\fP" 8
This variable indicates that windows should not be raised when resized.  This
is typically used to allow windows to be resized underneath each other.
.IP "\fBNoRaiseOnWarp\fP" 8
This variable indicates that windows should not be raised when the pointer
is warped into them with the \fBf.warpto\fP function.  If this option is set,
warping to an occluded window may result in the pointer ending up in the
occluding window instead the desired window (which causes unexpected behavior
with \fBf.warpring\fP). 
.IP "\fBNoSaveUnders\fP" 8
This variable indicates that menus should not request save-unders to minimize
window repainting following menu selection.  It is typically used with displays
that can repaint faster than they can handle save-unders.
.IP "\fBNoStackMode\fP [{ \fIwin-list\fP }]" 8
This variable indicates that client window requests to change stacking order 
should be ignored.  If the optional \fIwin-list\fP is given, only requests on 
those windows will be ignored.  This is typically used to prevent applications
from relentlessly popping themselves to the front of the window stack.
.IP "\fBNoTitle\fP [{ \fIwin-list\fP }] " 8
This variable indicates that windows should not have titlebars.  If the 
optional \fIwin-list\fP is given, only those windows will not have titlebars.
\fBMakeTitle\fP may be used with this option to force titlebars to be put
on specific windows.
.IP "\fBNoTitleFocus\fP" 8
This variable indicates that \fItwm\fP should not set keyboard input focus to
each window as it is entered.  Normally, \fItwm\fP sets the focus
so that focus and key events from the titlebar and
icon managers are delivered to the application.  If the pointer is moved
quickly and \fItwm\fP is slow to respond, input can be directed to the old
window instead of the new.  This option is typically
used to prevent this ``input lag'' and to 
work around bugs in older applications that have problems with focus events.
.IP "\fBNoTitleHighlight\fP [{ \fIwin-list\fP }]" 8
This variable indicates that the highlight area of the titlebar, which is
used to indicate the window that currently has the input focus, should not
be displayed.  If the optional \fIwin-list\fP is given, only those windows
will not have highlight areas.  This and the \fBSqueezeTitle\fP options
can be set to substantially reduce the amount of screen space required by
titlebars.
.IP "\fBOpaqueMove\fP" 8
This variable indicates that the \fBf.move\fP function should actually move
the window instead of just an outline so that the user can immediately see
what the window will look like in the new position.  This option is typically
used on fast displays (particularly if \fBNoGrabServer\fP is set).
.IP "\fBPannerBackgroundPixmap\fP \fIstring\fP" 8
This variable specifies the filename of a pixmap or bitmap file to be
used as the background image of the panner.  If this file is a bitmap, the 
\fBPannerBackground\fP and \fBPannerForeground\fP
colors are used when constructing the background.
.IP "\fBPannerGeometry\fP \fIstring\fP" 8
This variable specifies the position of the Virtual Desktop panner.
The default geometry is "-0-0".
.IP "\fBPannerOpaqueScroll\fP" 8
This variable causes the panner to scroll the Virtual Desktop
opaquely.  This variable only takes effect if the \fBStickyAbove\fP
variable is also set.
.IP "\fBPannerScale\fP \fIscale\fP" 8
This variable specifies that scale of the Virtual Desktop Panner
in relation to the actual screen.  The default scale is 20.
.IP "\fBPannerState\fP \fIstring\fP" 8
This variable specifies the initial state of the Virtual Desktop
panner window.  Possible initial state values include
"normal", "iconic", or "withdrawn".  The default initial state is
"normal".
.IP "\fBPieMenuWait\fP \fImilliseconds\fP" 8
Wait this number of milliseconds before popping up a pie menu.
.IP "\fBPixmaps\fP { \fIpixmaps\fP }" 8
This variable specifies a list of pixmaps that define the appearance of various
images.  Each entry is a keyword indicating the pixmap to set, followed by a 
string giving the name of the bitmap file.  The following pixmaps 
may be specified:
.EX 0
\fBPixmaps\fP
{
	VirtualDesktopBackgroundPixmap	"/homes/davis/pictures/background.gif"
	PannerBackgroundPixmap		"panner.xpm"
	TitleHighlight			"gray1"
}
.EE
The default for \fITitleHighlight\fP is to use an even stipple pattern.
The \fIVirtualDesktopBackgroundPixmap\fP and \fIPannerBackgroundPixmap\fP
pixmaps can be set as detailed in each of their own sections.
.IP "\fBRandomPlacement\fP" 8
This variable indicates that windows with no specified geometry should should
be placed in a pseudo-random location instead of having the user drag out
an outline.
.IP "\fBResizeFont\fP \fIstring\fP" 8
This variable specifies the font to be used for in the dimensions window when
resizing windows.  The default is "fixed".
.IP "\fBRestartPreviousState\fP" 8
This variable indicates that 
\fItwm\fP should attempt to use the WM_STATE property on client windows
to tell which windows should be iconified and which should be left visible.
This is typically used to make try to regenerate the state that the screen
was in before the previous window manager was shutdown.
.IP "\fBScrollDistanceX\fP \fIpercentage\fP" 8
This variable specifies the amount (as a percentage of the screen width)
to move when one of the scroll functions \fBf.scrollleft\fP
or \fBf.scrollright\fP is called.
.IP "\fBScrollDistanceY\fP \fIpercentage\fP" 8
This variable specifies the amount (as a percentage of the screen height)
to move when one of the scroll functions \fBf.scrollup\fP
or \fBf.scrolldown\fP is called.
.IP "\fBShowIconManager\fP" 8
This variable indicates that the icon manager window should be displayed when
\fItwm\fP is started.  It can always be brought up using the
\fBf.showiconmgr\fP function.
.IP "\fBShowVirtualNames\fP" 8
This variable causes client window names to be displayed in the
small virtual windows inside the Virtual Desktop panner.  The names
will be displayed using the current \fBVirtualFont\fP.
.IP "\fBSortIconManager\fP" 8
This variable indicates that entries in the icon manager should be 
sorted alphabetically rather than by simply appending new windows to 
the end.
.IP "\fBSqueezeTitle\fP [{ \fIsqueeze-list\fP }] " 8
This variable indicates that \fItwm\fP should attempt to use the SHAPE
extension to make titlebars occupy only as much screen space as they need,
rather than extending all the way across the top of the window.
The optional \fIsqueeze-list\fP
may be used to control the location of the squeezed titlebar along the
top of the window.  It contains entries of the form:
.EX 0
	"\fIname\fP"		\fIjustification\fP	\fInum\fP	\fIdenom\fP
.EE
where \fIname\fP is a window name, \fIjustification\fP is either \fBleft\fP,
\fBcenter\fP, or \fBright\fP, and \fInum\fP and \fIdenom\fP
are numbers specifying a ratio giving the relative position about which
the titlebar is justified.  The ratio is measured from left to right if
the numerator is positive, and right to left if negative.  A denominator
of 0 indicates that the numerator should be measured in pixels.  For 
convenience, the ratio 0/0 is the same as 1/2 for \fBcenter\fP and -1/1
for \fBright\fP.  For example:
.EX 0
\fBSqueezeTitle\fP
{
	"XTerm"	left		0	0
	"xterm1"	left		1	3
	"xterm2"	left		2	3
	"oclock"	center		0	0
	"emacs"	right		0	0
}
.EE
The \fBDontSqueezeTitle\fP list can be used to turn off squeezing on 
certain titles.
.IP "\fBStartIconified\fP [{ \fIwin-list\fP }] " 8
This variable indicates that client windows should initially be left as
icons until explicitly deiconified by the user.  If the optional \fIwin-list\fP
is given, only those windows will be started iconic.  This is useful for
programs that do not support an \fI-iconic\fP command line option or
resource.
.IP "\fBStayUpMenus\fP" 8
This variable alters menu interaction.  By default, a menu item is selected
when a mouse button is released over it.  This variable causes menu items to
be selected on the next button press event.
.IP "\fBSticky\fP [{ \fIwin-list\fP }]" 8
This variable is a list of client windows that will be sticky
by default.  See the \fBVIRTUAL DESKTOP\fP section for a full
description of sticky windows.
.IP "\fBStickyAbove\fP" 8
This variable causes sticky windows to be physically above non-sticky windows.
.IP "\fBTitleBackground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the background color used in titlebars,
and may only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.
The default is "white".
.IP "\fBTitleButtonBorderWidth\fP \fIpixels\fP" 8
This variable specifies the width in pixels of the border surrounding
titlebuttons.  This is typically set to 0 to allow titlebuttons to take up as
much space as possible and to not have a border.
The default is 1.
.IP "\fBTitleFont\fP \fIstring\fP" 8
This variable specifies the font to used for displaying window names in
titlebars.  The default is "8x13".
.IP "\fBTitleFontPadding\fP \fIpixels\fP" 8
This variable specifies the number of pixels of padding to be placed 
above window titles.  This allows for using small fonts with larger buttons.
.IP "\fBTitleForeground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the foreground color used in titlebars, and
may only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.
The default is "black".
.IP "\fBTitlePadding\fP \fIpixels\fP" 8
This variable specifies the distance between the various buttons, text, and
highlight areas in the titlebar.  The default is 8 pixels.
.IP "\fBUnknownIcon\fP \fIstring\fP" 8
This variable specifies the filename of a bitmap file to be
used as the default icon.  This bitmap will be used as the icon of all
clients which do not provide an icon bitmap and are not listed
in the \fBIcons\fP list.
.IP "\fBUsePPosition\fP \fIstring\fP" 8
This variable specifies whether or not \fItwm\fP should honor 
program-requested locations (given by the \fBPPosition\fP flag in the
WM_NORMAL_HINTS property) in the absence of a user-specified position.
The argument \fIstring\fP may have one of three values:  \fB"off"\fP
(the default) 
indicating that \fItwm\fP
should ignore the program-supplied position, 
\fB"on"\fP indicating that the position
should be used, and 
\fB"non-zero"\fP indicating that the position should used if
it is other than (0,0).  The latter option is for working around a bug in 
older toolkits.
.IP "\fBVirtualDesktop\fP \fIstring\fP" 8
This variable enables the Virtual Desktop feature and specifies
the initial size of the desktop, either in pixels or in integral multiples
of the screen size.
The size is specified as a standard geometry string.
If a width or height value is smaller than the width or
height of the physical display, it is assumed to mean a multiple of the
screen size, otherwise it is assumed to be in pixels.
So to get a 2x2 sized Virtual Desktop
across all platforms, one could use the string "2x2" to enable
the desktop.
.IP "\fBVirtualDesktopBackgroundPixmap\fP \fIstring\fP" 8
This variable specifies the filename of a image to be used as the
background image of the Virtual Desktop.  If you have configured \fItwm\fP
to use \fIxloadimage(1)\fP to load this image, the \fIstring\fP must be
a full pathname, or be in the image-path in your \fI~/.xloadimagerc\fP
file.  If you have not configured \fItwm\fP to use \fIxloadimage(1)\fP,
then it will load a bitmap or pixmap in the traditional fashion.  If the
pixmap you load is a bitmap (one plane deep),
\fBVirtualDesktopBackground\fP and \fBVirtualDesktopForeground\fP
colors are used when constructing the background.
.IP "\fBWarpCursor\fP [{ \fIwin-list\fP }]" 8
This variable indicates that the pointer should be warped into windows when
they are deiconified.  If the optional \fIwin-list\fP is given, the pointer
will only be warped when those windows are deiconified.  This will
also change the position of the virtual desktop if the unmapped window
wasn't visible from the actual position.
.IP "\fBVirtualFont\fP \fIfont\fP" 8
This is the font used to display window names in the small windows inside
the panner if the \fBShowVirtualNames\fP variable is specified.  The default
font is "5x8".
.IP "\fBWindowRing\fP { \fIwin-list\fP }" 8
This variable specifies a list of windows along which the \fBf.warpring\fP 
function cycles.
.IP "\fBWarpUnmapped\fP" 8
This variable indicates that that the \fBf.warpto\fP function should deiconify
any iconified windows it encounters.  This is typically used to make a key
binding that will pop a particular window (such as \fIxmh\fP), no matter
where it is.  The default is for \fBf.warpto\fP to ignore iconified windows.
.IP "\fBXorValue\fP \fInumber\fP" 8
This variable specifies the value to use when drawing window outlines for
moving and resizing.  This should be set to a value that will result in a 
variety of
of distinguishable colors when exclusive-or'ed with the contents of the
user's typical screen.  Setting this variable to 1 often gives nice results
if adjacent colors in the default colormap are distinct.  By default, 
\fItwm\fP will attempt to cause temporary lines to appear at the opposite 
end of the colormap from the graphics.
.IP "\fBZoom\fP [ \fIcount\fP ]" 8
This variable indicates that outlines suggesting movement of a window
to and from its iconified state should be displayed whenever a window is
iconified or deiconified.  The optional \fIcount\fP argument specifies the
number of outlines to be drawn.  The default count is 8.
.PP
The following variables must be set after the fonts have been
assigned, so it is usually best to put them at the end of the variables
or beginning of the bindings sections:
.IP "\fBDefaultFunction\fP \fIfunction\fP" 8
This variable specifies the function to be executed when a key or button
event is received for which no binding is provided.  This is typically
bound to \fBf.nop\fP, \fBf.beep\fP, or a menu containing window operations.
.IP "\fBWindowFunction\fP \fIfunction\fP" 8
This variable specifies the function to execute when a window is selected 
from the \fBTwmWindows\fP menu.  If this variable is not set, the window
will be deiconified and raised.
.SH BINDINGS
.PP
After the desired variables have been set, functions may be attached 
titlebuttons and key and pointer buttons.  Titlebuttons may be added
from the left or right side and appear in the titlebar from left-to-right 
according to the
order in which they are specified.  Key and pointer button
bindings may be given in any order.
.PP
Titlebuttons specifications must include the name of the pixmap to use in
the button box and the function to be invoked when a pointer button is 
pressed within them:
.EX 0
\fBLeftTitleButton\fP "\fIbitmapname\fP"	= \fIfunction\fP
.EE
or
.EX 0
\fBRightTitleButton\fP "\fIbitmapname\fP"	= \fIfunction\fP
.EE
The \fIbitmapname\fP may refer to one of the  built-in bitmaps
(which are scaled to match \fBTitleFont\fP) by using the appropriate
colon-prefixed name described above.
.PP
Key and pointer button specifications must give the modifiers that must
be pressed, over which parts of the screen the pointer must be, and what
function is to be invoked.  Keys are given as strings containing the 
appropriate
keysym name; buttons are given as the keywords \fBButton1\fP-\fBButton5\fP:
.EX 0
"FP1"		= \fImodlist\fP : \fIcontext\fP : \fIfunction\fP
\fBButton1\fP	= \fImodlist\fP : \fIcontext\fP : \fIfunction\fP
.EE
The \fImodlist\fP is any combination of the modifier names \fBshift\fP,
\fBcontrol\fP, \fBlock\fP, \fBmeta\fP, \fBmod1\fP, \fBmod2\fP, \fBmod3\fP,
\fBmod4\fP, or \fBmod5\fP (which may be abbreviated as 
\fBs\fP, \fBc\fP, \fBl\fP, \fBm\fP, \fBm1\fP, \fBm2\fP, \fBm3\fP, \fBm4\fP, 
\fBm5\fP, respectively) separated by a vertical bar (\(or).
Similarly, the \fIcontext\fP is any combination of 
\fBwindow\fP,
\fBtitle\fP,
\fBicon\fP,
\fBroot\fP,
\fBframe\fP,
\fBiconmgr\fP, their first letters (\fBiconmgr\fP abbreviation is \fBm\fP),
or \fBall\fP,
separated by a vertical bar.  The \fIfunction\fP is any of the \fBf.\fP 
keywords described below.  For example, the default startup
file contains the following bindings:
.EX 0
Button1	=	: root		: f.menu "TwmWindows"
Button1	= m	: window | icon	: f.function "move-or-lower"
Button2	= m	: window | icon	: f.iconify
Button3	= m	: window | icon	: f.function "move-or-raise"
Button1	=	: title		: f.function "move-or-raise"
Button2	=	: title		: f.raiselower
Button1	=	: icon		: f.function "move-or-iconify"
Button2	=	: icon		: f.iconify
Button1	=	: iconmgr	: f.iconify
Button2	=	: iconmgr	: f.iconify
.EE
A user who wanted to be able to manipulate windows from the keyboard could
use the following bindings:
.EX 0
"F1"		=	: all		: f.iconify
"F2"		=	: all		: f.raiselower
"F3"		=	: all		: f.warpring "next"
"F4"		=	: all		: f.warpto "xmh"
"F5"		=	: all		: f.warpto "emacs"
"F6"		=	: all		: f.colormap "next"
"F7"		=	: all		: f.colormap "default"
"F20"		=	: all		: f.warptoscreen "next"
"Left"		= m	: all		: f.backiconmgr
"Right"	= m | s	: all		: f.forwiconmgr
"Up"		= m	: all		: f.upiconmgr
"Down"	= m | s	: all		: f.downiconmgr
.EE
\fITwm\fP provides many more window manipulation primitives than can be
conveniently stored in a titlebar, menu, or set of key bindings.  Although
a small set of defaults are supplied (unless the \fBNoDefaults\fP is 
specified), most users will want to have their most common operations
bound to key and button strokes.  To do this, \fItwm\fP associates names
with each of the primitives and provides \fIuser-defined functions\fP for
building higher level primitives and \fImenus\fP for interactively selecting 
among groups of functions. 
.PP
User-defined functions contain the name by which they are referenced in
calls to \fBf.function\fP and a list of other functions to execute.  For
example:
.EX 0
Function "move-or-lower"	{ f.move f.deltastop f.lower }
Function "move-or-raise"	{ f.move f.deltastop f.raise }
Function "move-or-iconify"	{ f.move f.deltastop f.iconify }
Function "restore-colormap"	{ f.colormap "default" f.lower }
.EE
The function name must be used in \fBf.function\fP exactly as it appears in 
the function specification.
.PP
In the descriptions below, if the function is said to operate on the selected
window, but is invoked from a root menu, the cursor will be changed to
the \fBSelect\fP cursor and the next window to receive a button press will
be chosen:
.IP "\fB!\fP \fIstring\fP" 8
This is an abbreviation for \fBf.exec\fP \fIstring\fP.
.\"OBSOLETE - use a clipboard client
.\".IP "\fB^\fP \fIstring\fP" 8
.\"This is an abbreviation for \fBf.cut\fP \fIstring\fP.
.IP "\fBf.autoraise\fP" 8
This function toggles whether or not the selected window is raised whenever
entered by the pointer.  See the description of the variable \fBAutoRaise\fP.
.IP "\fBf.backiconmgr\fI" 8
This function warps the pointer to the previous column in the 
current icon manager, wrapping back to the previous row if necessary.
.IP "\fBf.beep\fP" 8
This function sounds the keyboard bell.
.IP "\fBf.bottomzoom\fP" 8
This function is similar to the \fBf.fullzoom\fP function, but
resizes the window to fill only the bottom half of the screen.
.IP "\fBf.circledown\fP" 8
This function lowers the top-most window that occludes another window.
.IP "\fBf.circleup\fP" 8
This function raises the bottom-most window that is occluded by another window.
.IP "\fBf.colormap\fP \fIstring\fP" 8
This function rotates the colormaps (obtained from the WM_COLORMAP_WINDOWS
property on the window) that \fItwm\fP will display when the pointer
is in this window.  The argument \fIstring\fP may have one of the following 
values: \fB"next"\fP, \fB"prev"\fP, and \fB"default"\fP.
.IP "\fBf.constrainedmove\fP" 8
This function will have approximately the same behavior, except that the
move will be constrained without need for double clicking.
.\"OBSOLETE - should go away and use a clipboard.
.\".IP "\fBf.cut\fP \fIstring\fP" 8
.\"This function places the specified \fIstring\fP (followed by a newline
.\"character) into the root window property CUT_BUFFER0.  
.\".IP "\fBf.cutfile\fP" 8
.\"This function reads the file indicated by the contents of the CUT_BUFFER0
.\"window property and replaces the cut buffer.
.IP "\fBf.deiconify\fP" 8
This function deiconifies the selected window.  If the window is not an icon, 
this function does nothing.
.IP "\fBf.delete\fP" 8
This function sends the WM_DELETE_WINDOW message to the selected window if
the client application has requested it through the WM_PROTOCOLS window
property.  The application is supposed to respond to the message by removing
the indicated window.  If the window has not requested
WM_DELETE_WINDOW messages, the keyboard bell will be rung indicating that 
the user should choose an alternative method.
.IP "\fBf.deltastop\fP" 8
This function allows a user-defined function to be aborted if the pointer has 
been moved more than \fIMoveDelta\fP pixels.  See the example definition
given for \fBFunction "move-or-raise"\fP at the beginning of the section.
.IP "\fBf.destroy\fP" 8
This function instructs the X server to close the display connection of the
client that created the selected window.  This should only be used as a last 
resort for shutting down runaway clients.  
.IP "\fBf.downiconmgr\fI" 8
This function warps the pointer to the next row in the current icon manger,
wrapping to the beginning of the next column if necessary.
.IP "\fBf.exec\fP \fIstring\fP" 8
This function passes the argument \fIstring\fP to /bin/sh for execution.
In multiscreen mode, if \fIstring\fP starts a new X client without
giving a display argument, the client will appear on the screen from
which this function was invoked.
.\".IP "\fBf.file\fP \fIstring\fP" 8
.\"This function assumes \fIstring\fP is a file name.  This file is read into
.\"the window server's cut buffer.
.IP "\fBf.focus\fP" 8
This function toggles the keyboard focus of the server to the
selected window, changing the focus rule from pointer-driven if necessary.
If the selected window already was focused, this function executes an
\fBf.unfocus\fP.  
.IP "\fBf.forcemove\fP" 8
This function is like \fBf.move\fP except that it ignores the \fBDontMoveOff\fP
variable.
.IP "\fBf.forwiconmgr\fI" 8
This function warps the pointer to the next column in the current icon
manager, wrapping to the beginning of the next row if necessary.
.IP "\fBf.fullzoom\fP" 8
This function resizes the selected window to the full size of the display or
else restores the original size if the window was already zoomed.
.IP "\fBf.function\fP \fIstring\fP" 8
This function executes the user-defined function whose name is specified
by the argument \fIstring\fP.  
.IP "\fBf.hbzoom\fP" 8
This function is a synonym for \fBf.bottomzoom\fP.
.IP "\fBf.hideiconmgr\fP" 8
This function unmaps the current icon manager.
.IP "\fBf.horizoom\fP" 8
This variable is similar to the \fBf.zoom\fP function except that the 
selected window is resized to the full width of the display.
.IP "\fBf.htzoom\fP" 8
This function is a synonym for \fBf.topzoom\fP.
.IP "\fBf.hzoom\fP" 8
This function is a synonym for \fBf.horizoom\fP.
.IP "\fBf.iconify\fP" 8
This function iconifies or deiconifies the selected window or icon, 
respectively.
.IP "\fBf.identify\fP" 8
This function displays a summary of the name and geometry of the
selected window.  Clicking the pointer or pressing a key in the window
will dismiss it.
.IP "\fBf.lefticonmgr\fI" 8
This function similar to \fBf.backiconmgr\fP except that wrapping does not
change rows.
.IP "\fBf.leftzoom\fP" 8
This variable is similar to the \fBf.bottomzoom\fP function but causes
the selected window is only resized to the left half of the display.
.IP "\fBf.lower\fP" 8
This function lowers the selected window.
.IP "\fBf.menu\fP \fIstring\fP" 8
This function invokes the menu specified by the argument \fIstring\fP.
Cascaded menus may be built by nesting calls to \fBf.menu\fP and \fBf.piemenu\fP.
.IP "\fBf.move\fP" 8
This function drags an outline of the selected window (or the window itself
if the \fBOpaqueMove\fP variable is set) until the invoking pointer button
is released.  Double clicking within the number of milliseconds given by
\fBConstrainedMoveTime\fP warps
the pointer to the center of the window and
constrains the move to be either horizontal or vertical depending on which
grid line is crossed.
To abort a move, press another button before releasing the
first button.
.IP "\fBf.nexticonmgr\fI" 8
This function warps the pointer to the next icon manager containing any windows
on the current or any succeeding screen.
.IP "\fBf.nop\fP" 8
This function does nothing and is typically used with the \fBDefaultFunction\fP
or \fBWindowFunction\fP variables or to introduce blank lines in menus.
.IP "\fBf.opaquemove\fP" 8
This function will exact as does \fBf.move\fP, but it will do an opaque
move regardless of whether \fBOpaqueMove\fP is set or not.
.IP "\fBf.panner\fI" 8
This function toggles the display of the panner window.
.IP "\fBf.piemenu\fP \fIstring\fP" 8
This function invokes the pie menu specified by the argument \fIstring\fP.
Cascaded menus may be built by nesting calls to \fBf.piemenu\fP and \fBf.menu\fP.
.IP "\fBf.previconmgr\fI" 8
This function warps the pointer to the previous icon manager containing any
windows on the current or preceding screens.
.IP "\fBf.quit\fP" 8
This function causes \fItwm\fP to restore the window's borders and exit.  If
\fItwm\fP is the first client invoked from \fIxdm\fP, this will result in a
server reset.
.IP "\fBf.raise\fP" 8
This function raises the selected window.
.IP "\fBf.raiselower\fP" 8
This function raises the selected window to the top of the stacking order if
it is occluded by any windows, otherwise the window will be lowered.
.IP "\fBf.refresh\fP" 8
This function causes all windows to be refreshed.
.IP "\fBf.relativeresize\fP" 8
This function will do a resize and behave as if \fBAutoRelativeResize\fP
were set, whether it is or not
.IP "\fBf.resize\fP" 8
This function displays an outline of the selected window.  Crossing a border
(or setting \fBAutoRelativeResize\fP) will cause the outline to begin to 
rubber band until the invoking button is released.  To abort a resize,
press another button before releasing the first button.
.IP "\fBf.restart\fP" 8
This function kills and restarts \fItwm\fP.
.IP "\fBf.righticonmgr\fI" 8
This function is similar to \fBf.nexticonmgr\fP except that wrapping does
not change rows.
.IP "\fBf.rightzoom\fP" 8
This variable is similar to the \fBf.bottomzoom\fP function except that
the selected window is only resized to the right half of the display.
.IP "\fBf.saveyourself\fP" 8
This function sends a WM_SAVEYOURSELF message to the selected window if it
has requested the message in its WM_PROTOCOLS window property.  Clients that
accept this message are supposed to checkpoint all state associated with the
window and update the WM_COMMAND property as specified in the ICCCM.  If
the selected window has not selected for this message, the keyboard bell
will be rung.
.IP "\fBf.scroll\fP \fIstring\fP" 8
This function scrolls the Virtual Desktop to a specific logical screen
quadrant.  The \fIstring\fP parameter is a geometry specification
indicating how to scroll the desktop.  For example, "+0+0" would scroll
the desktop to the home location and "+2+1" would scroll the desktop
to the quadrant in the third logical column and the second row.
.IP "\fBf.scrollback\fP
This function scrolls the Virtual Desktop back to its previous
location.
.IP "\fBf.scrolldown\fP" 8
This function scrolls the Virtual Desktop down a fraction of the height of
the screen specified in ScrollDistanceY.
.IP "\fBf.scrollhome\fP" 8
This function scrolls the Virtual Desktop to the home location.
.IP "\fBf.scrollleft\fP" 8
This function scrolls the Virtual Desktop left a fraction of the width of
the screen specified in ScrollDistanceX.
.IP "\fBf.scrollright\fP" 8
This function scrolls the Virtual Desktop right a fraction of the width of
the screen specified in ScrollDistanceX.
.IP "\fBf.scrollup\fP" 8
This function scrolls the Virtual Desktop up one a fraction of the height of
the screen specified in ScrollDistanceY.
.IP "\fBf.showiconmgr\fP" 8
This function maps the current icon manager.
.IP "\fBf.sorticonmgr\fP" 8
This function sorts the entries in the current icon manager alphabetically.
See the variable \fBSortIconManager\fP.
.\".IP "\fBf.source\fP \fIstring\fP" 8
.\"This function assumes \fIstring\fP is a file name.  The file is read 
.\"and parsed as a \fItwm\fP startup file.
.\"This
.\"function is intended to be used only to re-build pull-down menus.  None
.\"of the \fItwm\fP variables are changed.
.IP "\fBf.stick\fP" 8
This funtion toggles making a window sticky.
.IP "\fBf.title\fP" 8
This function provides a centered, unselectable item in a menu definition.  It
should not be used in any other context.
.IP "\fBf.topzoom\fP" 8
This variable is similar to the \fBf.bottomzoom\fP function except that 
the selected window is only resized to the top half of the display.
.\".IP "\fBf.twmrc\fP" 8
.\"This function causes the startup customization file to be re-read.  This
.\"function is exactly like the \fBf.source\fP function without having to
.\"specify the filename.
.IP "\fBf.unfocus\fP" 8
This function resets the focus back to pointer-driven.  This should be used
when a focused window is no longer desired.
.IP "\fBf.upiconmgr\fI" 8
This function warps the pointer to the previous row in the current icon
manager, wrapping to the last row in the same column if necessary.
.\".IP "\fBf.version\fI" 8
.\"This function causes the \fItwm\fP version window to be displayed.  This
.\"window will be displayed until a pointer button is pressed or the
.\"pointer is moved from one window to another.
.IP "\fBf.vlzoom\fP" 8
This function is a synonym for \fBf.leftzoom\fP.
.IP "\fBf.vrzoom\fP" 8
This function is a synonym for \fBf.rightzoom\fP.
.IP "\fBf.warpring\fP \fIstring\fP" 8
This function warps the pointer to the next or previous window (as indicated
by the argument \fIstring\fP, which may be \fB"next"\fP or \fB"prev"\fP) 
specified in the \fBWindowRing\fP variable.
.IP "\fBf.warpto\fP \fIstring\fP" 8
This function warps the pointer to the window which has a name or class 
that matches \fIstring\fP.  If the window is iconified, it will be deiconified
if the variable \fBWarpUnmapped\fP is set or else ignored.  In addition
to warping the pointer to the window the Virtual Desktop
will be scrolled to the logical quadrant that contains the window.
.IP "\fBf.warptoiconmgr\fP \fIstring\fP" 8
This function warps the pointer to the icon manager entry 
associated with the window containing the pointer in the icon manager
specified by the argument \fIstring\fP.  If \fIstring\fP is empty (i.e. ""),
the current icon manager is chosen.
.IP "\fBf.warptoscreen\fP \fIstring\fP" 8
This function warps the pointer to the screen specified by the
argument \fIstring\fP.  \fIString\fP may be a number (e.g. \fB"0"\fP or
\fB"1"\fP), the word \fB"next"\fP (indicating the current screen plus 1,
skipping over any unmanaged screens), 
the word \fB"back"\fP (indicating the current screen minus 1, skipping over
any unmanaged screens), or the word
\fB"prev"\fP (indicating the last screen visited.
.IP "\fBf.winrefresh\fP" 8
This function is similar to the \fBf.refresh\fP function except that only the
selected window is refreshed.
.IP "\fBf.zoom\fP" 8
This function is similar to the \fBf.fullzoom\fP function, except that
the only the height of the selected window is changed.
.SH MENUS
.PP
Functions may be grouped and interactively selected using pop-up
(when bound to a pointer button) or pull-down (when associated
with a titlebutton) linear menus or pie menus.  Normal menus have 
a vertical layout, and pie menus have a circular layout.  
Each menu specification contains the name of the 
menu as it will be referred to by \fBf.menu\fP or \fBf.piemenu\fP, 
optional initial direction (for pie menus),
optional default foreground and background colors, 
the list of item names and the functions they should invoke, 
and optional foreground and background colors for individual items:
.EX 0
\fbMenu\fP "\fImenuname\fP" [ ("\fIdeffore\fP":"\fIdefback\fP") ]
{
	\fIstring1\fP	[ ("\fIfore1\fP":"\fIbackn\fP")]	\fIfunction1\fP
	\fIstring2\fP	[ ("\fIfore2\fP":"\fIbackn\fP")]	\fIfunction2\fP
		.
		.
		.
	\fIstringN\fP	[ ("\fIforeN\fP":"\fIbackN\fP")]	\fIfunctionN\fP
}
.EE
.PP
The \fImenuname\fP is case-sensitive.
The optional \fIdeffore\fP and \fIdefback\fP arguments specify the foreground
and background colors used on a color display 
to highlight menu entries.
The \fIstring\fP portion
of each menu entry will be the text which will appear in the menu.
The optional \fIfore\fP and \fIback\fP arguments specify the foreground
and background colors of the menu entry when the pointer is not in
the entry.  These colors will only be used on a color display.  The
default is to use the colors specified by the 
\fBMenuForeground\fP and \fBMenuBackground\fP variables.
The \fIfunction\fP portion of the menu entry is one of the functions,
including any user-defined functions, or additional menus.
.PP
There is a special menu named \fBTwmWindows\fP which contains the names of
all of the client and \fItwm\fP-supplied windows.  Selecting an entry will
cause the
\fBWindowFunction\fP to be executed on that window.  If \fBWindowFunction\fP
hasn't been set, the window will be deiconified and raised.  If the Virtual
Desktop is enabled, the desktop will also be scrolled to the logical quadrant
that contains the windows.
.PP
Pie menus are defined in the same way as linear menus, using the 
\fBPieMenu\fP command instead of the \fBMenu\fP command.  They
have an extra optional argument specifying the direction of the
first label, in \fIdegrees\fP.  Subsequent labels are evenly spaced in 
a circle around the center of the menu, in a counter-clockwise direction.  
The default direction if not specified is 0, which is to the right. 
.EX 0
\fbPieMenu\fP "\fIpiemenuname\fP" [ ("\fIdeffore\fP":"\fIdefback\fP") ] [ @ \fIdegrees\FP ] 
{
	\fIstring1\fP	[ ("\fIfore1\fP":"\fIbackn\fP")]	\fIfunction1\fP
	\fIstring2\fP	[ ("\fIfore2\fP":"\fIbackn\fP")]	\fIfunction2\fP
		.
		.
		.
	\fIstringN\fP	[ ("\fIforeN\fP":"\fIbackN\fP")]	\fIfunctionN\fP
}
.EE
.SH ICONS
\fITwm\fP supports several different ways of manipulating iconified windows.
The common pixmap-and-text style may be laid out by hand or automatically
arranged as described by the \fBIconRegion\fP variable.  In addition, a
terse grid of icon names, called an icon manager, provides a more efficient
use of screen space as well as the ability to navigate among windows from
the keyboard.
.PP
An icon manager is a window that contains names of selected or all
windows currently on the display.  In addition to the window name,
a small button using the default iconify symbol will be displayed to the 
left of the name when the window is iconified.  By default, clicking on an 
entry in the icon manager performs \fBf.iconify\fP.
To change the actions taken in the icon manager, use the 
the \fBiconmgr\fP context when specifying button and keyboard bindings.
.PP
Moving the pointer into the icon manager also directs keyboard focus to
the indicated window (setting the focus explicitly or else sending synthetic
events \fBNoTitleFocus\fP is set).
Using the \fBf.upiconmgr\fP, \fBf.downiconmgr\fP
\fBf.lefticonmgr\fP, and
\fBf.righticonmgr\fP functions,
the input focus can be changed between windows directly from the keyboard.
.SH BUGS
The resource manager should have been used instead of all of the window
lists.
.PP
The \fBIconRegion\fP variable should take a list.
.PP
Double clicking very fast to get the constrained move function will sometimes
cause the window to move, even though the pointer is not moved.
.PP
If \fBIconifyByUnmapping\fP is on and windows are listed in 
\fBIconManagerDontShow\fP but not in \fBDontIconifyByUnmapping\fP, 
they may be lost if they are iconified and no bindings to 
\fBf.menu "TwmWindows"\fP or \fBf.warpto\fP are setup.
.SH FILES
.PP
.nf
 $HOME/.piewmrc.<screen number>
 $HOME/.piewmrc
 $HOME/.twmrc.<screen number>
 $HOME/.twmrc
 /usr/lib/X11/twm/system.twmrc
.fi
.SH "ENVIRONMENT VARIABLES"
.IP "DISPLAY" 8
This variable is used to determine which X server to use.  It is also set
during \fBf.exec\fP so that programs come up on the proper screen.
.IP "HOME" 8
This variable is used as the prefix for files that begin with a tilde and
for locating the \fItwm\fP startup file.
.SH "SEE ALSO"
.PP
X(1), Xserver(1), xdm(1), xrdb(1), m4(1)
.SH COPYRIGHT
Portions copyright 1988 Evans & Sutherland Computer Corporation; portions
copyright 1989 Hewlett-Packard Company and the Massachusetts Institute of
Technology,  See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Tom LaStrange, Solbourne Computer; Chris Ross, University of Maryland;
Jim Fulton, MIT X Consortium;      Steve Pitschke, Stardent Computer;
Keith Packard, MIT X Consortium;   Dave Payne, Apple Computer;
Don Hopkins, CMU.
.PP
Virtual Desktop added by Tom LaStrange, Solbourne Computer.
.PP
Pie menus designed and implemented by Don Hopkins, CMU.
