/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * var.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __VAR_H__
#define __VAR_H__

#include <glib.h>
#include "hl_locks.h"

/*****************************************************/
/* this mutex locks all pointers of user description */
/* if you don't lock pointers, you may encounter     */
/* random crash.                                     */
/*****************************************************/
/* nickname, user_desc, cnx_type, email, host_ip */
/*************************************************/
extern HL_MUTEX user_info;				/* (un)LOCK_READ and (un)LOCK_WRITE */

/*******************************/
/* user description for DC hub */
/*******************************/
extern char *nickname;              /* user nickname */
extern char *user_desc;             /* user description (can be NULL) */
extern char *cnx_type;              /* connection type. (ex: DSL,Cable,...) */
extern char cnx_opt;                /* user status */
                                 /* bit 0 always set. */
                                 /* bit 1 ? ==0, user here, ==1, user away */
                                 /* bit 2 ? ==0, normal, ==1, is server */
                                 /*         according to DC doc, a server is a client online */
                                 /*         for more than 2 jours.                           */
                                 /* bit 3 ? ==0, normal, ==1, fast upload */
                                 /*         according to DC doc, a fast upload is a client */
                                 /*         having an upload speed greater than 100KB/s. */

extern char *email;                 /* user e-mail (can be NULL) */
extern double sizeof_data;          /* size of the data shared by this client */
extern double offset_sizeof_data;	/* when the client has to return the size of data it shares, this value */
												/* is added to the previous one */

extern int free_dl_slot;            /* number of free download slot */
extern int ttl_dl_slot;             /* number of existing download slot */
extern int dl_on;                /* this flag enables or disables the upload capability */
                                 /* if ==1, other users can download from you */
                                 /* if ==0, other users cannot download from you */
                                 /* this flag doesn't affect free_dl_slot/ttl_dl_slot */
                                 /* you still return the original value. If someone want to download, */
                                 /* the client will just return a "no more slot" message. */

extern char *nick_passwd;			/* when the hub wants a password. We will use the one here */
											/* if ==NULL, the client waits one before resuming */


/**************************************/
/* description of the connection type */
/**************************************/
/* (BHF means behind firewall) */
/*******************************/
extern int behind_fw;               /* !=0, host is behind firewall */
extern unsigned short com_port;     /* port available, to receive data if not behind fw */
                                    /* default value is 412 but it is not very good     */
                                    /* because port below 1024 are not allowed for      */
                                    /* non-privileged users under Un*x                  */
extern char *host_ip;               /* ip of this host */

extern GString *org_hubip; /* strings received from the -g flag */
                           /* don't use it except you need the original -g parameter */
extern GString *hubip;       /* IP of the hub where we are connected */
extern unsigned int hub_port; /* port of the hub where we are connected (411 is the default port) */
extern GString *hubname;     /* Name of the hub where we are connected (filed when connected) */

extern int follow_force_move;   /* does the client accept $ForceMove and $OpForceMove */

extern unsigned int recon_delay;  /* number of seconds before the hub connection loss and the /RECON */
extern unsigned int auto_rebuild_delay; /* number of seconds between 2 rebuilds of the shared database */
														/* 0== auto-rebuild disabled */
unsigned int auto_scan_delay;	/* number of seconds between 2 GDL autoscan */

extern int main_sck;				/* it is the socket connected to the hub */
extern int cnx_in_progress;	/* this flag is set when main_sck is !=-1 but the connect stage is not yet done */

extern int in_sck;				/* it is the socket to use as com port (-1=no socket else socket descriptor) */
extern int srch_sck;				/* it is the UDP socket used to receive active search result (-1=no socket) */
              						/* it uses the same port number has in_sck */

extern int keyb_fd;        /* it is the keyboard fd */
                           /* must be ==0. If the client loses its term, goes to -1 */

extern int when_done;      /* when a download is done, ==0, do nothing */
                           /* ==1, move the file into the done/ directory */

extern int wanna_emode;		/* when the --mdc flag is used, this variable contains the flag value */
extern int having_emode;	/* depending of the connected hub, the current emode may differ from the */
                           /* wanted emode, 0 is the default DC mode */

extern int with_md5sum;		/* enable/disable md5sum for content search */

extern int with_ddl;			/* enable/disable dDL capability */

/************************************************************/
/* debug mode. ==0, no debug. !=0, debug mode               */
/* if debug_mode is set, all debug messages will be printed */
/************************************************************/
extern int debug_mode;

extern int force_quit;	/* if ==1, when /QUIT is called, it doesn't wait end of xfers */

/*******************************************************************/
/* the following vars are used to manage the local AF_UNIX sockets */
/*******************************************************************/
extern GString *dctc_dir;									/* =$(HOME)/.dctc */
extern GString *local_dctc_sock_path;             /* local name = $(dctc_dir)/running/dctc-xxxxxxxx-yyyyyyyyyy */
extern int local_sck;                             /* main local socket (to accept connection) */
G_LOCK_EXTERN(local_client_socket);
extern GArray *local_client_socket;               /* array of all locally connected socket */

extern const char *dc_version;									/* version of DC to use */

/*****************************************/
/* information to limit upload bandwidth */
/*****************************************/
extern int bl_semid;

G_LOCK_EXTERN(inet_ntoa);					/* inet_ntoa is not thread safe, this prevents error */

#endif
