/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * typical_action.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "typical_action.h"
#include "dc_com.h"
#include "var.h"

/*********************************************************************/
/* setup our info on hub                                             */
/* string format:  $MyINFO $ALL nickname aaa$ $xxxf$bbb$yyy$         */
/*       aaa is user description                                     */
/*			xxx is connection type (ex: Cable)                          */
/*       f is a 1 byte flag. Default value: \x01                     */
/*             if not behind firewall, bit 1 must be set, else clear */
/*			bbb is e-mail (empty string)                                */
/*			yyy is size of shared data in bytes                         */
/*********************************************************************/
void set_user_info(int sck,char *nick, char *description, char *cnx,char cnx_opt,char *mail,double amount)
{
	GString *user_info;

	user_info=g_string_new("$MyINFO $ALL ");
	g_string_sprintfa(user_info,"%s %s$ $%s%c$%s$%.0lf$",
										nick,
										(description!=NULL)?description:"",
										cnx,
										cnx_opt,
										(mail!=NULL)?mail:"",
										amount+offset_sizeof_data);
	send_dc_line(sck,user_info->str,NULL);
	g_string_free(user_info,TRUE);
}

