/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * sema.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __SEMA_H__
#define __SEMA_H__

#ifndef SEMVMX
/* this value comes from linux/sem.h */
/* but I don't know how to get them from the include without compilation errors */
#define SEMVMX 32767
#endif

/******************************/
/* initialize semaphore array */
/*************************************************************************************/
/* input: keyfile : if not exists, it is created and the semaphore key is put inside */
/*                  if exists but the semaphore key inside is invalid, same as above */
/*                  if exists and contains a valid key, nothing is done              */
/*        spd_limit is the default speed limit (in number of 512bytes slice)         */
/*************************************************************************************/
/* output: 0=ok, !=0=error                                              */
/*         on success, *cur_semid is the semaphore id to use with semop */
/************************************************************************/
int do_sema_init(char *keyfile, int *cur_semid, int spd_limit);

/******************************************************************************************/
/* to avoid forever hanging of download, we must regularly check if a clock master exists */
/******************************************************************************************/
void check_sema_master(int semid);

/************************/
/* get 1 512Bytes slice */
/*******************************************/
/* the function ends when it has the slice */
/*******************************************/
void get_slice(int semid);

/*************************/
/* get nb 512Bytes slice */
/*******************************************/
/* the function ends when it has the slice */
/*******************************************/
void get_slices(int semid,int nb);

#endif
