<?php
// $Horde: imp/templates/prefs/sourceselect.inc,v 1.3.2.1 2002/01/02 11:41:42 jan Exp $

if ($registry->hasMethod('contacts/sources')) {
    $selected = explode("\t", $prefs->getValue('search_sources'));
    $readable = $registry->call('contacts/sources');
    $writeable = $registry->call('contacts/sources', true);

    if (count($selected) == 1 && empty($selected[0]))
        $selected = array();

    $prefSelect = "";
    foreach ($selected as $source) {
        if (!empty($readable[$source])) {
            $prefSelect .= '<option value="' . $source . '">' . $readable[$source] . "</option>\n";
        }
    }

    $readSelect = "";
    if (isset($readable) && is_array($readable)) {
        foreach (array_diff(array_keys($readable), $selected) as $source) {
            $readSelect .= '<option value="' . $source . '">' . $readable[$source] . "</option>\n";
        }
    }

    $writeSelect = "" . '<option value="">' . _("None") . '</option>' . "\n";
    foreach ($writeable as $source => $title) {
        $sel = $prefs->getValue('add_source') == $source ? ' selected="selected"' : '';
        $writeSelect .= '<option value="' . $source . '"' . "$sel>" . $title . "</option>\n";
    }
    
    $selected_fields = array();
    $search_field_pref = $prefs->getValue('search_fields');
    if (!empty($search_field_pref)) {
        $selected_fields = explode("\n", $prefs->getValue('search_fields'));
        foreach ($selected_fields as $field) {
            $field = trim($field);
            if (!empty($field)) {
                $tmp = explode("\t", $field);
                if (count($tmp) > 1) {
                    $source = array_splice($tmp, 0, 1);
                    $selected_fields[$source[0]] = $tmp;
                }
            }
        }
    }
    
    $search_fields = array();
    foreach ($readable as $source => $null) {
        $search_fields[$source] = $registry->call('contacts/fields', $source);
    }
    
    $js = "var searchFields = new Array();\n";
    $source_count = 0;
    foreach ($search_fields as $source => $fields) {
        $js .= "searchFields[$source_count] = new Array();\n";
        $js .= "searchFields[$source_count][0] = '$source';\n";
        
        $field_count = 1;
        foreach ($fields as $field) {
            if ($field['search']) {
                $marked = isset($selected_fields[$source]) && in_array($field['name'], $selected_fields[$source]) ? 'true' : 'false';
                $js .= "searchFields[$source_count][$field_count] = new Array('" . $field['name'] . "', '" . $field['desc'] . "', $marked);\n";
                $field_count++;
            }
        }
        
        $source_count++;
    }
}
?>

<?php if (!$prefs->isLocked('search_sources') && (!empty($readSelect) || !empty($prefSelect))): ?>
<script language="JavaScript" type="text/javascript">
<!--
function deselectHeaders()
{
    document.prefs.unselected_search_sources[0].selected = false;
    document.prefs.selected_search_sources[0].selected = false;
}

function resetHidden()
{
    var tmp = '';
    for (i = 1; i < document.prefs.selected_search_sources.length; i++) {
        tmp += document.prefs.selected_search_sources[i].value;
        if (i < document.prefs.selected_search_sources.length - 1)
            tmp += "\t";
    }

    document.prefs.search_sources.value = tmp;
}

function addSource()
{
    for (i = 1; i < document.prefs.unselected_search_sources.length; i++) {
        if (document.prefs.unselected_search_sources[i].selected) {
            document.prefs.selected_search_sources[document.prefs.selected_search_sources.length] = new Option(document.prefs.unselected_search_sources[i].text, document.prefs.unselected_search_sources[i].value);
            document.prefs.unselected_search_sources[i] = null;
            i--;
        }
    }

    resetHidden();
}

function removeSource()
{
    for (i = 1; i < document.prefs.selected_search_sources.length; i++) {
        if (document.prefs.selected_search_sources[i].selected) {
            document.prefs.unselected_search_sources[document.prefs.unselected_search_sources.length] = new Option(document.prefs.selected_search_sources[i].text, document.prefs.selected_search_sources[i].value)
            document.prefs.selected_search_sources[i] = null;
            i--;
        }
    }

    resetHidden();
}

function moveSourceUp()
{
    var sel = document.prefs.selected_search_sources.selectedIndex;

    if (sel == -1 || document.prefs.selected_search_sources.length <= 2) return;

    // deselect everything but the first selected item
    document.prefs.selected_search_sources.selectedIndex = sel;

    if (sel == 1) {
        tmp = document.prefs.selected_search_sources[sel];
        document.prefs.selected_search_sources[sel] = null;
        document.prefs.selected_search_sources[document.prefs.selected_search_sources.length] = tmp;
        document.prefs.selected_search_sources.selectedIndex = document.prefs.selected_search_sources.length - 1;
    } else {
        tmp = new Array();

        for (i = 1; i < document.prefs.selected_search_sources.length; i++) {
            tmp[i - 1] = new Option(document.prefs.selected_search_sources[i].text, document.prefs.selected_search_sources[i].value)
        }

        for (i = 0; i < tmp.length; i++) {
            if (i + 1 == sel - 1) {
                document.prefs.selected_search_sources[i + 1] = tmp[i + 1];
            } else if (i + 1 == sel) {
                document.prefs.selected_search_sources[i + 1] = tmp[i - 1];
            } else {
                document.prefs.selected_search_sources[i + 1] = tmp[i];
            }
        }

        document.prefs.selected_search_sources.selectedIndex = sel - 1;
    }

    resetHidden();
}

function moveSourceDown()
{
    var sel = document.prefs.selected_search_sources.selectedIndex;

    if (sel == -1 || document.prefs.selected_search_sources.length <= 2) return;

    // deselect everything but the first selected item
    document.prefs.selected_search_sources.selectedIndex = sel;

    if (sel == document.prefs.selected_search_sources.length - 1) {
        tmp = new Array();

        for (i = 1; i < document.prefs.selected_search_sources.length; i++) {
            tmp[i - 1] = new Option(document.prefs.selected_search_sources[i].text, document.prefs.selected_search_sources[i].value)
        }

        document.prefs.selected_search_sources[1] = tmp[tmp.length - 1];
        for (i = 0; i < tmp.length - 1; i++) {
            document.prefs.selected_search_sources[i + 2] = tmp[i];
        }
        
        document.prefs.selected_search_sources.selectedIndex = 1;
    } else {
        tmp = new Array();

        for (i = 1; i < document.prefs.selected_search_sources.length; i++) {
            tmp[i - 1] = new Option(document.prefs.selected_search_sources[i].text, document.prefs.selected_search_sources[i].value)
        }

        for (i = 0; i < tmp.length; i++) {
            if (i + 1 == sel) {
                document.prefs.selected_search_sources[i + 1] = tmp[i + 1];
            } else if (i + 1 == sel + 1) {
                document.prefs.selected_search_sources[i + 1] = tmp[i - 1];
            } else {
                document.prefs.selected_search_sources[i + 1] = tmp[i];
            }
        }
        
        document.prefs.selected_search_sources.selectedIndex = sel + 1;
    }

    resetHidden();
}

<?= $js ?>

function updateSearchFields()
{
    var f = document.prefs;
    var fieldString = '';
    
    while (f.search_fields.length > 0) {
        f.search_fields.options[f.search_fields.length-1] = null;
    }
    
    if (f.selected_search_sources.selectedIndex < 1) {
        return;
    }
    
    for (var i = 0; i < searchFields.length; i++) {
        if (i > 0) {
            fieldString += "\n";
        }
        fieldString += searchFields[i][0];
        for (var j = 1; j < searchFields[i].length; j++) {
            if (searchFields[i][j][2]) {
                fieldString += "\t" + searchFields[i][j][0];
            }
            if (searchFields[i][0] == f.selected_search_sources.options[f.selected_search_sources.selectedIndex].value) {
                f.search_fields.options[f.search_fields.length] = new Option(searchFields[i][j][1], searchFields[i][j][0]);
                if (searchFields[i][j][2]) {
                    f.search_fields.options[f.search_fields.length - 1].selected = true;
                }
            }
        }
    }
    
    f.search_fields_string.value = fieldString;
}

function changeSearchFields()
{
    var f = document.prefs;
    
    for (var i = 0; i < searchFields.length; i++) {
        if (searchFields[i][0] == f.selected_search_sources.options[f.selected_search_sources.selectedIndex].value) {
            for (var j = 1; j < searchFields[i].length; j++) {
                searchFields[i][j][2] = f.search_fields.options[j - 1].selected;
            }
            updateSearchFields();
            return;
        }
    }
}
// -->
</script>

<?= _("Choose the order of addressbooks to search when expanding addresses.") ?><br />
<input type="hidden" name="search_sources" value="<?= implode("\t", $selected) ?>" />
<table>
    <tr>
        <td>
            <select name="unselected_search_sources" multiple="multiple" size="5" width="20" onchange="deselectHeaders()">
                <option value=""><?= _("Available Addressbooks:") ?></option>
                <?= $readSelect ?>
            </select>
        </td>
        <td>
            <a href="" onclick="addSource(); return false;"><?= Horde::img('rhand.gif', 'alt="' . _("add source") . '"') ?></a>
            <br />
            <a href="" onclick="removeSource(); return false;"><?= Horde::img('lhand.gif', 'alt="' . _("remove source") . '"') ?></a>
        </td>
        <td>
            <select name="selected_search_sources" multiple="multiple" size="5" width="20" onchange="deselectHeaders();updateSearchFields();">
                <option value=""><?= _("Selected Addressbooks:") ?></option>
                <?= $prefSelect ?>
            </select>
        </td>
        <td>
            <a href="" onclick="moveSourceUp(); return false;"><?= Horde::img('up.gif', 'alt="' . _("move up") . '"') ?></a>
            <br />
            <a href="" onclick="moveSourceDown(); return false;"><?= Horde::img('down.gif', 'alt="' . _("move down") . '"') ?></a>
        </td>
    </tr>
</table>

<?= _("Click on one of your selected addressbooks and then select all fields to search.") ?><br />
<?= _("Use Ctrl/Option+Click to select multiple fields") ?><br />
<input type="hidden" name="search_fields_string" />
<table>
    <tr>
        <td>
            <select name="search_fields" multiple="multiple" size="5" width="20" onchange="changeSearchFields()">
                <option><?= str_repeat('&nbsp;', 50) ?></option>
            </select>
        </td>
    </tr>
</table>
<?php endif; ?>

<br />

<?php if (!$prefs->isLocked('search_sources') && !empty($writeSelect)): ?>
<?= _("Choose the addressbook to use when adding addresses.") ?><br />
<select name="add_source"><?= $writeSelect ?></select>
<?php endif; ?>
