<?php
/*
 * $Horde: imp/redirect.php,v 1.23.2.3 2002/01/02 17:05:32 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';

$action = Horde::getFormData('action', '');
if ($action === 'compose') {
    $actionID = LOGIN_COMPOSE;
} else {
    $actionID = Horde::getFormData('actionID', IMP_LOGIN);
}

/* If we already have a session... */
if (isset($HTTP_SESSION_VARS['imp']) && is_array($HTTP_SESSION_VARS['imp'])) {
    /* Make sure that if a username was specified, it is the current username */
    if ((!isset($HTTP_POST_VARS['imapuser']) || $HTTP_POST_VARS['imapuser'] == $HTTP_SESSION_VARS['imp']['user']) &&
        (!isset($HTTP_POST_VARS['pass']) || $HTTP_POST_VARS['pass'] == Secret::read(Secret::getKey('imp'), $HTTP_SESSION_VARS['imp']['pass']))) {
        
        if ($actionID == IMP_LOGIN) {
            $actionID = NO_ACTION;
        }
        header('Location: ' . Horde::applicationUrl('mailbox.php?actionID=' . $actionID, true));
        exit;
    } else {
        /* Disable the old session. */
        $imp = false;
        session_unregister('imp');
        header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', 'failed'), true));
        exit;
    }
}

/* Create a new session if we're given the proper parameters. */
if (isset($HTTP_POST_VARS['imapuser']) && isset($HTTP_POST_VARS['pass'])) {
    if (!isset($HTTP_POST_VARS['mailbox'])) {
        $HTTP_POST_VARS['mailbox'] = 'INBOX';
    }
    if (($reason = IMP::createSession()) === true) {
        $imp['_login'] = true;
        $entry = sprintf('Login success for %s [%s] to {%s:%s}',
                         $imp['user'], $HTTP_SERVER_VARS['REMOTE_ADDR'], $imp['server'], $imp['port']);
        Horde::logMessage($entry, __FILE__, __LINE__, LOG_NOTICE);

        if (Horde::getFormData('redirect_url')) {
            header('Location: ' . Horde::getFormData('redirect_url'));
            exit;
        }

        header('Location: ' . Horde::applicationUrl('mailbox.php?actionID=' . $actionID, true));
        exit;
    } else {
        header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', $reason), true));
        exit;
    }
}

/* No session, and no login attempt. Just go to the login page. */
$uri = 'login.php';
if (!empty($HTTP_SERVER_VARS['QUERY_STRING'])) {
    $uri .= '?' . $HTTP_SERVER_VARS['QUERY_STRING'];
}
header('Location: ' . Horde::applicationUrl($uri, true));
exit;

?>
