<?php
/*
 * $Horde: imp/filters.php,v 2.30.2.2 2002/01/02 17:05:24 jan Exp $
 *
 * Copyright 2000-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 2000-2002 Max Kalika <max@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';

/* redirect back to the options screen if folder or filter use is not allowed */
if (!$conf['user']['allow_folders'] || $prefs->isLocked('filters')) {
    header('Location: ' . Horde::applicationUrl('prefs.php', true));
    exit;
}

if (($reason = IMP::authenticate(OP_HALFOPEN, true)) !== true) {
    header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', $reason), true));
    exit;
}

$preamble = IMP::preambleString();
$errormsg = '';
$actionID = Horde::getFormData('actionID', NO_ACTION);

/* Run through the action handlers */
if (isset($actionID)) {
    switch ($actionID) {
        
    case NO_ACTION:
        break;
        
    case FILTER_CREATE:
        if (isset($HTTP_POST_VARS['fields']) && !is_array($HTTP_POST_VARS['fields'])) {
            $HTTP_POST_VARS['fields'] = array($HTTP_POST_VARS['fields']);
        }

        if (isset($HTTP_POST_VARS['fields']) && isset($HTTP_POST_VARS['text']) && isset($HTTP_POST_VARS['action']) && !preg_match('/^\s*$/', $HTTP_POST_VARS['text'])) {
            $filters = @unserialize($prefs->getValue('filters'));
            if ($HTTP_POST_VARS['action'] == 'delete') {
                $filters[] = array('fields' => $HTTP_POST_VARS['fields'], 'text' => chop(trim($HTTP_POST_VARS['text'])), 'action' => 'delete');
            } elseif ($HTTP_POST_VARS['action'] == 'move' && isset($HTTP_POST_VARS['folder']) && $HTTP_POST_VARS['folder']) {
                $filters[] = array('fields' => $HTTP_POST_VARS['fields'], 'text' => chop(trim($HTTP_POST_VARS['text'])), 'action' => 'move', 'folder' => $HTTP_POST_VARS['folder']);
            } else {
                Horde::raiseMessage(_("no folder selected"), HORDE_ERROR);
                $errorRaised = true;
            }

            $prefs->setValue('filters', serialize($filters));
            $prefs->store();
        }
        else {
            Horde::raiseMessage(_("please fill in the text and choose a field and an action"), HORDE_ERROR);
            $errorRaised = true;
        }
        break;

    case FILTER_MODIFY:
        if (isset($HTTP_POST_VARS['fields']) && !is_array($HTTP_POST_VARS['fields'])) {
            $HTTP_POST_VARS['fields'] = array($HTTP_POST_VARS['fields']);
        }

        if (isset($HTTP_POST_VARS['number'])) {
            if (isset($HTTP_POST_VARS['text']) && !preg_match('/^\s*$/', $HTTP_POST_VARS['text'])) {
                $filters = @unserialize($prefs->getValue('filters'));
                if ($HTTP_POST_VARS['action'] == 'delete') {
                    $filters[$HTTP_POST_VARS['number']] = array('fields' => $HTTP_POST_VARS['fields'], 'text' => chop(trim($HTTP_POST_VARS['text'])), 'action' => 'delete');
                } elseif ($HTTP_POST_VARS['action'] == 'move' && isset($HTTP_POST_VARS['folder']) && $HTTP_POST_VARS['folder']) {
                    $filters[$HTTP_POST_VARS['number']] = array('fields' => $HTTP_POST_VARS['fields'], 'text' => chop(trim($HTTP_POST_VARS['text'])), 'action' => 'move', 'folder' => $HTTP_POST_VARS['folder']);
                } else {
                    Horde::raiseMessage(_("no folder selected"), HORDE_ERROR);
                    $errorRaised = true;
                }

                $prefs->setValue('filters', serialize($filters));
                $prefs->store();
            } else {
                Horde::raiseMessage(_("no text specified"), HORDE_ERROR);
                $errorRaised = true;
            }
        } else {
            Horde::raiseMessage(_("no rule selected"), HORDE_ERROR);
        }
        break;

    case FILTER_DELETE:
        if (isset($HTTP_POST_VARS['number'])) {
            $filters = @unserialize($prefs->getValue('filters'));
            array_splice($filters, $HTTP_POST_VARS['number'], 1);
            $prefs->setValue('filters', serialize($filters));
            $prefs->store();
        } else {
            Horde::raiseMessage(_("no rule selected"), HORDE_ERROR);
        }
        break;

    case FILTER_DOWN:
        if (isset($HTTP_POST_VARS['number'])) {
            $filters = @unserialize($prefs->getValue('filters'));
            if ($HTTP_POST_VARS['number'] < count($filters) - 1) {
                $tmpFilter = array_splice($filters, $HTTP_POST_VARS['number'], 1);
                array_splice($filters, $HTTP_POST_VARS['number'] + 1, 0, $tmpFilter);
                $prefs->setValue('filters', serialize($filters));
                $prefs->store();
            } else {
                Horde::raiseMessage(_("cannot move past the end"), HORDE_WARNING);
                $errorRaised = true;
            }
        } else {
            Horde::raiseMessage(_("no rule selected"), HORDE_ERROR);
        }
        break;

    case FILTER_UP:
        if (isset($HTTP_POST_VARS['number'])) {
            $filters = @unserialize($prefs->getValue('filters'));
            if ($HTTP_POST_VARS['number']) {
                $tmpFilter = array_splice($filters, $HTTP_POST_VARS['number'], 1);
                array_splice($filters, $HTTP_POST_VARS['number'] - 1, 0, $tmpFilter);
                $prefs->setValue('filters', serialize($filters));
                $prefs->store();
            } else {
                Horde::raiseMessage(_("cannot move past the beginning"), HORDE_WARNING);
                $errorRaised = true;
            }
        } else {
            Horde::raiseMessage(_("no rule selected"), HORDE_ERROR);
        }
        break;

    }
}

$title = _("Mail Filters");

require $registry->getTemplatePath() . '/common-header.inc';
require IMP_BASE . '/menu.php';
require IMP_BASE . '/status.php';

$filters = @unserialize($prefs->getValue('filters'));

$filterLabels = array('to'      => _("To:"),
                      'cc'      => _("Cc:"),
                      'from'    => _("From:"),
                      'subject' => _("Subject:"),
                      'body'    => _("Body"));

$fieldsDisplay = array();
for ($i = 0; $i < count($filters); $i++) {
    $fieldsDisplay[$i] = '';
    for ($j = 0; $j < count($filters[$i]['fields']); $j++) {
        $fieldsDisplay[$i] .= ' <b>' . $filterLabels[$filters[$i]['fields'][$j]] . '</b> ';
        if ($j < count($filters[$i]['fields']) - 1) {
            $fieldsDisplay[$i] .= _("or");
        }
    }
}

$apply_js = 'window.location = \'' . Horde::url('mailbox.php?actionID=' . FILTER, true) . '\';';
if (count(IMP::flist(array('INBOX')))) {
    $options = IMP::flistSelect(_("select folder"), true, array('INBOX'));
}

$fieldsList['to'] = 0;
$fieldsList['cc'] = 1;
$fieldsList['from'] = 2;
$fieldsList['subject'] = 3;
$fieldsList['body'] = 4;

$actionsList['delete'] = 0;
$actionsList['move'] = 1;

require $registry->getTemplatePath() . '/filters/javascript.inc';
require $registry->getTemplatePath() . '/filters/list.inc';
require $registry->getTemplatePath() . '/filters/manage.inc';

$registry->shutdown();

require $registry->getTemplatePath() . '/common-footer.inc';

$prefs->store();

?>
