<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2073 $
 * $Id: ViewScheduleDay.php 2073 2008-08-22 18:41:21Z ipso $
 * $Date: 2008-08-22 11:41:21 -0700 (Fri, 22 Aug 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');
require_once(Environment::getBasePath() .'classes/misc/arr_multisort.class.php');

//Debug::setVerbosity(11);

if ( !$permission->Check('schedule','enabled')
		OR !( $permission->Check('schedule','view') OR $permission->Check('schedule','view_own') OR $permission->Check('schedule','view_child')) ) {
	$permission->Redirect( FALSE ); //Redirect
}

$smarty->assign('title', TTi18n::gettext($title = 'My Schedule')); // See index.php
//BreadCrumb::setCrumb($title);

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'page',
												'sort_column',
												'sort_order',
												'filter_data',
												'serialize_filter_data',
												//'filter_start_date',
												//'filter_user_id'
												) ) );

URLBuilder::setURL($_SERVER['SCRIPT_NAME'],
											array(
													'sort_column' => $sort_column,
													'sort_order' => $sort_order,
													'page' => $page
												) );

//Data is coming in serialized from Schedule Month.
$serialize_filter_data = unserialize( base64_decode( urldecode( $serialize_filter_data ) ) );

if ( isset( $filter_data['start_date'] ) AND $filter_data['start_date'] != '' ) {
	$filter_data['start_date'] = TTDate::parseDateTime($filter_data['start_date']);
} else {
	$filter_data['start_date'] = TTDate::getBeginWeekEpoch( time() );
}
$filter_data = array_merge( $serialize_filter_data, $filter_data);

//Get Permission Hierarchy Children first, as this can be used for viewing, or editing.
$hlf = new HierarchyListFactory();
$permission_children_ids = $hlf->getHierarchyChildrenByCompanyIdAndUserIdAndObjectTypeID( $current_company->getId(), $current_user->getId() );
if ( $permission->Check('schedule','view') == FALSE ) {
	if ( $permission->Check('schedule','view_child') == FALSE ) {
		$permission_children_ids = array();
	}
	if ( $permission->Check('schedule','view_own') ) {
		$permission_children_ids[] = $current_user->getId();
	}

	$filter_data['permission_children_ids'] = $permission_children_ids;
}

$action = Misc::findSubmitButton();
switch ($action) {
	default:
		$user_ids = array();

		if ( $filter_data['start_date'] != '' ) {
			$start_date = $filter_data['start_date'] = TTDate::getBeginDayEpoch( $filter_data['start_date'] );
			$end_date = $start_date;
		}

		Debug::text(' Start Date: '. TTDate::getDate('DATE+TIME', $start_date) .' End Date: '. TTDate::getDate('DATE+TIME', $end_date) , __FILE__, __LINE__, __METHOD__,10);

		$ulf = new UserListFactory();
		$ulf->getSearchByCompanyIdAndArrayCriteria( $current_company->getId(), $filter_data );
		if ( $ulf->getRecordCount() > 0 ) {
			foreach( $ulf as $u_obj ) {
				$user_id = $user_ids[] = $u_obj->getId();

				$sf = new ScheduleFactory();
				$raw_schedule_shifts = $sf->getScheduleArray( $user_id, $start_date, $end_date);
				//var_dump($raw_schedule_shifts);
				if ( is_array($raw_schedule_shifts) ) {
					foreach( $raw_schedule_shifts as $day_epoch => $day_schedule_shifts ) {
						foreach ( $day_schedule_shifts as $day_schedule_shift ) {
							$day_schedule_shift['is_owner'] = $permission->isOwner( $u_obj->getCreatedBy(), $u_obj->getId() );
							$day_schedule_shift['is_child'] = $permission->isChild( $u_obj->getId(), $permission_children_ids );

							$tmp_schedule_shifts[$day_epoch][$day_schedule_shift['branch']][$day_schedule_shift['department']][] = $day_schedule_shift;
							//$schedule_shifts[$day_epoch][] = $day_schedule_shift;
							if ( $day_schedule_shift['status_id'] == 10 ) { //Working
								if ( isset($schedule_shift_totals[$day_epoch]['total_time']) ) {
									$schedule_shift_totals[$day_epoch]['total_time'] += $day_schedule_shift['total_time'];
								} else {
									$schedule_shift_totals[$day_epoch]['total_time'] = $day_schedule_shift['total_time'];
								}
								$schedule_shift_totals[$day_epoch]['users'][] = $day_schedule_shift['user_id'];

							} elseif ( $day_schedule_shift['status_id'] == 20 ) { //Absent
								if ( isset($schedule_shift_totals[$day_epoch]['absent_total_time']) ) {
									$schedule_shift_totals[$day_epoch]['absent_total_time'] += $day_schedule_shift['total_time'];
								} else {
									$schedule_shift_totals[$day_epoch]['absent_total_time'] = $day_schedule_shift['total_time'];
								}
								$schedule_shift_totals[$day_epoch]['absent_users'][] = $day_schedule_shift['user_id'];
							}
						}
					}
				}
			}

			//Total up employees/time per day.
			if ( isset($schedule_shift_totals) ) {
				foreach( $schedule_shift_totals as $day_epoch => $total_arr) {
					if ( !isset($total_arr['users']) ) {
						$total_arr['users'] = array();
					}
					$schedule_shift_totals[$day_epoch]['total_users'] = count(array_unique($total_arr['users']));
				}
			}
			//print_r($schedule_shift_totals);
			//var_dump($tmp_schedule_shifts);

			if ( isset($tmp_schedule_shifts) ) {
				//Sort Branches/Departments first
				foreach ( $tmp_schedule_shifts as $day_epoch => $day_tmp_schedule_shift ) {
					ksort($day_tmp_schedule_shift);
					$tmp_schedule_shifts[$day_epoch] = $day_tmp_schedule_shift;

					foreach ( $day_tmp_schedule_shift as $branch => $department_schedule_shifts ) {
						ksort($tmp_schedule_shifts[$day_epoch][$branch]);
					}
				}

				//Sort each department by start time.
				foreach ( $tmp_schedule_shifts as $day_epoch => $day_tmp_schedule_shift ) {
					foreach ( $day_tmp_schedule_shift as $branch => $department_schedule_shifts ) {
						foreach ( $department_schedule_shifts as $department => $department_schedule_shift ) {
							//var_dump($department_schedule_shift);
							$sort = new arr_multisort();
							$sort->setArray($department_schedule_shift);
							$sort->addColumn('start_time', 1);
							$department_schedule_shift = $sort->Sort();
							unset($sort);

							$schedule_shifts[$day_epoch][$branch][$department] = $department_schedule_shift;
						}
					}
				}
			}
			//print_r($schedule_shifts);
		}

		if ( isset($start_date) AND isset($end_date) ) {
			$calendar_array = TTDate::getCalendarArray($start_date, $end_date, $current_user_prefs->getStartWeekDay(), FALSE);
			//var_dump($calendar_array);
		}
		$smarty->assign_by_ref('calendar_array', $calendar_array);

		$hlf = new HolidayListFactory();
		$holiday_array = $hlf->getArrayByPolicyGroupUserId( $user_ids, $start_date, $end_date );
		//var_dump($holiday_array);

		$smarty->assign_by_ref('holidays', $holiday_array);

		$smarty->assign_by_ref('schedule_shifts', $schedule_shifts);
		$smarty->assign_by_ref('schedule_shift_totals', $schedule_shift_totals);

		$smarty->assign_by_ref('action', $action );

		break;
}
$smarty->display('schedule/ViewScheduleDay.tpl');
?>