<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditCurrency.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('currency','enabled')
		OR !( $permission->Check('currency','edit') OR $permission->Check('currency','edit_own') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Currency')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'data',
												'data_saved',
												) ) );

$cf = new CurrencyFactory();
$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		//Debug::setVerbosity(11);
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$cf->setId( $data['id'] );
		$cf->setCompany( $current_company->getId() );
		$cf->setStatus( $data['status'] );
		$cf->setName( $data['name'] );
		$cf->setISOCode( $data['iso_code'] );
		$cf->setConversionRate( $data['conversion_rate'] );
		if ( isset($data['auto_update']) AND $data['auto_update'] == 1) {
			$cf->setAutoUpdate( TRUE );
		} else {
			$cf->setAutoUpdate( FALSE );
		}
		
		if ( isset($data['is_base']) AND $data['is_base'] == 1) {
			$cf->setBase( TRUE );
		} else {
			$cf->setBase( FALSE );
		}

		if ( isset($data['is_default']) AND $data['is_default'] == 1) {
			$cf->setDefault( TRUE );
		} else {
			$cf->setDefault( FALSE );
		}

		$cf->setRateModifyPercent( $data['rate_modify_percent'] );
		
		if ( $cf->isValid() ) {
			$cf->Save();

			//Redirect::Page( URLBuilder::getURL( array('id' => $data['id'], 'data_saved' => TRUE), 'EditCurrency.php') );
			Redirect::Page( URLBuilder::getURL( NULL, 'CurrencyList.php') );

			break;
		}
		
	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$clf = new CurrencyListFactory();

			$clf->getByIdAndCompanyId($id, $current_company->getId() );

			foreach ($clf as $c_obj) {
				//Debug::Arr($branch,'branch', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
									'id' => $c_obj->getId(),
									'status' => $c_obj->getStatus(),
									'name' => $c_obj->getName(),
									'iso_code' => $c_obj->getISOCode(),
									'conversion_rate' => $c_obj->getConversionRate(),
									'auto_update' => $c_obj->getAutoUpdate(),
									'rate_modify_percent' =>  $c_obj->getRateModifyPercent(),
									'actual_rate' => (float)$c_obj->getActualRate(),
									'actual_rate_updated_date' => $c_obj->getActualRateUpdatedDate(),
									'is_base' => $c_obj->getBase(),
									'is_default' => $c_obj->getDefault(),
									'created_date' => $c_obj->getCreatedDate(),
									'created_by' => $c_obj->getCreatedBy(),
									'updated_date' => $c_obj->getUpdatedDate(),
									'updated_by' => $c_obj->getUpdatedBy(),
									'deleted_date' => $c_obj->getDeletedDate(),
									'deleted_by' => $c_obj->getDeletedBy()
								);
			}
		} elseif ( $action != 'submit' ) {
			$data = array(
						'conversion_rate' => '1.0000000000',
						'rate_modify_percent' => '1.0000000000',
						);
		}

		//Select box options;
		$data['status_options'] = $cf->getOptions('status');
		$data['iso_code_options'] = $cf->getISOCodesArray();

		$smarty->assign_by_ref('data', $data);
		$smarty->assign_by_ref('data_saved', $data_saved);

		break;
}

$smarty->assign_by_ref('cf', $cf);

$smarty->display('currency/EditCurrency.tpl');
?>