<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1561 $
 * $Id: PayrollDeduction.class.php 1561 2007-12-24 01:14:54Z ipso $
 * $Date: 2007-12-23 17:14:54 -0800 (Sun, 23 Dec 2007) $
 */
class PayrollDeduction {
	var $obj = NULL;
	var $data = NULL;

	function __construct( $country, $province, $district = NULL) {
		$this->setCountry( $country );
		$this->setProvince( $province );
		$this->setDistrict( $district );

		$base_file_name = Environment::getBasePath().'/classes/payroll_deduction/PayrollDeduction_Base.class.php';
		$province_file_name = Environment::getBasePath().'/classes/payroll_deduction/'.$this->getCountry().'/'.$this->getProvince().'.class.php';
		$district_file_name = Environment::getBasePath().'/classes/payroll_deduction/'.$this->getCountry().'/'.$this->getProvince().'_'.$this->getDistrict().'.class.php';
		$country_file_name = Environment::getBasePath().'/classes/payroll_deduction/'.$this->getCountry().'.class.php';
		$data_file_name = Environment::getBasePath().'/classes/payroll_deduction/'.$this->getCountry().'/Data.class.php';

		if ( $this->getDistrict() != '' AND $this->getDistrict() != '00' ) {
			$class_name = 'PayrollDeduction_'.$this->getCountry().'_'.$this->getProvince().'_'.$this->getDistrict();
		} elseif ( $this->getProvince() != '' ) {
			$class_name = 'PayrollDeduction_'.$this->getCountry().'_'.$this->getProvince();
		} else {
			$class_name = 'PayrollDeduction_'.$this->getCountry();
		}

		Debug::text('Country: '. $country_file_name .' Province: '. $province_file_name .' District: '. $district_file_name .' Class: '. $class_name, __FILE__, __LINE__, __METHOD__, 10);

		if ( ( file_exists($country_file_name) OR ( $this->getProvince() != '' AND file_exists($province_file_name) ) OR ( $this->getDistrict() != '' AND file_exists($district_file_name) ) ) AND file_exists($data_file_name) ) {
			Debug::text('Country File Exists: '. $country_file_name .' Province File Name: '. $province_file_name .' Data File: '. $data_file_name, __FILE__, __LINE__, __METHOD__, 10);

			include_once( $base_file_name );
			include_once( $data_file_name );

			if ( file_exists($country_file_name) ) {
				include_once( $country_file_name );
			}
			if ( $this->getProvince() != '' AND file_exists($province_file_name) ) {
				include_once( $province_file_name );
			}
			if ( $this->getDistrict() != '' AND file_exists($district_file_name) ) {
				include_once( $district_file_name );
			}

			$this->obj = new $class_name;
			$this->obj->setCountry( $this->getCountry() );
			$this->obj->setProvince( $this->getProvince() );
			$this->obj->setDistrict( $this->getDistrict() );

			return TRUE;
		} else {
			Debug::text('File DOES NOT Exists Country File Name: '. $country_file_name .' Province File: '. $province_file_name, __FILE__, __LINE__, __METHOD__, 10);
		}

		return FALSE;
	}

	private function getObject() {
		if ( is_object($this->obj) ) {
			return $this->obj;
		}

		return FALSE;
	}

	private function setCountry($country) {
		$this->data['country'] = strtoupper(trim($country));

		return TRUE;
	}
	function getCountry() {
		if ( isset($this->data['country']) ) {
			return $this->data['country'];
		}

		return FALSE;
	}

	private function setProvince($province) {
		$this->data['province'] = strtoupper(trim($province));

		return TRUE;
	}
	function getProvince() {
		if ( isset($this->data['province']) ) {
			return $this->data['province'];
		}

		return FALSE;
	}

	private function setDistrict($district) {
		$this->data['district'] = strtoupper(trim($district));

		return TRUE;
	}
	function getDistrict() {
		if ( isset($this->data['district']) ) {
			return $this->data['district'];
		}

		return FALSE;
	}

	function __call($function_name, $args = array() ) {
		if ( $this->getObject() !== FALSE ) {
			//Debug::text('Calling Sub-Class Function: '. $function_name, __FILE__, __LINE__, __METHOD__, 10);
			if ( is_callable( array($this->getObject(), $function_name) ) ) {
				$return = call_user_func_array(array($this->getObject(), $function_name), $args);

				return $return;
			}
		}

		Debug::text('Sub-Class Function Call FAILED!:'. $function_name, __FILE__, __LINE__, __METHOD__, 10);

		return FALSE;
	}
}
?>
