<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1558 $
 * $Id: ON.class.php 1558 2007-12-19 00:54:18Z ipso $
 * $Date: 2007-12-18 16:54:18 -0800 (Tue, 18 Dec 2007) $
 */
class PayrollDeduction_CA_ON extends PayrollDeduction_CA {
	function getProvincialTaxReduction() {

		$A = $this->getAnnualTaxableIncome();
		$T4 = $this->getProvincialBasicTax();
		$V1 = $this->getProvincialSurtax();
		$Y = 0;
		$S = 0;

		Debug::text('ON Specific - Province: '. $this->getProvince(), __FILE__, __LINE__, __METHOD__,10);

		Debug::text('Calculating S for Ontario...', __FILE__, __LINE__, __METHOD__,10);
		if ( $this->getDate() >= strtotime('01-Jan-2008') ) {
			$tmp_Sa = bcadd($T4, $V1);
			$tmp_Sb = bcsub( bcmul( 2, bcadd( 201, $Y ) ), bcadd( $T4, $V1 ) );

			if ( $tmp_Sa < $tmp_Sb ) {
				$S = $tmp_Sa;
			} else {
				$S = $tmp_Sb;
			}
		} elseif ( $this->getDate() >= strtotime('01-Jan-2007') ) {
			$tmp_Sa = bcadd($T4, $V1);
			$tmp_Sb = bcsub( bcmul( 2, bcadd( 198, $Y ) ), bcadd( $T4, $V1 ) );

			if ( $tmp_Sa < $tmp_Sb ) {
				$S = $tmp_Sa;
			} else {
				$S = $tmp_Sb;
			}
		} elseif ( $this->getDate() >= strtotime('01-Jan-2006') ) {
			//$tmp_Sa = $T4 + $V1;
			$tmp_Sa = bcadd($T4, $V1);
			//$tmp_Sb = ( 2 * ( 194 + $Y ) ) - ( $T4 + $V1 );
			$tmp_Sb = bcsub( bcmul( 2, bcadd( 194, $Y ) ), bcadd( $T4, $V1 ) );

			if ( $tmp_Sa < $tmp_Sb ) {
				$S = $tmp_Sa;
			} else {
				$S = $tmp_Sb;
			}
		}

		Debug::text('aS: '. $S, __FILE__, __LINE__, __METHOD__,10);

		if ( $S < 0 ) {
			$S = 0;
		}

		Debug::text('bS: '. $S, __FILE__, __LINE__, __METHOD__,10);

		return $S;
	}

	function getProvincialSurtax() {
		/*
			V1 =
			For Ontario
				Where T4 <= 4016
				V1 = 0

				Where T4 > 4016 <= 5065
				V1 = 0.20 * ( T4 - 4016 )

				Where T4 > 5065
				V1 = 0.20 * (T4 - 4016) + 0.36 * (T4 - 5065)

		*/

		$T4 = $this->getProvincialBasicTax();
		$V1 = 0;

		if ( $this->getDate() >= strtotime('01-Jan-2008') ) {
			if ( $T4 < 4162 ) {
				$V1 = 0;
			} elseif ( $T4 > 4162 AND $T4 <= 5249 ) {
				$V1 = bcmul( 0.20, bcsub( $T4, 4162 ) );
			} elseif ( $T4 > 5249 ) {
				$V1 = bcadd( bcmul(0.20, bcsub( $T4, 4162 ) ), bcmul( 0.36, bcsub( $T4, 5249 ) ) );
			}
		} elseif ( $this->getDate() >= strtotime('01-Jan-2007') ) {
			if ( $T4 < 4100 ) {
				$V1 = 0;
			} elseif ( $T4 > 4100 AND $T4 <= 5172 ) {
				//$V1 = 0.20 * ( $T4 - 4100 );
				$V1 = bcmul( 0.20, bcsub( $T4, 4100 ) );
			} elseif ( $T4 > 5172 ) {
				//$V1 = 0.20 * ( $T4 - 4100 ) + 0.36 * ( $T4 - 5065 );
				$V1 = bcadd( bcmul(0.20, bcsub( $T4, 4100 ) ), bcmul( 0.36, bcsub( $T4, 5172 ) ) );
			}
		} elseif ( $this->getDate() >= strtotime('01-Jan-2006') ) {
			if ( $T4 < 4016 ) {
				$V1 = 0;
			} elseif ( $T4 > 4016 AND $T4 <= 5065 ) {
				//$V1 = 0.20 * ( $T4 - 4016 );
				$V1 = bcmul( 0.20, bcsub( $T4, 4016 ) );
			} elseif ( $T4 > 5065 ) {
				//$V1 = 0.20 * ( $T4 - 4016 ) + 0.36 * ( $T4 - 5065 );
				$V1 = bcadd( bcmul(0.20, bcsub( $T4, 4016 ) ), bcmul( 0.36, bcsub( $T4, 5065 ) ) );
			}
		}

		Debug::text('V1: '. $V1, __FILE__, __LINE__, __METHOD__,10);

		return $V1;
	}

	function getAdditionalProvincialSurtax() {
		/*
			V2 =

			Where A < 20,000
			V2 = 0

			Where A >

		*/

		$A = $this->getAnnualTaxableIncome();
		$V2 = 0;

		if ( $this->getDate() >= strtotime('01-Jan-2006') ) {
			if ( $A < 20000 ) {
				$V2 = 0;
			} elseif ( $A > 20000 AND $A <= 36000 ) {
				//$tmp_V2 = 0.06 * ( $A - 20000 );
				$tmp_V2 = bcmul(0.06, bcsub($A - 20000) );

				if ( $tmp_V2 > 300 ) {
					$V2 = 300;
				} else {
					$V2 = $tmp_V2;
				}
			} elseif ( $A > 36000 AND $A <= 48000 ) {
				//$tmp_V2 = 300 + ( 0.06 * ( $A - 36000 ) );
				$tmp_V2 = bcadd(300, bcmul( 0.06, bcsub( $A, 36000) ) );

				if ( $tmp_V2 > 450 ) {
					$V2 = 450;
				} else {
					$V2 = $tmp_V2;
				}
			} elseif ( $A > 48000 AND $A <= 72000 ) {
				//$tmp_V2 = 450 + ( 0.25 * ( $A - 48000 ) );
				$tmp_V2 = bcadd(450, bcmul( 0.25, bcsub( $A, 48000) ) );

				if ( $tmp_V2 > 600 ) {
					$V2 = 600;
				} else {
					$V2 = $tmp_V2;
				}
			} elseif ( $A > 72000 AND $A <= 200000 ) {
				//$tmp_V2 = 600 + ( 0.25 * ( $A - 72000 ) );
				$tmp_V2 = bcadd(600, bcmul( 0.25, bcsub( $A, 72000) ) );

				if ( $tmp_V2 > 750 ) {
					$V2 = 750;
				} else {
					$V2 = $tmp_V2;
				}
			} elseif ( $A > 200000 ) {
				//$tmp_V2 = 750 + ( 0.25 * ( $A - 200000 ) );
				$tmp_V2 = bcadd(750, bcmul( 0.25, bcsub( $A, 200000) ) );

				if ( $tmp_V2 > 900 ) {
					$V2 = 900;
				} else {
					$V2 = $tmp_V2;
				}
			}
		}

		Debug::text('V2: '. $V2, __FILE__, __LINE__, __METHOD__,10);

		return $V2;
	}
}
?>
