<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1442 $
 * $Id: RequestFactory.class.php 1442 2007-11-19 18:38:32Z ipso $
 * $Date: 2007-11-19 10:38:32 -0800 (Mon, 19 Nov 2007) $
 */
class RequestFactory extends Factory {
	protected $table = 'request';
	protected $pk_sequence_name = 'request_id_seq'; //PK Sequence name

	var $user_date_obj = NULL;


	function _getFactoryOptions( $name ) {

		$retval = NULL;
		switch( $name ) {
			case 'type':
				$retval = array(
										10 => TTi18n::gettext('Missed Punch'),
										20 => TTi18n::gettext('Time Adjustment'),
										30 => TTi18n::gettext('Absence (incl. Vacation)'),
										40 => TTi18n::gettext('Schedule Adjustment'),
										100 => TTi18n::gettext('Other'),
									);
				break;
			case 'status':
				$retval = array(
										10 => TTi18n::gettext('INCOMPLETE'),
										20 => TTi18n::gettext('OPEN'),
										30 => TTi18n::gettext('PENDING AUTHORIZATION'),
										40 => TTi18n::gettext('AUTHORIZATION OPEN'),
										50 => TTi18n::gettext('ACTIVE'),
										55 => TTi18n::gettext('AUTHORIZATION DECLINED'),
										60 => TTi18n::gettext('DISABLED')
									);
				break;

		}

		return $retval;
	}


	function getUserDateObject() {
		if ( is_object($this->user_date_obj) ) {
			return $this->user_date_obj;
		} else {
			$udlf = new UserDateListFactory();
			$this->user_date_obj = $udlf->getById( $this->getUserDateID() )->getCurrent();

			return $this->user_date_obj;
		}
	}

	//Used for authorizationFactory
	function getUserObject() {
		return $this->getUserDateObject()->getUserObject();
	}

	//Used for authorizationFactory
	function getUser() {
		return $this->getUserDateObject()->getUser();
	}

	function setUserDate($user_id, $date) {
		$user_date_id = UserDateFactory::findOrInsertUserDate( $user_id, $date);
		Debug::text(' User Date ID: '. $user_date_id, __FILE__, __LINE__, __METHOD__,10);
		if ( $user_date_id != '' ) {
			$this->setUserDateID( $user_date_id );
			return TRUE;
		}
		Debug::text(' No User Date ID found', __FILE__, __LINE__, __METHOD__,10);

		return FALSE;
	}

	function getUserDateID() {
		if ( isset($this->data['user_date_id']) ) {
			return $this->data['user_date_id'];
		}

		return FALSE;
	}
	function setUserDateID($id = NULL) {
		$id = trim($id);

		$udlf = new UserDateListFactory();

		if (  $this->Validator->isResultSetWithRows(	'user_date',
														$udlf->getByID($id),
														TTi18n::gettext('Invalid User Date ID')
														) ) {
			$this->data['user_date_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getType() {
		if ( isset($this->data['type_id']) ) {
			return $this->data['type_id'];
		}

		return FALSE;
	}
	function setType($value) {
		$value = trim($value);

		$key = Option::getByValue($value, $this->getOptions('type') );
		if ($key !== FALSE) {
			$value = $key;
		}

		if ( $this->Validator->inArrayKey(	'type',
											$value,
											TTi18n::gettext('Incorrect Type'),
											$this->getOptions('type')) ) {

			$this->data['type_id'] = $value;

			return FALSE;
		}

		return FALSE;
	}

	function getStatus() {
		if ( isset($this->data['status_id']) ) {
			return $this->data['status_id'];
		}

		return FALSE;
	}
	function setStatus($value) {
		$value = trim($value);

		$key = Option::getByValue($value, $this->getOptions('status') );
		if ($key !== FALSE) {
			$value = $key;
		}

		if ( $this->Validator->inArrayKey(	'status',
											$value,
											TTi18n::gettext('Incorrect Status'),
											$this->getOptions('status')) ) {

			$this->data['status_id'] = $value;

			return FALSE;
		}

		return FALSE;
	}

	function getAuthorized() {
		if ( isset($this->data['authorized']) AND $this->data['authorized'] !== NULL) {
			return $this->fromBool( $this->data['authorized'] );
		}

		return NULL;
	}
	function setAuthorized($bool) {
		$this->data['authorized'] = $this->toBool($bool);

		return true;
	}

	function getMessage() {
		if ( isset($this->tmp_data['message']) ) {
			return $this->tmp_data['message'];
		}

		return FALSE;
	}
	function setMessage($text) {
		$text = trim($text);

		if 	(	$this->Validator->isLength(		'message',
												$text,
												TTi18n::gettext('Invalid message length'),
												5,
												1024) ) {

			$this->tmp_data['message'] = htmlentities( $text );

			return TRUE;
		}

		return FALSE;
	}

	function Validate() {
		if (	$this->isNew() == TRUE
				AND $this->Validator->hasError('message') == FALSE
				AND $this->getMessage() == FALSE ) {
			$this->Validator->isTRUE(		'message',
											FALSE,
											TTi18n::gettext('Invalid message length') );
		}

		if ( $this->getUserDateID() == FALSE ) {
			$this->Validator->isTRUE(		'user_date',
											FALSE,
											TTi18n::gettext('Invalid User Date ID') );
		}

		return TRUE;
	}

	function preSave() {
		unset($this->data['date_stamp']);

		return TRUE;
	}

	function postSave() {
		//Save message here after we have the request_id.
		//if ( $this->isNew() == TRUE ) {
		if ( $this->getMessage() !== FALSE ) {
			$mf = new MessageFactory();
			$mf->setObjectType( 50 ); //Request
			$mf->setObject( $this->getID() );
			$mf->setParent( 0 );
			$mf->setPriority();
			$mf->setStatus('UNREAD');
			$mf->setBody( $this->getMessage() );
			if ( $mf->isValid() ) {
				return $mf->Save();
			}
		}

		return TRUE;
	}

	function addLog( $log_action ) {
		return TTLog::addEntry( $this->getId(), $log_action,  TTi18n::getText('Request - Type').': '. $this->getType(), NULL, $this->getTable() );
	}
}
?>
