<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: PayStub.class.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
class PayStub extends PayStubFactory {
	protected $tmp_data = NULL;

	function childConstruct() {
		$this->StartTransaction();

		return TRUE;
	}


	function Done() {
		Debug::Arr($this->tmp_data, 'Pay Stub TMP Data: ' , __FILE__, __LINE__, __METHOD__,10);
		//Call pre-save() first, so calculates the totals.
		$this->setEnableCalcTotal(TRUE);
		$this->preSave();

		if ( $this->Validate() ) {
			$this->CommitTransaction();
			//$this->FailTransaction();
			return TRUE;
		}

		$this->FailTransaction(); //Fails Transaction
		$this->CommitTransaction(); //Rollback occurs here. This is important when looping over many employees that may have a pay stub that fails.

		return FALSE;
	}
}
?>
