/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */


#ifndef __MAIN_H__
#define __MAIN_H__
#include <QApplication>
#include <QMainWindow>
#include <QTextEdit>
#include <QWorkspace>
#include <QTextBrowser>
#include <QListWidget>
#include "mainwindow.h"
#include "octave_connection.h"
#include "terminal.h"
#include "window_list.h"
#include "operations.h"
#include "basewidget.h"
#include "variables_list.h"

/**Controls all modules. Exec application and interconnect modules.
*/

class Main:public QObject
{
	Q_OBJECT
	MainWindow *main_window;
	QWorkspace *work_space;
	WindowList *window_list;
	Operations *operations;
	
	Terminal *terminal;
	public:
	Main(QObject * parent = 0);
	BaseWidget *active_widget;
	
	public slots:
	/**Shows Octave Help.*/
	void help_octave();
	/**Shows QtOctave Help.*/
	void help_qtoctave();
	/**Shows Table.*/
	void table(QString text=QString());
	/**Opens new QtOctave window.*/
	void open();
	/**Opens new variable list.*/
	void variable_list();
	/**Callback used for sets active_widget.
	 * @param w widget activated.
	*/
	void widget_activated(BaseWidget *w);
};

#endif
