#include "variables_list.h"


VariableList::VariableList(QWidget * parent):BaseWidget(parent)
{
	setWindowIcon( QIcon( QString( ICON_PATH )+"/taskbar.png" ) );
	setWindowTitle("Variables' List");
	
	QVBoxLayout *vbox=new QVBoxLayout;
	setLayout(vbox);
	
	QHBoxLayout *hbox=new QHBoxLayout;
	vbox->addLayout(hbox);
	
	reload_button=new QPushButton(this);
	reload_button->setIcon( QIcon( QString( ICON_PATH )+"/reload.png" ) );
	reload_button->setToolTip("Reload variables' list");
	hbox->addWidget(reload_button);
	reload_button->show();
	connect(reload_button,SIGNAL(clicked ()), this, SLOT(send_whos_command_to_octave()));
	
	//text=new QTextEdit(this);
	//vbox->addWidget(text);
	//text->show();
	
	tree=new QTreeWidget(this);
	QStringList labels;
	labels << "Name" << "Size" << "Bytes" << "Class" << "Prot" ;
	tree->setHeaderLabels(labels);
	connect(tree,SIGNAL(itemDoubleClicked ( QTreeWidgetItem * , int  )), this, SLOT(item_click(QTreeWidgetItem *,int)) );
	
	vbox->addWidget(tree);
	tree->show();
}

void VariableList::setOctaveConnection(OctaveConnection *octave_connection)
{
	this->octave_connection=octave_connection;
	connect(octave_connection,SIGNAL(line_ready(QString)),this,SLOT(line_ready(QString)));
}

void VariableList::line_ready(QString line)
{
	if( line.startsWith("~~whos:") )
	{
		QString s(line);
		s.remove(0,7);
		if( s.trimmed().isEmpty() ) return;
		
		if( s.startsWith("*** dynamically") )
		{
			//text->append("<b>"+s+"</b>");
			s.remove(0,4);
			
			last_root_item=dynamically_item;
			last_root_item->setText(0,s.trimmed());
			last_root_item->setToolTip(0,s.trimmed());
			last_root_item->setIcon(0,QIcon( QString( ICON_PATH )+"/connect_established.png"  ) );
			QFont font(tree->font());
			font.setBold(true);
			last_root_item->setFont(0,font);
		}
		else if( s.startsWith("*** local") )
		{
			//text->append("<b>"+s+"</b>");
			s.remove(0,4);
			
			last_root_item=local_item;
			last_root_item->setText(0,s.trimmed());
			last_root_item->setToolTip(0,s.trimmed());
			last_root_item->setIcon(0,QIcon( QString( ICON_PATH )+"/personal.png"  ) );
			QFont font(tree->font());
			font.setBold(true);
			last_root_item->setFont(0,font);
		}
		else if( s.startsWith("*** currently") )
		{
			//text->append("<b>"+s+"</b>");
			s.remove(0,4);
			
			last_root_item=currently_item;
			last_root_item->setText(0,s.trimmed());
			last_root_item->setToolTip(0,s.trimmed());
			last_root_item->setIcon(0,QIcon( QString( ICON_PATH )+"/run.png"  ) );
			QFont font(tree->font());
			font.setBold(true);
			last_root_item->setFont(0,font);
		}
		else if( s.startsWith("   ") )
		{
			//text->append("<pre>"+s+"</pre>");
			QTreeWidgetItem *item=new QTreeWidgetItem(last_root_item);
			QStringList list = s.trimmed().split(QRegExp("\\s+"));
			int i=0;
			for(;i<list.size() && i<4;i++)
			{
				item->setText(i,list.at(i+1) );
				item->setToolTip(i,list.at(i+1) );
			}
			s=list.at(i++);
			for(;i<list.size();i++) s+=list.at(i);
			item->setText(3,s);
			item->setToolTip(3,s);
			item->setText(4,list.at(0) );
			item->setToolTip(4,list.at(0) );
			//tree->resizeColumnToContents(1);
			//tree->resizeColumnToContents(2);
			for(i=1;i<5;i++) tree->resizeColumnToContents(i);
		}
		else if( s.startsWith("  ") )
		{
			//text->append("<pre>"+s+"</pre>");
		}
		else
		{
			//text->append(s);
			QTreeWidgetItem *item=new QTreeWidgetItem(last_root_item);
			item->setText(0,s.trimmed());
			item->setToolTip(0,s.trimmed());
		}
	}
}

void VariableList::windowActivated ( QWidget * /*w*/ )
{
	//send_whos_command_to_octave();
}

void VariableList::windowActivated()
{
	//send_whos_command_to_octave();
}

void VariableList::send_whos_command_to_octave()
{
	//text->clear();
	
	tree->clear();
	
	local_item=new QTreeWidgetItem(tree);
	dynamically_item=new QTreeWidgetItem(tree);
	currently_item=new QTreeWidgetItem(tree);
	
	QString command;
	command=
	"command_line_prompt1=PS1(\"\"); command_line_prompt2=PS2(\"\");\n"
	"if ( 1==1 )"
	//"in = -1;\n"
	//"out = -1;\n"
	//"pid = -1;\n"
	
	"[stdin_pipe, stdin_status] = pipe ();\n"
	"[stdout_pipe, stdout_status] = pipe ();\n"
	
	
	"if (stdin_status == 0 && stdout_status == 0)\n"
	
	
	"	pid = fork ();\n"
		
		
	"	if (pid == 0)\n"
			
			
	"		## In the child.\n"
			
			
	"		fclose (nth (stdin_pipe, 2));\n"
	"		fclose (nth (stdout_pipe, 1));\n"
			
			
	"		dup2 (nth (stdin_pipe, 1), stdin);\n"
	"		fclose (nth (stdin_pipe, 1));\n"
			
			
	"		dup2 (nth (stdout_pipe, 2), stdout);\n"
	"		fclose (nth (stdout_pipe, 2));\n"
	"		clear pid command_line_prompt1 command_line_prompt2 stdin_pipe stdin_status stdout_pipe stdout_status;\n"	
	"		whos\n"
	"		exit(0);\n"
			
	"	elseif (pid)\n"
		
	"		## In the parent.\n"
			
			
	"		fclose (nth (stdin_pipe, 1));\n"
	"		fclose (nth (stdout_pipe, 2));\n"
			
	"		in_pipe = nth (stdin_pipe, 2);"
	"		out_pipe = nth (stdout_pipe, 1);"
			
			
	"		fclose(in_pipe);\n"
			//printf("Leyendo la salida\n");
			
	"		while( feof(out_pipe)!=1 )\n"
	"		    line_buffer=fgets(out_pipe);\n"
	"		    if( ischar (line_buffer) )\n"
	"			fprintf(stderr,\"~~whos:\");\n"
	"			fputs(stderr,line_buffer);\n"
	"		    else\n"
	"			break;\n"
	"		    endif\n"
	"		end;\n"
	"		fclose(out_pipe);\n"
	
	"		clear in_pipe line_buffer out_pipe ;\n"

			
	"	elseif (pid < 0)\n"
	"		error (\"octave_whos: fork failed -- unable to create child process\");\n"
	"	endif;\n"
	"else\n"
	"	error (\"octave_whos: file name must be a string\");\n"
	"endif; \n"
	"PS1(command_line_prompt1); PS2(command_line_prompt2); endif; \n"
	;
	octave_connection->command_enter(command,false);
	octave_connection->command_enter("printf(\"\\n\")",false);
}



void VariableList::item_click(QTreeWidgetItem * item, int /*column*/)
{
	QString name=item->text(0);
	QString clas=item->text(3);
	if (clas=="double")
	{
		emit open_table(name);
	}
}

