/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#ifndef __OCTAVE_CONNECTION_H__
#define __OCTAVE_CONNECTION_H__

#include <QProcess>
#include <QTextEdit>
#include <QBuffer>
#include "config.h"


/** This class build QProcess and exec Octave. Octave input and output are controlled by this class.
*/
class OctaveConnection : public QProcess
{
	Q_OBJECT
	public:
	OctaveConnection(QObject * parent = 0);
	/** Sets octave path.
	 * @param path path to Octave.
	 */
	void setOctavePath(const QString path);
	void startOctave();
	//void setTextEdit(QTextEdit *text);
	/** Sends command to Octave.
	 * @param text Command to send.
	 * @param show Shows command in Terminal or not.
	 */
	void command_enter(const QString &text, bool show=true);
	private:
	QString octave_path;
	//QTextEdit *text;
	QString line_buffer;
	QBuffer error_buffer;
	public slots:
	void octaveOutputSlot();
	void octaveErrorOutputSlot();
	signals:
	/**Emits this signal when line is available from stderr of Octave.*/
	void line_ready(QString line);
	void output_ready(QString output);
	void error_ready(QString error);
	void command_ready(QString command);
};

#endif

