/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#include "octave_connection.h"
#include <QThread>
#include <QTextCursor>

OctaveConnection::OctaveConnection(QObject * parent ):QProcess(parent)
{
	octave_path="";
	//text=NULL;
	error_buffer.open(QBuffer::ReadOnly);
	QObject::connect(this, SIGNAL(readyReadStandardError()), this, SLOT(octaveErrorOutputSlot()));
	QObject::connect(this, SIGNAL(readyReadStandardOutput()), this, SLOT(octaveOutputSlot()));
}

void OctaveConnection::setOctavePath(const QString path)
{
	octave_path=path;
}

// void OctaveConnection::setTextEdit(QTextEdit *text)
// {
// 	this->text=text;
// 	QObject::connect(this, SIGNAL(readyReadStandardError()), this, SLOT(octaveErrorOutputSlot()));
// 	QObject::connect(this, SIGNAL(readyReadStandardOutput()), this, SLOT(octaveOutputSlot()));
// }

void OctaveConnection::startOctave()
{
	start(octave_path+"octave -i");
}

void OctaveConnection::command_enter (const QString &command, bool show)
{
	if(show)
	{
		/*
		QTextCursor cursor=text->textCursor();
		cursor.movePosition(QTextCursor::End);
		text->setTextCursor( cursor );
		text->setFontWeight ( QFont::Bold );
		text->setTextColor( Qt::black );
		text->insertPlainText(command+"\n");
		text->setFontWeight ( QFont::Normal );
		*/
		emit command_ready(command+"\n");
	}
	write((command+"\n").toLocal8Bit() );
}


void OctaveConnection::octaveOutputSlot()
{
	/*
	QTextCursor cursor=text->textCursor();
	cursor.movePosition(QTextCursor::End);
	text->setTextColor( Qt::black );
	text->setFontWeight ( QFont::Normal );
	text->insertPlainText(readAllStandardOutput());
	text->setTextCursor( cursor );
	*/
	
	QString buffer=readAllStandardOutput();
	QThread::currentThread ()->wait (100);
	emit output_ready(buffer);
	
	//Se procesa el buffer para buscar las l�eas diponibles
	// 	QStringList lines=buffer.split("\n");
	// 	QStringList::const_iterator i;
	// 	for (i = lines.constBegin(); i != lines.constEnd();)
	// 	{
	// 		QString line=*i;
	// 		++i;
	// 		if(i==lines.constEnd() && !buffer.endsWith("\n"))
	// 			emit output_ready(line);
	// 		else
	// 			emit output_ready(line+"\n");
	// 	}
}

void OctaveConnection::octaveErrorOutputSlot()
{
	//QTextCursor cursor=text->textCursor();
	//cursor.movePosition(QTextCursor::End);
	//text->setTextColor( Qt::red );
	//text->setFontWeight ( QFont::Normal );
	//text->insertPlainText(buffer);
	//text->setTextCursor( cursor );
	
	//QString buffer=readAllStandardError();
	
	QString buffer=error_buffer.data();
	error_buffer.close();
	error_buffer.setData( buffer.toUtf8()+readAllStandardError());
	error_buffer.open(QBuffer::ReadOnly);
	QThread::currentThread ()->wait (200);
	
	QString line, error("");
	do
	{
		line=error_buffer.readLine();
		if(line.endsWith("\n") )
		{
			if(line.startsWith("~~")) emit line_ready(line);
			else error+=line;
			continue;
		}
		else
		{
			line=line+error_buffer.readAll();
			error_buffer.close();
			error_buffer.setData(line.toUtf8());
			error_buffer.open(QBuffer::ReadOnly);
			break;
		}
		emit line_ready(line);
	}
	while(error_buffer.bytesAvailable());
	emit error_ready(error);
	if(!error_buffer.bytesAvailable())
	{
		error_buffer.close();
		error_buffer.setData(QString("").toUtf8());
		error_buffer.open(QBuffer::ReadOnly);
	}
	
	//Se procesa el buffer para buscar las l�eas diponibles
	//QStringList lines=buffer.split("\n");
	//QStringList::const_iterator i;
	//for (i = lines.constBegin(); i != lines.constEnd();)
	//{
	//	QString line=*i;
	//	++i;
	//	if(i==lines.constEnd() && !buffer.endsWith("\n"))
	//		emit error_ready(line);
	//	else
	//		emit error_ready(line+"\n");
	//	emit line_ready(line);
	//}
}

