/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */


#include <QApplication>
#include "install.h"
#include <string.h>

int main(int argn, char *argv[])
{
	QApplication a(argn,argv);
	Install install;
	char graph_ok=false;
	
	install.it->qmake_lineEdit->setText(install.getenv("QMAKE"));
	install.it->install_path_lineEdit->setText(install.getenv("DATADIR"));
	install.it->bin_path_lineEdit->setText(install.getenv("BINDIR"));
	install.it->help_path_lineEdit->setText(install.getenv("OCTAVEHELP"));
	install.it->default_help_checkBox->setChecked (false);
	
	{
		int i=1;
		while(i<argn)
		{
			if(strcmp(argv[i],"--help")==0)
			{
				printf("%s\n",argv[0]);
				printf(
						"Starts install-tool. Options:\n"
						"--help Shows this help\n"
						"-qmake command Sets qmake command\n"
						"-qmake_parameters parameters Sets qmake paramaters\n"
						"-install_path path\n"
						"-bin_path path\n"
						"-default_help true|false\n"
						"-help_path path\n"
						"-graph Start in graphical mode\n"
				      );
				return 0;
			}
			else if(strcmp(argv[i],"-qmake")==0)
			{
				i++;
				install.it->qmake_lineEdit->setText(argv[i]);
			}
			else if(strcmp(argv[i],"-qmake_parameters")==0)
			{
				i++;
				install.it->qmake_parameters_lineEdit->setText(argv[i]);
			}
			else if(strcmp(argv[i],"-install_path")==0)
			{
				i++;
				install.it->install_path_lineEdit->setText(argv[i]);
			}
			else if(strcmp(argv[i],"-bin_path")==0)
			{
				i++;
				install.it->bin_path_lineEdit->setText(argv[i]);
			}
			else if(strcmp(argv[i],"-default_help")==0)
			{
				i++;
				if(!strcmp(argv[i],"true"))
					install.it->default_help_checkBox->setChecked(true);
				else
					install.it->default_help_checkBox->setChecked(false);
			}
			else if(strcmp(argv[i],"-help_path")==0)
			{
				i++;
				install.it->help_path_lineEdit->setText(argv[i]);
			}
			else if(strcmp(argv[i],"-graph")==0)
			{
				graph_ok=true;
			}
			i++;
		}
	}
	
	if(graph_ok)
	{
		install.show();
		return a.exec();
	}
	
	install.build_scripts();
	
}
