/*
 * Decompiled with CFR 0.152.
 */
package socket.io;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WrappedOutputStream
extends FilterOutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    protected byte[] fBuffer;
    protected int fPosition;
    protected DataOutputStream fDataOutputStream;

    public WrappedOutputStream(OutputStream outputStream) {
        this(outputStream, 1024);
    }

    public WrappedOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.fBuffer = new byte[n];
        this.fDataOutputStream = new DataOutputStream(outputStream);
    }

    public void write(int n) throws IOException {
        this.fBuffer[this.fPosition++] = (byte)n;
        if (this.fPosition == this.fBuffer.length) {
            this.fPosition = 0;
            this.fDataOutputStream.writeInt(this.fBuffer.length);
            this.out.write(this.fBuffer, 0, this.fBuffer.length);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.fPosition > 0) {
            this.flush0();
        }
        this.fDataOutputStream.writeInt(n2);
        this.out.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.flush0();
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush0();
        this.fDataOutputStream.writeInt(0);
        this.out.flush();
    }

    public void flush0() throws IOException {
        int n = this.fPosition;
        this.fPosition = 0;
        if (n > 0) {
            this.fDataOutputStream.writeInt(n);
            this.out.write(this.fBuffer, 0, n);
        }
    }
}

