import pymsn
import pymsn.msnp2p
import asyncore, getpass
import logging
import time
import gobject
import signal
import urllib
import re
import sys

logging.basicConfig(level=logging.DEBUG)

finished = False
def getproxies():
    proxies = urllib.getproxies()
    result = {}
    for type, url in proxies.items():
        if type == 'no':
            continue
        result[type] = pymsn.network.ProxyInfos.build_from_string(url)
    return result

class NS(pymsn.Client):
    def __init__(self, server, account, mainloop, http_method=False):
        if http_method:
            transport = pymsn.transport.HTTPPollConnection
        else:
            transport = pymsn.transport.DirectConnection
        pymsn.Client.__init__(self, server, account, proxies = getproxies(),
                transport_class = transport)
        gobject.idle_add(self.connect_cb)
        self.mainloop = mainloop

    def connect_cb(self):
        self.login()
        return False

    def on_connect_failure(self, proto):
        print "Connect failed"
        self.mainloop.quit()

    def on_login_failure(self, proto):
        print "Login failed"
        self.mainloop.quit()

    def on_login_success(self, proto):
        self.dp_fetched = False
        #gobject.timeout_add(5000, self.__find_contact)
        gobject.timeout_add(5000, self.__publish_avatar)

    def on_switchboard_invitation(self, proto, server, key,
            session, passport, friendly_name):
        inv = [self.connection.get_contact_by_passport(passport),]
        self.switchboard = pymsn.Conversation(self, invitee=inv,
                                       server=server, key=key,
                                       session=session)

    def __publish_avatar(self):
        data = file("pymsn.png").read()
        self.profile.display_picture = data
        
    def __find_contact(self):
        for contact in self._protocol._contacts.values():
            passport = contact.get_property("passport")
            presence = contact.get_property("presence")
            if presence != pymsn.PresenceStatus.OFFLINE:
                print "Contact %s is online" % contact.get_property("passport")
                
                gobject.idle_add(self.__fetch_dp, contact)
                return False

        return True

    def __fetch_dp(self, contact):
        if self.dp_fetched:
            return False
        
        self.dp_fetched = True
        
        dpc = pymsn.msnp2p.DisplayPictureCall(self)
        dpc.request(contact, self.__on_dp_request_done)
        
        return False
    
    def __on_dp_request_done(self, result):
        if result == None:
            print "_on_dp_request_done: Failed to fetch DP"
            return
        
        print "_on_dp_request_done: Got DP! %d bytes of data" % len(result)


def main():
    if len(sys.argv) < 2:
        account = raw_input('Account: ')
    else:
        account = sys.argv[1]
    
    if len(sys.argv) < 3:
        passwd = getpass.getpass('Password: ')
    else:
        passwd = sys.argv[2]
    
    mainloop = gobject.MainLoop(is_running=True)
    http_method = '--http' in sys.argv
    n = NS(('messenger.hotmail.com', 1863), (account, passwd), mainloop, http_method)


    def quit_cb():
        mainloop.quit()

    def sigterm_cb():
        gobject.idle_add(quit_cb)

    signal.signal(signal.SIGTERM, sigterm_cb)

    while mainloop.is_running():
        try:
            mainloop.run()
        except KeyboardInterrupt:
            quit_cb()

if __name__ == '__main__':
    main()
