/*  This file is part of the KDE project
    Copyright (C) 2001 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2002 Paul Chitescu <paulc-devel@null.ro>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __htmlview_h__
#define __htmlview_h__

#include <khtmlview.h>
#include <khtml_part.h>

class HTMLView;

class HTMLView : public KHTMLPart
{
    Q_OBJECT
public:
    HTMLView( QWidget *parentWidget, const char *widgetName,
              QObject *parent, const char *name );

    virtual bool openURL( const KURL &url );

    virtual void saveState( QDataStream &stream );
    virtual void restoreState( QDataStream &stream );

    virtual KParts::ReadOnlyPart *createPart( QWidget *parentWidget, const char *widgetName,
                                              QObject *parent, const char *name,
                                              const QString &mimetype, QString &serviceName,
                                              QStringList &serviceTypes, const QStringList &params );

    bool isUtility() { return m_utilityMode; }

    virtual void begin ( const KURL &url = KURL(), int xOffset = 0, int yOffset = 0 );

private slots:
    void slotImageJobFinished( KIO::Job *job );
    void popupMenu( const QString &_url, const QPoint &pt );

signals:
    void popupMenu( KHTMLPart *part, const QString &_url );

private:
    bool m_imageMode;
    bool m_utilityMode;
    QString m_serviceType;
};

#endif
