/*  This file is part of the KDE project
    Copyright (C) 2000 Carsten Pfeiffer <pfeiffer@kde.org>
    Copyright (C) 2004 Fastweb SpA

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kpushbutton_h__
#define __kpushbutton_h__

#include <qstring.h>
#include <qpushbutton.h>

class KPushButton : public QPushButton
{
public:
    KPushButton(const QString &text, QWidget *parent, const char *name = 0);
};

inline 
KPushButton::KPushButton(const QString &text, 
	QWidget *parent, const char *name) : QPushButton(parent, name)
{
    setText(text);
}

#endif // __kpushbutton_h__
