/*  This file is part of the KDE project
    Copyright (C) 2002 Paul Chitescu <paulc-devel@null.ro>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

#include <dcopclient.h>
#include <kssl/ksslinfodlg.h>

#include "uiserver.h"


// DCOP function
void UIServer::showSSLInfoDialog(const QString &url, const KIO::MetaData &meta)
{
    KSSLInfoDlg *kid = new KSSLInfoDlg( meta["ssl_in_use"].upper()=="TRUE", 0L /*parent?*/, 0L, true );
    KSSLCertificate *x = KSSLCertificate::fromString(meta["ssl_peer_certificate"].local8Bit());
    kid->setup( x,
		meta["ssl_peer_ip"],
		url,
		meta["ssl_cipher"],
		meta["ssl_peer_cert_subject"],
		meta["ssl_peer_cert_issuer"],
		meta["ssl_cipher_used_bits"].toInt(),
		meta["ssl_cipher_bits"].toInt(),
		KSSLCertificate::KSSLValidation(meta["ssl_cert_state"].toInt())
		);
    kid->exec(); // will delete itself
}


#include "uiserver.moc"
