/*  This file is part of the KDE project
    Copyright (C) 2000-2002 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>
    Copyright (C) 2003-2004 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kio_slavebase_h__
#define __kio_slavebase_h__

#include <qcstring.h>
#include <qstring.h>

#include <kio/global.h>
#include <kio/authinfo.h>
#include <kio/kprotocolmanager.h>
#include <kurl.h>
#include <dcopclient.h>
#include <kremoteencoding.h>
#include <kconfig.h>

#include <sys/time.h>

class KConfig;

namespace KIO
{
    class Connection;

    class SlaveBase
    {
    public:
        static SlaveBase *createSlave( const QString &protocol );
        // ### hack until I implement the factories :)
        static bool knownProtocol( const QString &protocol );

        SlaveBase( const QCString &protocol, const QCString &pool_socket = QCString(), const QCString &app_socket = QCString() );
        virtual ~SlaveBase();

        void setConnection( Connection *conn ) { m_connection = conn; }
        Connection *connection() const { return m_connection; }

        void dispatchLoop();

        void data( const QByteArray &data );

        void dataReq();

        virtual void error( int _errid, const QString &_text );

        void connected();

        virtual void finished();

        void slaveStatus( const QString &host, bool connected );

        void statEntry( const UDSEntry &entry );

        // Needed by kdelibs 3.2
        bool canResume( KIO::filesize_t offset );
        
        void totalSize( KIO::filesize_t bytes );

        void processedSize( KIO::filesize_t bytes );

        void speed( unsigned long bytesPerSecond );

        void redirection( const KURL &url );

        void errorPage();

        void mimeType( const QString &mimeType );

        virtual void listEntry( const UDSEntry &entry, bool ready );

        void infoMessage( const QString &msg );

        bool openPassDlg( AuthInfo &info, const QString &errorMsg = QString::null );


        enum MessageBoxType { QuestionYesNo = 1, WarningYesNo = 2, WarningContinueCancel = 3, WarningYesNoCancel = 4,
               Information = 5, SSLMessageBox = 6 };

        /*enum { QuestionYesNo = 1, WarningYesNo = 2, WarningContinueCancel = 3, WarningYesNoCancel = 4,
               Information = 5, SSLMessageBox = 6 };*/

        int messageBox( int type, const QString &text,
                        const QString &caption = QString::null,
                        const QString &buttonYes = QString::null,
                        const QString &buttonNo = QString::null );

        // This seems to have appeared in 3.3.something
        // I see no real difference with the one above except the arguments
        // are shuffled around?


        int messageBox( const QString &text, MessageBoxType type,
                    const QString &caption = QString::null,
                    const QString &buttonYes = QString::null,
                    const QString &buttonNo = QString::null,
                    const QString &dontAskAgainName = QString::null );



        void setMetaData( const QString &key, const QString &value );

        bool hasMetaData( const QString &key ) const;

        QString metaData( const QString &key ) const;

        virtual void setHost( const QString &host, int port, const QString &user, const QString &pass );

        virtual void get( const KURL &url );

        virtual void put( const KURL &url, int permissions, bool overwrite, bool resume );

        virtual void stat( const KURL &url );

        virtual void mimetype( const KURL &url );

        virtual void special( const QByteArray & );

        virtual void slave_status();

        virtual void reparseConfiguration();

        int readData( QByteArray &buffer );

        bool checkCachedAuthentication( AuthInfo &info );

        void cacheAuthentication( const AuthInfo &info );

        void sendMetaData();

        /**
        * Returns an object that can translate remote filenames into proper
        * Unicode forms. This encoding can be set by the user.
        *
        * @since 3.3
        */
        KRemoteEncoding* remoteEncoding();

        // needed by kdelibs 3.2
        bool wasKilled() const { return false; }

        void dispatch( int command, const QByteArray &packedArgs );

        void canResume() {}

        KConfig *config() const { return m_kconfig; }

        // ### metadata!
        int connectTimeout() const { return KProtocolManager::connectTimeout(); }

        int proxyConnectTimeout() const { return KProtocolManager::proxyConnectTimeout(); }

        int responseTimeout() const { return KProtocolManager::responseTimeout(); }

        int readTimeout() const { return KProtocolManager::readTimeout(); }

	// needed by kdelibs 3.1
        void setTimeoutSpecialCommand(int timeout, const QByteArray &data=QByteArray());

	// ### FIXME!
	void setMultipleAuthCaching( bool enable ) { m_multipleAuthCaching = enable; }

	bool multipleAuthCaching() const { return m_multipleAuthCaching; }

	// needed by kdelibs 3.2
        DCOPClient *dcopClient() { return m_dcc; }
    protected:
        virtual void virtual_hook( int id, void* data );
        QCString mProtocol;
        DCOPClient *m_dcc;
        KRemoteEncoding *m_remotefile;
        MetaData mOutgoingMetaData;
        MetaData mIncomingMetaData;

    private:
        int waitForAnswer( int expected1, int expected2, QByteArray &data, int *_cmd );

        Connection *m_connection;
        MetaData m_incomingMetaData;
        MetaData m_config;
        KConfig *m_kconfig;

	bool m_multipleAuthCaching;
        
	// needed by kdelibs 3.1
        time_t m_timeout;
	QByteArray m_timeoutData;
    };

}

/* vim: et sw=4 ts=8
 */

#endif
