/*  This file is part of the KDE project
    Copyright (C) 2000-2001 Simon Hausmann <hausmann@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <kdebug.h>

#include "job.h"

#include <slaveinterface.h>
#include <kssl/ksslcsessioncache.h>

using namespace KIO;

void Job::addMetaData( const QString &key, const QString &value)
{
    m_outgoingMetaData.insert(key, value);
}

MetaData Job::metaData() const
{
    return m_incomingMetaData;
}

QString Job::queryMetaData(const QString &key)
{
    if (!m_incomingMetaData.contains(key))
       return QString::null;
    return m_incomingMetaData[key];
}

TransferJob *KIO::get( const KURL &url, bool reload, bool showProgressInfo )
{
    KIO_ARGS << url;

    TransferJob *job = 0;

    job = TransferJob::findDetachedJobForURL( url );
    if ( job )
        job->attach();
    else
        job = new TransferJob( url, CMD_GET, packedArgs, QByteArray(), showProgressInfo );

    if ( reload )
        job->addMetaData( "cache", "reload" );

    return job;
}

TransferJob *KIO::http_post( const KURL &url, const QByteArray &httpData, bool showProgressInfo )
{
    KIO_ARGS << (int)1 << url;

    TransferJob *job = 0;

    job = TransferJob::findDetachedJobForURL( url );
    if ( job )
        job->attach();
    else
        job = new TransferJob( url, CMD_SPECIAL, packedArgs, httpData, showProgressInfo );

    return job;
}

SimpleJob *KIO::http_update_cache( const KURL &url, bool no_cache, time_t expireDate )
{

    KIO_ARGS << (int)2 << url << no_cache << expireDate;

    SimpleJob *job = new SimpleJob( url, CMD_SPECIAL, packedArgs, false );

    return job;
}

StatJob *KIO::stat(const KURL& url, bool)
{
    kdDebug() << k_funcinfo << "called with url = " << url.url() << endl;
    
    KIO_ARGS << url;
    StatJob *job = new StatJob(url, CMD_STAT, packedArgs, false);
    
    return job;
}

void SimpleJob::slotMetaData( const KIO::MetaData &_metaData)
{
    m_incomingMetaData += _metaData;
}

void SimpleJob::storeSSLSessionFromJob(const KURL &m_redirectionURL) {
    QString sslSession = queryMetaData("ssl_session_id");

    if ( !sslSession.isNull() ) {
        const KURL &queryURL = m_redirectionURL.isEmpty()?m_url:m_redirectionURL;
        KSSLCSessionCache::putSessionForURL(queryURL, sslSession);
    }
}

void TransferJob::slotMetaData( const KIO::MetaData &_metaData) {
    SimpleJob::slotMetaData(_metaData);
    storeSSLSessionFromJob(m_redirectionURL);
}

