/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/


#include "kinputdialog.h"

#include <qdialog.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <klocale.h>

#ifdef QT_NO_INPUTDIALOG

QString QInputDialog::getText( const QString &caption, const QString &labelText,
                               const QString &text )
{
    QDialog *dialog = new QDialog( 0, 0, true );
#ifndef QT_NO_WIDGET_TOPEXTRA
    dialog->setCaption( caption );
#endif

    QVBoxLayout *layout = new QVBoxLayout( dialog );
    layout->setSpacing( 6 );
    layout->setMargin( 11 );

    QLabel *label = new QLabel( labelText, dialog );
    layout->addWidget( label );

    QLineEdit *lineEdit = new QLineEdit( text, dialog );
    layout->addWidget( lineEdit );

// should be !defined, enabled only for testing
#if defined(_QT_QPE_)
    QHBoxLayout *buttonLayout = new QHBoxLayout( layout );

    buttonLayout->addStretch( 1 );

    QPushButton *ok = new QPushButton( i18n( "&OK" ), dialog );
    buttonLayout->addWidget( ok );
    QObject::connect( ok, SIGNAL( clicked() ), dialog, SLOT( accept() ) );

    QPushButton *cancel = new QPushButton( i18n( "&Cancel" ), dialog );
    buttonLayout->addWidget( cancel );
    QObject::connect( cancel, SIGNAL( clicked() ), dialog, SLOT( reject() ) );

#endif

    QString res;

    if ( dialog->exec() == QDialog::Accepted )
        res = lineEdit->text();

#warning the kjs code should check for ok!!

    delete dialog;

    return res;
}

#endif

