/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>
    Copyright (C) 2005 Fastweb SpA

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef DROPIN_KAPPLICATION_H
#define DROPIN_KAPPLICATION_H

#include <qguardedptr.h>
#include <qapplication.h>

#include <stdlib.h>

#include <kinstance.h>

#define kapp KApplication::self()

class DCOPClient;

#ifdef _QT_QPE_
#include <qpeapplication.h>
#define QApplication QPEApplication
#endif

#include <kurl.h>

#include <kdeversion.h>

#if defined( Q_WS_QWS )
#define KDE_VERSION_STRING "3.1"
#endif

// nasty hack: khtmlview needs QPrinter. In case Qt is compiled without
// QPrinter (makes no sense on a PDA!) we provide a very dummy QPrinter
// replacement and include it here, as khtmlview.cpp certainly includes
// kapp.h
#ifdef QT_NO_PRINTER
#include <kdummyprinter.h>
#endif

#include <kglobalsettings.h>

class KApplication : public QApplication, public KInstance
{
    Q_OBJECT

#undef QApplication

public:
    KApplication( int &argc, char **argv, const char *name );
    virtual ~KApplication();

    static KApplication *self() { return s_self; }
    static KApplication *kApplication() { return self(); } // for render_form.cpp

    // dummy for tcpslavebase.cpp
    static bool startServiceByDesktopPath( const QString &, const QStringList & ) { return false; }

    // Needed by KHTML 3.1 
    // This needs to be properly implemented, otherwise we open our box to attacks.
    bool authorizeURLAction(const QString &, const KURL &, const KURL &);
    
    // ### extension
    static void setService( const QString &desktopPath, void *entryPoint );

    static bool startServiceByDesktopPath( const QString &path );

    static int startServiceByDesktopName( const QString&, const QStringList& =QStringList(),
                                          QString* =0, QCString* =0, int* = 0, const QCString& = "", bool = false )
    { 
        return 0;
    }


    // Needed by kdelibs 3.5
    static void kdeinitExec(char *, const QStringList &) {}

    DCOPClient *dcopClient() const { return m_dcopClient; }

    void invokeBrowser( const QString & ) {}
    void invokeMailer( const QString & ) {}
    static int random() { return rand(); } // ### ;-)
    
    // Needed by kdelibs >= 3.1.2
    static QString randomString(int length);

    enum { ShiftModifier = 1<<0,
         LockModifier = 1<<1,
         ControlModifier = 1<<2,
         Modifier1 = 1<<3,
         Modifier2 = 1<<4,
         Modifier3 = 1<<5,
         Modifier4 = 1<<6,
         Modifier5 = 1<<7 };

   static uint keyboardModifiers();
   
   // required since kdelibs 3.4
   static ButtonState keyboardMouseState() { 
	   return static_cast <ButtonState>(0); 
   }
   
   // required since kdelibs 3.4
   void updateUserTimestamp(unsigned long = 0) {}

signals:
    // required by KHTMLView
    void kdisplayPaletteChanged();

private:
    static KApplication *s_self;

    DCOPClient *m_dcopClient;

    static QString *s_serviceName;
    static void *s_serviceEntryPoint;
};

// ### FIXME: checkAccess copyright by Kalle!

bool checkAccess(const QString &pathname, int mode);

#endif // DROPIN_KAPPLICATION_H
