/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>
    Copyright (C) 2005 Fastweb SpA
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "kapplication.h"
#include "kconfig.h"
#include "dcopclient.h"
#include "kstandarddirs.h"
#include "kio/kprotocolinfo.h"

#include <unistd.h>
#include <qfile.h>
#include <qdir.h>

#include <assert.h>

bool kde_kiosk_admin = false;

KApplication *KApplication::s_self = 0;

KApplication::KApplication( int &argc, char **argv, const char *name )
#ifdef _QT_QPE_
    : QPEApplication( argc, argv /*, name */ ), KInstance( name )
#else
    : QApplication( argc, argv, name ), KInstance( name )
#endif
{
    s_self = this;
    KGlobal::_instance = this; // ### hack

    m_dcopClient = new DCOPClient;
    KGlobal::dirs()->addResourceType("appdata", KStandardDirs::kde_default("data")
                                     + QString::fromLatin1(name) + '/');
}

KApplication::~KApplication()
{
    delete m_dcopClient;
    s_self = 0;
}

QString *KApplication::s_serviceName = 0;
void *KApplication::s_serviceEntryPoint = 0;

void KApplication::setService( const QString &desktopPath, void *entryPoint )
{
    if ( !s_serviceName )
        s_serviceName = new QString;

    *s_serviceName = desktopPath;
    s_serviceEntryPoint = entryPoint;
}

bool KApplication::startServiceByDesktopPath( const QString &path )
{
    // ### hack
    if ( s_serviceName && path == *s_serviceName && s_serviceEntryPoint )
    {
        if ( fork() == 0 )
        {
            typedef int (*EntryFunc)(int, char **);
            EntryFunc func = (EntryFunc)s_serviceEntryPoint;
            (*func)( qApp->argc(), qApp->argv() );
            ::exit( 0 );
        }

        return true;
    }

    return false;
}

bool checkAccess(const QString& pathname, int mode)
{
  int accessOK = access( QFile::encodeName(pathname), mode );
  if ( accessOK == 0 )
    return true;  // OK, I can really access the file

  // else
  // if we want to write the file would be created. Check, if the
  // user may write to the directory to create the file.
  if ( (mode & W_OK) == 0 )
    return false;   // Check for write access is not part of mode => bail out


  if (!access(QFile::encodeName(pathname), F_OK)) // if it already exists
      return false;

  // strip the filename (everything until '/' from the end
  QString dirName(pathname);
  int pos = dirName.findRev('/');
  if ( pos == -1 )
    return false;   // No path in argument. This is evil, we won't allow this

  dirName.truncate(pos); // strip everything starting from the last '/'

  accessOK = access( QFile::encodeName(dirName), W_OK );
  // -?- Can I write to the accessed directory
  if ( accessOK == 0 )
    return true;  // Yes
  else
    return false; // No
}

// This is needed for kdelibs >= 3.1.2
 
QString KApplication::randomString(int length)
{
   if (length <=0 ) return QString::null;

   QString str;
   while (--length)
   {
      int r=random() % 62;
      r+=48;
      if (r>57) r+=7;
      if (r>90) r+=6;
      str += char(r);
      // so what if I work backwards?
   }
   return str;
}

uint KApplication::keyboardModifiers()
{
    //FIXME this should check if we are on X11 or not and
    //do the right thing on each case
    return 0x00ff;
}

bool 
KApplication::authorizeURLAction(const QString & /*action*/,
				 const KURL & _baseURL,
				 const KURL & _destURL)
{
    // Very simple authorization, for now: block access to the file: protocol,
    // allow anything else.
    if (_destURL.isEmpty())
	return true;

    bool result = true;

    KURL baseURL(_baseURL);
    baseURL.setPath(QDir::cleanDirPath(baseURL.path()));
    QString baseClass = KProtocolInfo::protocolClass(baseURL.protocol());
    KURL destURL(_destURL);
    destURL.setPath(QDir::cleanDirPath(destURL.path()));
    QString destClass = KProtocolInfo::protocolClass(destURL.protocol());

    if (baseClass != ":local" && destClass == ":local") {
        return false;
    }

    return result;
}

#include "kapplication.moc"
