-- example for pgcomment

/** table example
  The table "example" shows how to set the column comments in a table.

  @column nr the primary key as artifical autoassigned integer

  @column name a person's name

  @column job a person's job description
*/
create table example (
  nr   serial,
  name text not null unique,
  job  text not null
);

/** FUNCTION normalize_name(name text)
normalizes "name".  Only lowercase characters, digits, dash and underscore survive the normalization.

@param name an arbitrary string.

@return name parameter normalized.
*/
CREATE OR REPLACE FUNCTION normalize_name(name text)
RETURNS TEXT
AS $$
BEGIN
  RETURN regexp_replace(lower(name), E'[^\\w\\d\\-_]', '', 'g');
END;
$$ LANGUAGE plpgsql IMMUTABLE STRICT;
