/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: xml_macros.h,v 1.2 2002/07/07 13:04:33 martine Exp $
 */

/* from conf_xml.c
 * 
 * basically, these XML_* functions run a series of ifs on the node name.
 * be sure to end with XML_GET_END, which prints error information if a node
 * wasn't handled.
 */
#define XML_GET_IF(key, what) \
if (xmlStrcmp(node->name, key) == 0) {\
	what \
} else
#define XML_GET_FUNC(key, dest, func) XML_GET_IF(key, dest = func(doc, node);)
#define XML_GET_STR(key, dest) XML_GET_FUNC(key, dest, xmlGetString)
#define XML_GET_INT(key, dest) XML_GET_FUNC(key, dest, xmlGetInt)
#define XML_GET_BOOL(key, dest) XML_GET_IF(key, dest = TRUE; )
#define XML_GET_LIST(key, dest, func) XML_GET_IF(key, dest = g_list_append(dest, func(doc, node)); )
/*#define XML_GET_END(func) \
{ fprintf(stderr, "%s: Unknown node %s.\n", func, node->name); }*/
#define XML_GET_END(func) \
if (xmlStrcmp(node->name, "text") != 0) { fprintf(stderr, "%s: Unknown node %s.\n", func, node->name); }


