/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: security.h,v 1.5 2002/08/28 21:48:35 martine Exp $
 */

#ifndef __SECURITY_H__
#define __SECURITY_H__

#include <gtk/gtkoptionmenu.h>

#include "ljtypes.h"

/* A SecMgr is a widget which manages a security setting.
 * The Security object now lives in ljtypes.[ch].
 */

#define SECMGR(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), secmgr_get_type(), SecMgr))

typedef struct _SecMgr       SecMgr;

GType      secmgr_get_type(void);
GtkWidget* secmgr_new     (gboolean withcustom);
void       secmgr_security_set(SecMgr *secmgr, const Security *security);
void       secmgr_security_set_force(SecMgr *secmgr, const Security *security);
void       secmgr_security_get(SecMgr *secmgr, Security *security);
void       secmgr_custom_set_sensitive(SecMgr *secmgr, gboolean sensitive);
guint32    custom_security_dlg_run(GtkWidget *parent, guint32 mask);

#endif /* __SECURITY_H__ */
